/**
 * Created by 三宝爹 on 2019/05/12.
 */


// 宽度设置成860 ，实际效果最像A4纸大小

import HTMLBrick from './HTMLBrick.js';
import Tools from '../util/Tools.js';

//接管文件上传
import CKEditorUploadAdapter from './CKEditorUploadAdapter.js'

function getPrintAgentURL(port)
{
    if (port == null) port = 17999;
    var serverIP = 'localhost';
    return 'ws://' + serverIP + ':' + port + '/ws';
}

const delaySaveTime=300; //当编辑变化时，延迟多久再回填到字段中

var CKEditorBrick = HTMLBrick.extend({


    properties:
        {
            "value":
                {
                    get: function () {return this.getValue();},
                    set: function (v) {this.setValue(v);}
                }
        },

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "ckeditor";
        this.dsn = config.dsn; //绑定的数据源
        this.dbcol = config.dbcol; //绑定的字段
        this.config = config;

        this.needReload = true; //临时标记，用来控制避免循环设置值和加载内容
        this.needFillback = true; //临时标记，表明是不是需要回填到字段，避免循环

        //2021.06.02补丁
        this.config.needMouseWheel = true; //表示自已需要滚轮操作，不能把滚轮操作传给SheetView去处理

        this.config.html = ` 
                     
                        <div class="centered main-container" >
                          <div class="document-editor">
                            <div id ="${this.DOMName}toolbar-container" class="toolbar-container"></div>
                              <div class="content-container">
                                <div id="${this.DOMName}editor" class="editor">
                                </div>
                              </div>
                          </div>
                        </div>                  
                   
                    `;
    },

    setParentCell: function (parentCell) {

        this.$uper.setParentCell.call(this, parentCell);
        var that = this;
        var book = this.pSheet.Book;
        //设置每次检索的条数
        var dsc = book.getDataSource(this.dsn);
        if (dsc != null)
        {
            var ds = dsc.dataStore;

            ds.EM.addListener(
                {

                    retrieveEnd: function (rowCount, withLastSelect) {
                        that.reloadValue();
                    },

                    retrieveOnceMoreEnd: function (retrieveTimes, rowCount) {
                        that.reloadValue();
                    },

                    itemChanged: function (row, col, oldValue, newValue) {
                        if (col == that.dbcol)
                        {
                            if (that.needReload)
                            {
                                that.reloadValue();
                            }
                        }

                    },

                    afterDeleteRow: function (row) {
                        that.reloadValue();
                    },
                    afterReset: function (action) { that.reloadValue();},

                    refreshRetrieveEnd: function (row) {that.reloadValue();},


                });
        } else
        {
            //alert(this.dsn + "不是合法的结果集，可能的原因：1 SQL不合法法，2 数据库连接不正常");
        }
    },

    /**
     * 创建DOM对象后，初始化
     */
    createDOM: function () {
        this.$uper.createDOM.call(this);
        let that = this;

        this.dom.addClass("ckeditor");
        let thisClassName = "ckeditor" + Tools.newGUID();
        this.dom.addClass(thisClassName);


        this.timerHandle = 0;

        //Array.from( editor.ui.componentFactory.names() ); 列出所有的plugin

        DecoupledDocumentEditor.create($(`.ckeditor #${this.DOMName}editor`)[0], {
            // toolbar: [ 'heading', '|', 'bold', 'italic', 'link' ]
            language: 'zh-cn',
            removePlugins: ['imageUpload',  'PasteFromOffice'], //禁用默认的PasteFromOffice ，因为它把所有文字全部转成了空格，原因不明
            htmlSupport: {  //允许插入html内容
                allow: [
                    {
                        name: /.*/,
                        attributes: true,
                        classes: true,
                        styles: true
                    }
                ]
            }

        })
            .then(editor => {
                let toolbarContainer = that.dom.find(`.toolbar-container`);

                toolbarContainer.prepend(editor.ui.view.toolbar.element);

                that.editor = editor;

                //扩展一个按钮
                // 如果走定制ckeditor插件的方式，比较麻烦，实现几个扩展类，再打包，太麻烦
                // 目的不外就是在工具栏上加一个按钮，做点自已想做的事， 直接dom上插入一个按钮，简单了事
                // 下面的按钮是复制ckeditor自已工具栏上的按钮的源码，其中的 svg 替换成 另一个图片的内容即ok了

                let appendAfterButton = $(`#${that.DOMName}toolbar-container`).find('.ck-heading-dropdown');

                let s = ` 

              <button  id ="${that.DOMName}-pasteFromWord" class="ck ck-button ck-off" type="button" tabindex="-1" aria-labelledby="ck-editor__aria-label_e9afc86a8749034efbdf53d9967ecff45" aria-pressed="false"><svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="m14 0 5 4.5V20H3v-1.5h14.5v-12h-5v-5h-8v4H3V0h11ZM8.5 7a1.5 1.5 0 0 1 1.493 1.356L10 8.5v7a1.5 1.5 0 0 1-1.356 1.493L8.5 17h-7a1.5 1.5 0 0 1-1.493-1.356L0 15.5v-7a1.5 1.5 0 0 1 1.356-1.493L1.5 7h7ZM7.483 9.795l-.042.088-.986 2.534-.947-2.528-.043-.092a.601.601 0 0 0-1.042.008l-.042.093-.883 2.465-.937-2.475-.042-.089a.6.6 0 0 0-1.107.42l.027.093 1.514 4 .044.092a.601.601 0 0 0 1.041-.01l.041-.092.88-2.458.925 2.467.046.096a.601.601 0 0 0 1.032 0l.043-.09 1.554-4 .028-.093a.6.6 0 0 0-1.104-.43ZM14 2v3h3.3L14 2Z"></path></svg><span class="ck ck-tooltip ck-tooltip_s"><span class="ck ck-tooltip__text">粘贴 word 文档</span></span><span class="ck ck-button__label" id="ck-editor__aria-label_e9afc86a8749034efbdf53d9967ecff45">粘贴 word 文档</span></button>
                `;
                //
                // 实现扩展功能：从word粘贴， ckeditor自已的从word粘贴不好用， 文字全部被替换成了 空格，原因不明，可能是配置的问题，
                // 找不到原因，不找了，自已实现一个， 原理是，先把 word内容复制到
                // 因为禁用了默认的PasteFromOffice，所以粘贴反而更正常，文字都正常，只需要把图片分析出来上传即可

               // appendAfterButton.after(s);

               // $(`#${that.DOMName}-pasteFromWord`).on('click', function () { that.pasteFromWord();});


                if (!that.canFillback())
                {
                    editor.isReadOnly = true;
                }

                // 这个地方加载了适配器
                editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {

                    let fileUploadURL = that.config.homeURL || "UploadFile";

                    return new CKEditorUploadAdapter(loader, fileUploadURL, that.pSheet);
                };

                //内容编辑后，回填操作的处理
                editor.model.document.on('change:data', function () {

                    if (that.timerHandle != 0)
                    {
                        window.clearTimeout(that.timerHandle);
                    }

                    // bind(that)是强制fillback执行时，上下文切换到that中，即 fillback中的this 指向的是自己，不然会指向window
                    that.timerHandle = setTimeout(that.fillback.bind(that), delaySaveTime);

                });

                $(`#${that.DOMName}editor`).on('paste', function () {

                    setTimeout(function() {
                        that.parsePastedContent();
                    },400);
                });

                that.pSheet.Book.EM.fire("brickOnload", [that.pSheet, that]);

            })
            .catch(err => {
                console.error(err.stack);
            });


    },

    onSize: function (rc) {


        console.info(" ckeditor resize :" + rc.toString());

        this.dom.find(' .main-container').css({
            width: rc.width + 'px',
            height: (rc.height - 2) + 'px',
            'max-height': (rc.height - 2) + 'px'
        });
        this.dom.find(' .content-container').css({
            height: (rc.height - 42) + 'px',
            'max-height': (rc.height - 42) + 'px'
        });
    },

    //重新从ds中加载内容
    reloadValue: function () {
        var book = this.pSheet.Book;
        var dsc = book.getDataSource(this.dsn);
        if (dsc == null) return;
        var ds = dsc.dataStore;
        var v = ds.getString(dsc.currentBindRow, this.dbcol);
        if (this.dom == null) this.createDOM(); //确保已经创建
        var that = this;
        setTimeout(function () {

            // that.editor.setData(v);
            that.needFillback = false;
            that.insertContent(v);
            setTimeout( function() {
                that.needFillback = true;
            }, delaySaveTime+200 ); //标记要对回填到字段延时更长一点
        }, 100);

    },


    canFillback: function () {
        //简单粗暴 ，以后再优化
        var url = window.location.href;
        if ((url.indexOf("billedit.jsp") > 0 || url.indexOf("billedit?") > 0) && url.indexOf("action=view") > 0) return false;
        return true;
    },

    //将内容回填回去
    fillback: function () {
        if (this.editor.isReadOnly) return;
        if (!this.canFillback()) return;

        //初始加载好数据，并把数据填到编辑器后，不需要再触发回填到字段
        if (!this.needFillback) return;

        if (this.timerHandle != 0) window.clearTimeout(this.timerHandle);
        this.timerHandle = 0;

        // TODO 2021.12.07  .getData() 会丢失css样式及属性，原因不明，可能是设置的问题
        // 换成直接获取 innerHTML 临时解决问题
        //var data = this.editor.getData();
        var data = this.getContent();
        console.info("========回填===========");
        console.info(data);

        var dsc = book.getDataSource(this.dsn);
        if (dsc == null) return;
        var ds = dsc.dataStore;
        this.needReload = false; //避免因为 ds.setValue 触发 itemChange，而又重新加载内容
        ds.setValue(dsc.currentBindRow, this.dbcol, data);
        this.needReload = true;

    },

    /**
     * 插入内容到编辑器中
     * @param content
     */
    insertContent: function (content) {
        var editor = this.editor;

        var viewFragment = editor.data.processor.toView(content);
        var modelFragment = editor.data.toModel(viewFragment);
        //插入模型片段
        editor.model.insertContent(modelFragment, editor.model.document.selection);
    },


    pasteFromWord: function () {
        let that = this;
        let dlg = $.dialog({
            title: '',
            useBootstrap: false,
            boxWidth: '680px',
            content: ` 
                     <form action="" class="formName"> 
                     <div><label><ol><li>复制word内容</li>
                     <li>点击下面的输入框</li>
                     <li>右键粘贴或按 Ctrl + V</li><ol>
                     </label></div>
                     <div style="overflow:auto; height:300px;border:1px dotted darkgray;">
                     <div class="form-group" id="pasteFromWord" 
                     style=" border:0;
                     width:625px;
                     height:6000px;
                     outline: none;
                      " 
                     contenteditable="true"> 
                    
                     
                    </div> 
                    </div>
                    </form> `,
            buttons: {},


            onContentReady: function () {
                // bind to events
                var jc = this;
                var obj = this.$content.find('#pasteFromWord');
                obj[0].focus();

                obj.on('paste', function (evt) {

                    setTimeout(function () {
                        var html = obj.html();
                        that.pickLocalImgAndUpload(html);

                        dlg.close();
                    }, 500);
                });


            }
        });

    },

    /**
     * 得到编辑框中的内容 ，
     * @returns {String}
     */
    getContent:function()
    {
        return $(`#${this.DOMName}editor`).html();
    },

    parsePastedContent:function()
    {
        let that=this;
        let imgs=$(`#${this.DOMName}editor`).find("img");
        let localImgs=[];
        for( let i=0;i<imgs.length;i++)
        {
            let img= imgs[i];
            if( ! img.src.startsWith("file:///")) continue;
            localImgs.push(img);
        }


        let totalImageCount = localImgs.length;
        let uploadedCount = 0;
        //所有待处理图片控制并发数为1，开始上传
        //并发数多，可能更快，但是上传进度不是线程的
        showInfoPane("* 准备上传图片");
        Tools.asyncPool(4, localImgs, function (img, imgs) {
            return new Promise(function (resolve, reject) {


                let fileName = img.src;
                if (fileName.startsWith("file:///"))
                {
                    fileName = fileName.substring(7);//去掉前面的 file:///
                } else
                {
                    resolve(1);//忽略，直接结束
                }

                let shortName = fileName.substring(Math.max(0, fileName.lastIndexOf("/") + 1));

                let extName = fileName.substring(fileName.lastIndexOf(".") + 1);//扩展名
                let url = getPrintAgentURL();
                let websocket;
                try
                {
                    websocket = new WebSocket(url);

                } catch (err)
                {
                    resolve(1); //直接over
                    return;
                }

                websocket.binaryType = 'blob';
                websocket.onopen = function (ev) {
                    //页面无法访问本地文件，借助打印助手去读取图片内容
                    let cmd = {action: 'getFileBase64Content', fileName: fileName};
                    let t = JSON.stringify(cmd);
                    websocket.send(t);
                };

                websocket.onerror = function (ev) {
                    toastr.info("无法连接打印助手，文档中的图片将无法自动上传，请单独复制粘贴每张图片");
                    resolve(1);
                    return;
                };

                websocket.onmessage = function (ev) {
                    var cmd = ev.data;
                    cmd = JSON.parse(cmd);
                    if (cmd.action == 'returnFileBase64Content')//收到图片数据，上传，并替换地址
                    {
                        let imgData = cmd.data;
                        websocket.close();

                        //把 imgData上传
                        //使用的是图片上传相同的参数，下面代码参考自本控件的 CKEditorUploadAdapter.js
                        let data = new FormData();
                        data.append('base64ImageData', imgData); //直接构建一个base64图片数据
                        data.append('base64ImageFileType', extName); //文件扩展名

                        //允许应用在事件中往data中注入参数，因为提交到的url它可能需要更多的参数，而不仅仅是选择文件
                        that.pSheet.Book.EM.fire("buildCKEditorUploadParam", [data]);
                        // Send the request.
                        let fileUploadURL = that.config.homeURL || "UploadFile";
                        console.info(fileUploadURL)
                        axios.post(fileUploadURL, data, {
                            timeout: 300 * 10000,
                            withCredentials: true,
                            onUploadProgress: function (progressEvent) {
                                let percent = Math.round(progressEvent.loaded / progressEvent.total * 100);
                                showInfoPane("* " + shortName + " 进度：" + percent + "%，总进度：" + (uploadedCount + 1) + "/" + totalImageCount);
                                console.info(progressEvent.loaded);
                            }
                        }).then(function (res) {


                            uploadedCount++;
                            //触发文件上传完成事件，比如在单据中，可以刷新附件

                            that.pSheet.Book.EM.fire("afterCKEditorUploadFile", [res]);
                            //把html中的地址替换掉
                            img.src=   res.data.url_img  ;

                            resolve(1);
                        }).catch(function (err) {
                            uploadedCount++;
                            console.dir(err);
                            resolve(1);
                        });

                    }
                }

            });
        }).then(function () {
            //全部处理完成后
            hideInfoPane();
            that.fillback(); //处理好的内容重新回填到字段中

        });

    },
    /**
     * 从 HTML中找出  src="file:// 的图片，把它们上传，并替换为新的url地址 ，最后把html插入到ckeditor中
     * 前提是必须启动 打印助手， 需要使用它来获取本地文件的内容，然后把它们上传
     * @param html
     */
    pickLocalImgAndUpload: function (html) {
        // 第一步：找到file:/// 本地文件

        let that = this;

        console.info(html);

        let imgs = html.match(/src="file:[^"]+"/gi);
        if (imgs == null || imgs.length == 0) //没的图片，那么直接插入内容，结束
        {
            this.insertContent(html);
            return;
        }

        let totalImageCount = imgs.length;
        let uploadedCount = 0;
        //所有待处理图片控制并发数为1，开始上传
        //并发数多，可能更快，但是上传进度不是线程的
        showInfoPane("* 准备上传图片");
        Tools.asyncPool(4, imgs, function (img, imgs) {
            return new Promise(function (resolve, reject) {


                let fileName = img.substring(img.indexOf('"') + 1, img.lastIndexOf('"')); //截取出文件名
                if (fileName.startsWith("file:///"))
                {
                    fileName = fileName.substring(7);//去掉前面的 file://
                } else
                {
                    resolve(1);//忽略，直接结束
                }

                let shortName = fileName.substring(Math.max(0, fileName.lastIndexOf("/") + 1));

                let extName = fileName.substring(fileName.lastIndexOf(".") + 1);//扩展名
                let url = getPrintAgentURL();
                let websocket;
                try
                {
                    websocket = new WebSocket(url);

                } catch (err)
                {
                    resolve(1); //直接over
                    return;
                }

                websocket.binaryType = 'blob';
                websocket.onopen = function (ev) {
                    //页面无法访问本地文件，借助打印助手去读取图片内容
                    let cmd = {action: 'getFileBase64Content', fileName: fileName};
                    let t = JSON.stringify(cmd);
                    websocket.send(t);
                };

                websocket.onerror = function (ev) {
                    toastr.info("无法连接打印助手，文档中的图片将无法自动上传，请单独复制粘贴每张图片");
                    resolve(1);
                    return;
                };

                websocket.onmessage = function (ev) {
                    var cmd = ev.data;
                    cmd = JSON.parse(cmd);
                    if (cmd.action == 'returnFileBase64Content')//收到图片数据，上传，并替换地址
                    {
                        let imgData = cmd.data;
                        websocket.close();

                        //把 imgData上传
                        //使用的是图片上传相同的参数，下面代码参考自本控件的 CKEditorUploadAdapter.js
                        let data = new FormData();
                        data.append('base64ImageData', imgData); //直接构建一个base64图片数据
                        data.append('base64ImageFileType', extName); //文件扩展名

                        //允许应用在事件中往data中注入参数，因为提交到的url它可能需要更多的参数，而不仅仅是选择文件
                        that.pSheet.Book.EM.fire("buildCKEditorUploadParam", [data]);
                        // Send the request.
                        let fileUploadURL = that.config.homeURL || "UploadFile";
                        console.info(fileUploadURL)
                        axios.post(fileUploadURL, data, {
                            timeout: 300 * 10000,
                            withCredentials: true,
                            onUploadProgress: function (progressEvent) {
                                let percent = Math.round(progressEvent.loaded / progressEvent.total * 100);
                                showInfoPane("* " + shortName + " 进度：" + percent + "%，总进度：" + (uploadedCount + 1) + "/" + totalImageCount);
                                console.info(progressEvent.loaded);
                            }
                        }).then(function (res) {


                            uploadedCount++;
                            //触发文件上传完成事件，比如在单据中，可以刷新附件

                            that.pSheet.Book.EM.fire("afterCKEditorUploadFile", [res]);
                            //把html中的地址替换掉
                            html = html.replace(img, 'src="' + res.data.url_img + '"');

                            resolve({default: res.data.url_img});
                        }).catch(function (err) {
                            uploadedCount++;
                            console.dir(err);
                            resolve(1);
                        });

                    }
                }

            });
        }).then(function () {
            //全部处理完成后
            hideInfoPane();
            that.insertContent(html);

        });


    },


});


export default CKEditorBrick;
