/**
 * ajax的简单实现
 *
 * 把调用方式缺省改成了同步。
 */


import Util from './Util.js';

if (typeof jQuery != 'undefined')
{

    //缺省改成同步
    // $.ajaxSetup({
    //     async: false
    // });
    // return jQuery;
}


//当没有包含jquery时， 返回下面的实现，注音，它与jquery的 ajax ，及 get, post 具有相同的参数 定义和使用方法

var ajax = function (opt) {
        var url = opt.url;
        var asyncCall = opt.asyncCall || false;//缺省是同步，程序上容易控制，但可能会卡死浏览器，待测
        var method = (opt.type || 'GET').toUpperCase();
        var data = opt.data || null;
        var success = opt.success || function () {};
        var failure = opt.failure || function () {};
        var timeout = opt.timeout || 1000 * 300;
        var isTimeout = false;
        var header = opt.header||null;

        var xhr = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4)
            {
                var s = xhr.status;
                if (s >= 200 && s < 300 || s == 304)
                {
                    success(xhr.responseText);
                } else
                {
                    failure(xhr.responseText);
                }
            } else
            {
                if (isTimeout)
                {
                    clearTimeout(timer);
                    failure("timeout");
                    return;
                }

            }
        };

        var time = false;//是否超时
        var timer = setTimeout(function () {
            isTimeout = true;
            xhr.abort();//请求中止
        }, timeout);

        //当是get方式时，请直接拼好data ,这里不接受json对象
        if (method == 'GET' && data)
        {
            url += (url.indexOf('?') == -1 ? '?' : '&') + data;
            data = null;
        }

        xhr.withCredentials = opt.withCredentials || false;
        xhr.open(method, url, asyncCall);
        if (method == 'POST')
        {
            xhr.setRequestHeader('Content-type', 'application/json');
        }


        if(header)
        {
            for (var k in header)
            {
                let v = header[k];
                xhr.setRequestHeader(k, v);
            }
        }


    //超级大坑，如果不转换成String，那么会出现cors错误

        if (Util.isString(data))
        {
            xhr.send(data);
        } else if (Util.isObject(data))
        {
            xhr.send(JSON.stringify(data));
        }
        return xhr;
    }
;

var get = function (url, data, success, dataType, asyncCall) {
    return ajax({url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall});
};

var post = function (url, data, success, dataType, asyncCall,header) {
    return ajax({type: 'POST', url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall, header:header});
};

var rpc = function (serviceName, className, method, jsonParamString) {


    var timestamp = new Date().getTime();

    var paramString = jsonParamString;
    if (jsonParamString == undefined) paramString = {};  //可能没有参数


    var ret = '';
    var asyncCall = false;//缺省是同步调用
    var success = function (data) {
        ret = data;
    };
    post("RPCRouter?timestamp=" + timestamp,
        JSON.stringify({  //需转成字符串，不然，会以 key ,value 的形式传递
            $servicename: serviceName,
            classname: className,
            methodname: method,
            parameter: paramString
        })
        , success, "text", asyncCall);

    return JSON.parse(ret);


};

var AJAX= {
    ajax: ajax,
    get: get,
    post: post,
    rpc: rpc
};


export default AJAX;


