/**
 * 计量单位转换
 * 参考自 org.apache.xmlgraphics.util.UnitConv
 */


const IN2MM = 25.4;
const IN2CM = 2.54;
const IN2PT = 72;
const PICA = "pc";
const POINT = "pt";
const MM = "mm";
const CM = "cm";
const INCH = "in";
const MPT = "mpt";
const PX = "px";

var UnitConv = {


    mm2pt: function (mm) {
        return Math.floor(mm * 72.0 / 25.399999618530273);
    },

    mm2mpt: function (mm) {
        return Math.floor(mm * 1000.0 * 72.0 / 25.399999618530273);
    },

    pt2mm: function (pt) {


        return Math.floor(pt * 25.399999618530273 / 72.0);
    },

    mm2in: function (mm) {
        return Math.floor(mm / 25.399999618530273);
    },

    in2mm: function (inch) {
        return Math.floor(inch * 25.399999618530273);
    },

    in2mpt: function (inch) {
        return Math.floor(inch * 72.0 * 1000.0);
    },

    in2pt: function (inch) {
        return Math.floor(inch * 72.0);
    },

    mpt2in: function (mpt) {
        return Math.floor(mpt / 72.0 / 1000.0);
    },

    mm2px: function (mm, resolution) {
        return Math.floor(mm2in(mm) * resolution);
    },

    mpt2px: function (mpt, resolution) {
        return Math.floor(mpt2in(mpt) * resolution);
    }
};


export default UnitConv;
