/**
 * Created by zengjun on 2017/4/27.
 */


import Util from "./Util.js";
import Color from "../gdi/Color.js";
import ObjectTool from '../db/ObjectTool.js';

import UniformDataType from '../core/UniformDataType.js';


var delayRunHandle = {};

var Tools = {
    /**
     * 新建一个GUID
     * @param splitChar  分隔符号
     * @returns {string}
     */
    newGUID: function (splitChar) {
        if (splitChar == undefined) splitChar = "";
        var guid = "";
        for (var i = 1; i <= 32; i++)
        {
            var n = Math.floor(Math.random() * 16.0).toString(16);
            guid += n;
            if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
            {
                guid += splitChar;
            }
        }
        return guid;

    },


    /**
     *
     * @param g
     * @param border_style   0 无  1 实线 2,3,4 虚线 5  双线
     * @param border_width
     * @param border_color
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     */
    drawCellBorderLine: function (/*Graphics2D*/ g, border_style, border_width, border_color, x1, y1, x2, y2) {
        if (border_style == 0) return; // 无边框，直接返回
        if (border_width == 0) return;
        if (border_color == null) return;

        g.save();

        if (border_width > 3) border_width = 3;


        g.setColor(border_color);
        g.setLineWidth(border_width);
        g.setLineCap("round");

        if (border_style == 1)// 实线
        {


        }

        if (border_style >= 2 && border_style <= 4) // 虚线
        {
            g.setLineDash(border_style);

        }


        if (border_style == 5) // 双线
        {
            g.setLineWidth(3);

        }


        g.beginPath();
        g.drawLine(x1, y1, x2, y2);


        g.closePath();
        g.stroke();

        if (border_style == 5) // 双线
        {
            g.beginPath();
            g.setColor(Color.white);
            g.setLineWidth(1);
            g.drawLine(x1, y1, x2, y2);
            g.closePath();
            g.stroke();
        }

        g.restore();

    },


    /**
     * 拼得小数的格式
     * @param DecimalCount　　小数位数
     * @param DecimalSeparator　　小数点字符
     * @param ShowComma　　　是否显示千分位
     * @param GroupingSeparator　　千分位符号
     * @return
     */
    getDecimalPattern: function (DecimalCount, DecimalSeparator, ShowComma, GroupingSeparator) {
        var pattern;
        if (DecimalCount == 0)
        {
            pattern = "###,###,###,###,###,###,##0";
        } else
        {
            var t = "00000000000000000000";
            t = t.substring(0, DecimalCount);
            pattern = "###,###,###,###,###,###,##0." + t;
        }

        if (DecimalSeparator != '.')
        {
            pattern = pattern.replace(/[.]/g, DecimalSeparator);
        }
        if (!ShowComma)
        {
            pattern = pattern.replace(/[,]/g, '');
        }
        if (ShowComma && GroupingSeparator != ',')
        {
            pattern = pattern.replace(/[,]/g, GroupingSeparator);
        }
        return pattern;

    },

    copyToClipboard: function (text) {

        var textArea = document.createElement("textarea");
        textArea.style.position = 'fixed';
        textArea.style.top = '0';
        textArea.style.left = '0';
        textArea.style.width = '2em';
        textArea.style.height = '2em';
        textArea.style.padding = '0';
        textArea.style.border = 'none';
        textArea.style.outline = 'none';
        textArea.style.boxShadow = 'none';
        textArea.style.background = 'transparent';
        textArea.value = text;
        document.body.appendChild(textArea);
        textArea.select();

        try
        {
            var successful = document.execCommand('copy');
            if (!successful) console.error('浏览器不支持复制功能');

        } catch (err)
        {
            console.error('浏览器不支持复制功能');
        }

        document.body.removeChild(textArea);
    },

    delayRun: function (key, func, delay) {

        console.info("delayRun key= "+key);
        if( key==null ) key= Tools.newGUID();
        var handle = delayRunHandle[key];

        if (handle != undefined)
        {
             console.info(key+"任务被取消");
            clearTimeout(handle);
            delayRunHandle[key] = undefined;
        }

        delayRunHandle[key] = setTimeout(function () {
            func();
            //console.info( key+"执行完成");
            clearTimeout(delayRunHandle[key]);
            delayRunHandle[key] = undefined;
        }, delay);

    },

    minutesBetween: function (big, small) {
        //一定要克隆一份，不然，会把 big, small  改变
        var dt1 = ObjectTool.ObjectClone(big);
        var dt2 = ObjectTool.ObjectClone(small);

        dt1 = ObjectTool.changeType(dt1, UniformDataType.$Datetime);
        dt2 = ObjectTool.changeType(dt2, UniformDataType.$Datetime);

        dt1.setSeconds(0);
        dt1.setMilliseconds(0);

        dt2.setSeconds(0);
        dt2.setMilliseconds(0);

        return ( dt1.getTime() - dt2.getTime() ) / 1000 / 60;


    },

    normalizeImageSrc: function (s) {
        var str = s;
        if (s.toLowerCase().indexOf('<img') < 0) str = '<img src="' + str + '">';

        //如果指定了width, height 要把它去掉，不然会裁剪掉
        str = str.replace(/width\s*=\s*[\'\"]([^\'\"]*)[\'\"]/, '');
        str = str.replace(/height\s*=\s*[\'\"]([^\'\"]*)[\'\"]/, '');

        return str;

    },

    /**
     *
     * MD5 (Message-Digest Algorithm)
     * http://www.webtoolkit.info/
     *
     **/
    MD5: function (string) {
        function RotateLeft(lValue, iShiftBits)
        {
            return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
        }

        function AddUnsigned(lX, lY)
        {
            var lX4, lY4, lX8, lY8, lResult;
            lX8 = (lX & 0x80000000);
            lY8 = (lY & 0x80000000);
            lX4 = (lX & 0x40000000);
            lY4 = (lY & 0x40000000);
            lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
            if (lX4 & lY4)
            {
                return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
            }
            if (lX4 | lY4)
            {
                if (lResult & 0x40000000)
                {
                    return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
                } else
                {
                    return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
                }
            } else
            {
                return (lResult ^ lX8 ^ lY8);
            }
        }

        function F(x, y, z) { return (x & y) | ((~x) & z); }

        function G(x, y, z) { return (x & z) | (y & (~z)); }

        function H(x, y, z) { return (x ^ y ^ z); }

        function I(x, y, z) { return (y ^ (x | (~z))); }

        function FF(a, b, c, d, x, s, ac)
        {
            a = AddUnsigned(a, AddUnsigned(AddUnsigned(F(b, c, d), x), ac));
            return AddUnsigned(RotateLeft(a, s), b);
        };

        function GG(a, b, c, d, x, s, ac)
        {
            a = AddUnsigned(a, AddUnsigned(AddUnsigned(G(b, c, d), x), ac));
            return AddUnsigned(RotateLeft(a, s), b);
        };

        function HH(a, b, c, d, x, s, ac)
        {
            a = AddUnsigned(a, AddUnsigned(AddUnsigned(H(b, c, d), x), ac));
            return AddUnsigned(RotateLeft(a, s), b);
        };

        function II(a, b, c, d, x, s, ac)
        {
            a = AddUnsigned(a, AddUnsigned(AddUnsigned(I(b, c, d), x), ac));
            return AddUnsigned(RotateLeft(a, s), b);
        };

        function ConvertToWordArray(string)
        {
            var lWordCount;
            var lMessageLength = string.length;
            var lNumberOfWords_temp1 = lMessageLength + 8;
            var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
            var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
            var lWordArray = Array(lNumberOfWords - 1);
            var lBytePosition = 0;
            var lByteCount = 0;
            while (lByteCount < lMessageLength)
            {
                lWordCount = (lByteCount - (lByteCount % 4)) / 4;
                lBytePosition = (lByteCount % 4) * 8;
                lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition));
                lByteCount++;
            }
            lWordCount = (lByteCount - (lByteCount % 4)) / 4;
            lBytePosition = (lByteCount % 4) * 8;
            lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
            lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
            lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
            return lWordArray;
        };

        function WordToHex(lValue)
        {
            var WordToHexValue = "", WordToHexValue_temp = "", lByte, lCount;
            for (lCount = 0; lCount <= 3; lCount++)
            {
                lByte = (lValue >>> (lCount * 8)) & 255;
                WordToHexValue_temp = "0" + lByte.toString(16);
                WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length - 2, 2);
            }
            return WordToHexValue;
        };

        function Utf8Encode(string)
        {
            string = string.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < string.length; n++)
            {
                var c = string.charCodeAt(n);
                if (c < 128)
                {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048))
                {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else
                {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            return utftext;
        };
        var x = Array();
        var k, AA, BB, CC, DD, a, b, c, d;
        var S11 = 7, S12 = 12, S13 = 17, S14 = 22;
        var S21 = 5, S22 = 9, S23 = 14, S24 = 20;
        var S31 = 4, S32 = 11, S33 = 16, S34 = 23;
        var S41 = 6, S42 = 10, S43 = 15, S44 = 21;
        string = Utf8Encode(string);
        x = ConvertToWordArray(string);
        a = 0x67452301;
        b = 0xEFCDAB89;
        c = 0x98BADCFE;
        d = 0x10325476;
        for (k = 0; k < x.length; k += 16)
        {
            AA = a;
            BB = b;
            CC = c;
            DD = d;
            a = FF(a, b, c, d, x[k + 0], S11, 0xD76AA478);
            d = FF(d, a, b, c, x[k + 1], S12, 0xE8C7B756);
            c = FF(c, d, a, b, x[k + 2], S13, 0x242070DB);
            b = FF(b, c, d, a, x[k + 3], S14, 0xC1BDCEEE);
            a = FF(a, b, c, d, x[k + 4], S11, 0xF57C0FAF);
            d = FF(d, a, b, c, x[k + 5], S12, 0x4787C62A);
            c = FF(c, d, a, b, x[k + 6], S13, 0xA8304613);
            b = FF(b, c, d, a, x[k + 7], S14, 0xFD469501);
            a = FF(a, b, c, d, x[k + 8], S11, 0x698098D8);
            d = FF(d, a, b, c, x[k + 9], S12, 0x8B44F7AF);
            c = FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
            b = FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
            a = FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
            d = FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
            c = FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
            b = FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
            a = GG(a, b, c, d, x[k + 1], S21, 0xF61E2562);
            d = GG(d, a, b, c, x[k + 6], S22, 0xC040B340);
            c = GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
            b = GG(b, c, d, a, x[k + 0], S24, 0xE9B6C7AA);
            a = GG(a, b, c, d, x[k + 5], S21, 0xD62F105D);
            d = GG(d, a, b, c, x[k + 10], S22, 0x2441453);
            c = GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
            b = GG(b, c, d, a, x[k + 4], S24, 0xE7D3FBC8);
            a = GG(a, b, c, d, x[k + 9], S21, 0x21E1CDE6);
            d = GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
            c = GG(c, d, a, b, x[k + 3], S23, 0xF4D50D87);
            b = GG(b, c, d, a, x[k + 8], S24, 0x455A14ED);
            a = GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
            d = GG(d, a, b, c, x[k + 2], S22, 0xFCEFA3F8);
            c = GG(c, d, a, b, x[k + 7], S23, 0x676F02D9);
            b = GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
            a = HH(a, b, c, d, x[k + 5], S31, 0xFFFA3942);
            d = HH(d, a, b, c, x[k + 8], S32, 0x8771F681);
            c = HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
            b = HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
            a = HH(a, b, c, d, x[k + 1], S31, 0xA4BEEA44);
            d = HH(d, a, b, c, x[k + 4], S32, 0x4BDECFA9);
            c = HH(c, d, a, b, x[k + 7], S33, 0xF6BB4B60);
            b = HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
            a = HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
            d = HH(d, a, b, c, x[k + 0], S32, 0xEAA127FA);
            c = HH(c, d, a, b, x[k + 3], S33, 0xD4EF3085);
            b = HH(b, c, d, a, x[k + 6], S34, 0x4881D05);
            a = HH(a, b, c, d, x[k + 9], S31, 0xD9D4D039);
            d = HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
            c = HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
            b = HH(b, c, d, a, x[k + 2], S34, 0xC4AC5665);
            a = II(a, b, c, d, x[k + 0], S41, 0xF4292244);
            d = II(d, a, b, c, x[k + 7], S42, 0x432AFF97);
            c = II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
            b = II(b, c, d, a, x[k + 5], S44, 0xFC93A039);
            a = II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
            d = II(d, a, b, c, x[k + 3], S42, 0x8F0CCC92);
            c = II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
            b = II(b, c, d, a, x[k + 1], S44, 0x85845DD1);
            a = II(a, b, c, d, x[k + 8], S41, 0x6FA87E4F);
            d = II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
            c = II(c, d, a, b, x[k + 6], S43, 0xA3014314);
            b = II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
            a = II(a, b, c, d, x[k + 4], S41, 0xF7537E82);
            d = II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
            c = II(c, d, a, b, x[k + 2], S43, 0x2AD7D2BB);
            b = II(b, c, d, a, x[k + 9], S44, 0xEB86D391);
            a = AddUnsigned(a, AA);
            b = AddUnsigned(b, BB);
            c = AddUnsigned(c, CC);
            d = AddUnsigned(d, DD);
        }
        var temp = WordToHex(a) + WordToHex(b) + WordToHex(c) + WordToHex(d);
        return temp.toLowerCase();
    },


    // 解压
    unzip: function (str) {
        // 将数字数组转换成字节数组
        var binData = this.base642ArrayBuffer(str);
        // 解压
        var data = pako.inflate(binData);
        // 将GunZip ByTAREAR转换回ASCII字符串
        return String.fromCharCode.apply(null, new Uint16Array(data));
    },

    // 压缩
    zip: function (str) {
        var binaryString = pako.gzip(str);
        return this.arrayBufferToBase64(binaryString);

    },


    base642ArrayBuffer: function (dataURI) {

        var base64 = dataURI;
        var raw = window.atob(base64);
        var rawLength = raw.length;
        var array = new Uint8Array(new ArrayBuffer(rawLength));

        for (let i = 0; i < rawLength; i++)
        {
            array[i] = raw.charCodeAt(i);
        }
        return array;
    }
    ,

    arrayBufferToBase64: function (raw) {
        var base64 = '';
        var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
        var bytes = new Uint8Array(raw);
        var byteLength = bytes.byteLength;
        var byteRemainder = byteLength % 3;
        var mainLength = byteLength - byteRemainder;
        var a, b, c, d;
        var chunk;
        // Main loop deals with bytes in chunks of 3
        for (let i = 0; i < mainLength; i = i + 3)
        {
            // Combine the three bytes into a single integer
            chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2];
            // Use bitmasks to extract 6-bit segments from the triplet
            a = (chunk & 16515072) >> 18; // 16515072 = (2^6 - 1) << 18
            b = (chunk & 258048) >> 12; // 258048 = (2^6 - 1) << 12
            c = (chunk & 4032) >> 6; // 4032 = (2^6 - 1) << 6
            d = chunk & 63; // 63 = 2^6 - 1
            // Convert the raw binary segments to the appropriate ASCII encoding
            base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d];
        }
        // Deal with the remaining bytes and padding
        if (byteRemainder == 1)
        {
            chunk = bytes[mainLength];
            a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2;
            // Set the 4 least significant bits to zero
            b = (chunk & 3) << 4 // 3 = 2^2 - 1;
            base64 += encodings[a] + encodings[b] + '==';
        }
        else if (byteRemainder == 2)
        {
            chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1];
            a = (chunk & 16128) >> 8 // 16128 = (2^6 - 1) << 8;
            b = (chunk & 1008) >> 4 // 1008 = (2^6 - 1) << 4;
            // Set the 2 least significant bits to zero
            c = (chunk & 15) << 2 // 15 = 2^4 - 1;
            base64 += encodings[a] + encodings[b] + encodings[c] + '=';
        }
        return base64;
    },

    /**
     * 把    col1:ds1.col1   col2:ds1.col2  这样的对应关系配置，转换成{col1: {ds:'ds1' , col:'col1' } ....}这样的JSON键值对
     *
     * @param maps
     */
    buildColMap: function (maps) {

        /*
            *  *	0次或多次
            ？	0次或者1次
            {n}	N次	[0-9]
            {n,m}	n到m次
         */

        maps = maps.replace(/(\s)*:(\s)*/g, ':');  //冒号前后的空格删除

        var items = maps.split(/(\s)/);  // 回车键是分隔符
        var ret = [];
        for (let i = 0; i < items.length; i++)
        {
            var t = items[i].split(':');
            if (t.length < 2) continue;
            var sourceCol = t[0].trim();
            var targetCol = t[1].trim();
            var s = targetCol.split('.');
            if (s.length < 2)
            {
                ret.push({source: sourceCol, target: {alias: s[0].trim()}}); //可能是别名
            } else
            {
                ret.push({source: sourceCol, target: {ds: s[0].trim(), col: s[1].trim()}});//是结果集
            }
        }
        return ret;
    },

    /**
     * 是不是移动设备
     * @returns {*}
     */
    isMobile: function () {
        if (this.m_isMobile != undefined) return this.m_isMobile;


        if (navigator.userAgent.indexOf('Android') > 0
            || navigator.userAgent.indexOf('webOS') > 0
            || navigator.userAgent.indexOf('iPhone') > 0
            || navigator.userAgent.indexOf('iPad').index > 0
            || navigator.userAgent.indexOf('iPod') > 0
            || navigator.userAgent.indexOf('BlackBerry') > 0
            || navigator.userAgent.indexOf('Windows Phone') > 0
        )
        {
            this.m_isMobile = true;
        } else
        {
            this.m_isMobile = false;
        }

        return this.m_isMobile;

    },

    isDD: function () {

        if (this.m_dingtalk != undefined) return this.m_dingtalk;

        var sUserAgent = navigator.userAgent.toLowerCase();

        this.m_dingtalk = sUserAgent.indexOf('dingtalk') >= 0;

        return this.m_dingtalk;

    },

    fireKeyEvent: function (el, evtType, keyCode) {
        var doc = el.ownerDocument,
            win = doc.defaultView || doc.parentWindow,
            evtObj;
        if (doc.createEvent)
        {
            if (win.KeyEvent)
            {
                evtObj = doc.createEvent('KeyEvents');
                evtObj.initKeyEvent(evtType, true, true, win, false, false, false, false, keyCode, 0);
            }
            else
            {
                evtObj = doc.createEvent('UIEvents');
                Object.defineProperty(evtObj, 'keyCode', {
                    get: function () { return this.keyCodeVal; }
                });
                Object.defineProperty(evtObj, 'which', {
                    get: function () { return this.keyCodeVal; }
                });
                evtObj.initUIEvent(evtType, true, true, win, 1);
                evtObj.keyCodeVal = keyCode;
                if (evtObj.keyCode !== keyCode)
                {
                    console.log("keyCode " + evtObj.keyCode + " 和 (" + evtObj.which + ") 不匹配");
                }
            }
            el.dispatchEvent(evtObj);
        }
        else if (doc.createEventObject)
        {
            evtObj = doc.createEventObject();
            evtObj.keyCode = keyCode;
            el.fireEvent('on' + evtType, evtObj);
        }
    }


};

Tools.drawLine = Tools.drawCellBorderLine; //取一个别名


export default Tools;
