/**
 * Created by 三宝爹 on 2017/5/4.
 * 对象池
 * 参考 https://github.com/nodejs/node-v0.x-archive/blob/master/lib/freelist.js
 *
 function Foo(a,b )
 {
       }
 Foo.prototype.init=function(a,b)
 {
     this.a=a;
     this.b=b;

 }
 Foo.prototype.add=function ()
 {
     return this.a+this.b;
 }

 var pool= new ObjectPool( Foo, 3);//构建一个Foo对象池，最多缓存3个对象
 var foo= pool.getInstance();//得到一个 Foo实例
 foo.init(3,4);//设置一些数据
 alert( foo.add());  // 7
 pool.recycle(foo); //release();//回归到池中
 foo=pool.getInstance();
 alert( foo.add()); //  7
 foo.init(5,6);
 alert( foo.add());  //11
 pool.recycle(foo);


 */


import Class from '../base/Class.js';

var ObjectPool = Class.extend({

        constructor: function (klass, maxCount) {

            this.CLASS = klass;
            this.maxCount = maxCount || 10;
            this.list = [];

            // var pool=this;

            // klass.prototype.release=function()  //为类增加一个release函数，用于释放自已到对象池中
            //{
            //  var freeObj=this;//这里的this与外面的this ,不是同一个东西，外面 this是ObjectPool实例， 这里的this 是klass类的实例
            // pool.recycle(freeObj);
            // }

        },

        getInstance: function () {
            //debug("alloc " + this.name + " " + this.list.length);
            var ret;
            if (this.list.length > 0)
            {
                //  console.log('return header object in pool ');
                ret = this.list.shift()
            } else
            {
                //  console.log(" create new one");
                ret = new this.CLASS();
            }


            return ret;
        },
        recycle: function (obj) {
            //debug("free " + this.name + " " + this.list.length);
            if (this.list.length < this.maxCount)
            {
                this.list.push(obj);
                return true;
            }
            return false;
        }

    }
);

export default ObjectPool;

