import Util from "../../util/Util.js";
import Color from "../../gdi/Color.js";
import MouseAdapter from './MouseAdapter.js';

var YAxis_mmHg = MouseAdapter.extend(
    {

        constructor: function () {

        },
        //在指定单元格中画出时间轴
        draw: function (cell, /*int*/dbrow, /*Graphics2D*/g, /*Rectangle*/rc, data, /*String*/  s, /*int*/bkMode,
                        /*Color*/bkcolor, /*Color*/textcolor, /*String*/   FontName, /* int*/FontSize,
                        /*boolean*/FontBold, /*boolean*/FontItalic, /*boolean*/FontUnderline,
                        /*int*/hAlign, /*int*/vAlign, /*boolean*/MultiLine, /*boolean*/ noES) {

            var physiology = cell.Book.property.get(data.physiologyName);
            var view = cell.Sheet.View;
            var lineColor = cell.getSplitLineColor();

            var textRect = rc.clone();
            textRect.width -= 2;


            //看看能画多少个小格
            var h = Math.floor(rc.height / (31)); //分成31份,每份的高度


            //从上往下画
            //先画文字  mmHg
            textRect.y = rc.y + h - 0.5 * h;
            textRect.height = h;

            g.drawStringSingleRow(textRect, 'mmHg', bkMode, bkcolor, textcolor, FontName, FontSize - 3, FontBold, FontItalic, FontUnderline, hAlign, vAlign);

            //再画数字轴
            for (var i = 14; i >= 0; i--)
            {
                textRect.y = rc.y + h + (14 - i) * 2 * h + 0.5 * h;
                textRect.h = 2 * h;
                g.drawStringSingleRow(textRect, '' + i * 20, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);

            }


        }
    });

export default YAxis_mmHg;
