import Util from "../../util/Util.js";
import Color from "../../gdi/Color.js";
import Tools from '../../util/Tools.js';

import MouseAdapter from './MouseAdapter.js';

/**
 * 注射信息的展示
 * @type {{draw: draw}}
 */
var DataLine = MouseAdapter.extend(
    {

        constructor: function () {

        },

        //在指定单元格中画出时间轴
        draw: function (cell, /*int*/dbrow, /*Graphics2D*/g, /*Rectangle*/rc, data, /*String*/  s, /*int*/bkMode,
                        /*Color*/bkcolor, /*Color*/textcolor, /*String*/   FontName, /* int*/FontSize,
                        /*boolean*/FontBold, /*boolean*/FontItalic, /*boolean*/FontUnderline,
                        /*int*/hAlign, /*int*/vAlign, /*boolean*/MultiLine, /*boolean*/ noES) {

            var physiology = cell.Book.property.get(data.physiologyName);

            if (physiology == null) return; //当单元格用公式定义时，源可能还没有初始化好，这是允许的

            if (cell.getMouseAdapter('physiology') == undefined)
            {
                cell.addMouseAdapter('physiology', this);
            }

            var view = cell.Sheet.View;
            var lineColor = cell.getSplitLineColor();

            var textRect = rc.clone();


            //垂直线
            //看看能画多少个小格
            var n = Math.floor(rc.width / physiology.dateAxisCellWidth);
            var tn = Math.floor(n / 3); //每3格画一个时间刻度
            for (let i = 0; i <= n; i++)
            {
                let x = (physiology.offset + i) * physiology.dateAxisCellWidth;
                let y = rc.y;

                let lineStyle = 3;
                if (i % 3 == 0) lineStyle = 1;

                Tools.drawLine(g, lineStyle, 1, lineColor,
                    rc.x + x, y,
                    rc.x + x, y + rc.height);


            }

            var injectionData = data.param; //注射济的信息
            if (Util.isString(injectionData))
            {
                injectionData = window[injectionData](cell, dbrow);

            }


            /*
            data.push({
                    type: 1,//微泵注射
                    start:
                        '2018.07.01 09:40:00',
                    end:
                        '2018.07.01 10:25:00',

                    speed:
                        50
                }
            );
            data.push({
                type: 0, //立即注射
                start: '2018.07.01 08:40:00',
                amount: 35
            });

            */

            var data = injectionData.data;
            textcolor = injectionData.color ? injectionData.color : textcolor;
            for (var i = 0; i < data.length; i++)
            {
                var one = data[i];
                if (one.type == 0) //立即注射,只显示剂量在时刻点
                {
                    var m = Tools.minutesBetween(one.start, physiology.startTime);
                    var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                    textRect.x = rc.x + x;
                    g.drawStringSingleRow(textRect, one.amount, bkMode, bkcolor, textcolor,
                        FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);

                }

                if (one.type == 1)
                {
                    var m1 = Tools.minutesBetween(one.start, physiology.startTime);
                    var x1 = m1 * physiology.pixelPerSeconds - physiology.offset;//起始x坐标

                    var m2 = Tools.minutesBetween(one.end || new Date(), physiology.startTime);
                    var x2 = m2 * physiology.pixelPerSeconds - physiology.offset;//起始x坐标

                    if (!one.end) x2 = x1 + 200; //测试，

                    var delta = rc.height / 5;
                    //画起始线
                    Tools.drawLine(g, 1, 1, textcolor, rc.x + x1, rc.y + delta, rc.x + x1, rc.y + rc.height - delta);


                    //画中间线
                    Tools.drawLine(g, 1, 1, textcolor, rc.x + x1, rc.y + rc.height / 2, rc.x + x2, rc.y + rc.height / 2);

                    //画终止线
                    if (one.end)
                    {
                        Tools.drawLine(g, 1, 1, textcolor, rc.x + x2, rc.y + delta, rc.x + x2, rc.y + rc.height - delta);

                    } else
                    {

                        Tools.drawLine(g, 1, 1, textcolor, rc.x + x2 - ( rc.height - 2 * delta) / 2, rc.y + delta,
                            rc.x + x2, rc.y + rc.height / 2);
                        Tools.drawLine(g, 1, 1, textcolor, rc.x + x2 - ( rc.height - 2 * delta) / 2, rc.y + rc.height - delta,
                            rc.x + x2, rc.y + rc.height / 2);

                    }

                    //画文字
                    //文字的尺寸通常就是字号*文字的长度

                    textRect.width = ('' + one.speed).length * FontSize;
                    textRect.x = rc.x + x1 + (x2 - x1) / 2 - textRect.width / 2;
                    textRect.y = rc.y + (rc.height - FontSize) / 2 - 1;
                    textRect.height = FontSize + 2;
                    //居中，以白色背景显示文字
                    g.drawStringSingleRow(textRect, one.speed, 1, Color.white, textcolor,
                        FontName, FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);


                }

                if (one.type == 2) //立即值
                {
                    var m = Tools.minutesBetween(one.when, physiology.startTime);
                    var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                    textRect.x = rc.x + x;
                    g.drawStringSingleRow(textRect, one.value, bkMode, bkcolor, textcolor,
                        FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);

                }


            }


        }
    });

export default DataLine;