// 本文件用于webpack打包入口
// webpack的自动分析信赖没能全部
//
// 说明： 如果仅仅是打包，只需要  import WorkBook from '../spreadsheet/core/WorkBook.js' 一行就可以了
//  webpack会递归分析出所有依赖的类，但是为了次本包与应用独立出来，并且暴露出可能需要用到的类供应用使用
//  所以整理出了可能会在外部需要用到的类并暴露成一个全局多层的变量 window.spreadsheet
//
// History :  2020.03.25 初稿
//
//

//base
import Class from '../spreadsheet/base/Class.js';
import Esprima from '../spreadsheet/base/esprima.js';

//brick
import EChartBrick from '../spreadsheet/brick/EChartBrick.js';
import CKEditorBrick from '../spreadsheet/brick/CKEditorBrick.js';
import TabBrick from '../spreadsheet/brick/TabBrick.js';
import HTMLBrick from '../spreadsheet/brick/HTMLBrick.js';
import DBPageBrick from '../spreadsheet/brick/DBPageBrick.js';
import TreeBrick from '../spreadsheet/brick/TreeBrick.js';
import SheetContainer from '../spreadsheet/brick/SheetContainer.js';
import BasicBrick from '../spreadsheet/brick/BasicBrick.js';
import Button from '../spreadsheet/brick/Button.js';
import TabContentBrick from '../spreadsheet/brick/TabContentBrick.js';
import PopupSheetContainer from '../spreadsheet/brick/PopupSheetContainer.js';
import UploadBrick from '../spreadsheet/brick/UploadBrick.js';

//core

import Cell from '../spreadsheet/core/Cell.js';
import DataSourceConfig from '../spreadsheet/core/DataSourceConfig.js';
import DBBindConfig from '../spreadsheet/core/DBBindConfig.js';
import EditStyle from '../spreadsheet/core/EditStyle.js';
import Property from '../spreadsheet/core/Property.js';
import Range from '../spreadsheet/core/Range.js';
import Row from '../spreadsheet/core/Row.js';
import RowProperty from '../spreadsheet/core/RowProperty.js';
import UniformDataType from '../spreadsheet/core/UniformDataType.js';
import WorkBook from '../spreadsheet/core/WorkBook.js';
import WorkBookView from '../spreadsheet/core/WorkBookView.js';
import WorkSheet from '../spreadsheet/core/WorkSheet.js';
import WorkSheetView from '../spreadsheet/core/WorkSheetView.js';


//db
import ColumnProperty from '../spreadsheet/db/ColumnProperty.js';
import DataBuffer from '../spreadsheet/db/DataBuffer.js';
import DataStore from '../spreadsheet/db/DataStore.js';
import DsItem from '../spreadsheet/db/DsItem.js';
import DsRow from '../spreadsheet/db/DsRow.js';
import ItemStatus from '../spreadsheet/db/ItemStatus.js';
import ObjectTool from '../spreadsheet/db/ObjectTool.js';
import ObjectType from '../spreadsheet/db/ObjectType.js';
import SqlParse from '../spreadsheet/db/SqlParse.js';
import Types from '../spreadsheet/db/Types.js';


//util

import ajax from '../spreadsheet/util/ajax.js';
import Map from '../spreadsheet/util/Map.js';
import ObjectPool from '../spreadsheet/util/ObjectPool.js';
import Tools from '../spreadsheet/util/Tools.js';
import UnitConv from '../spreadsheet/util/UnitConv.js';
import Util from '../spreadsheet/util/Util.js';

//gdi
import Color from '../spreadsheet/gdi/Color.js';
import Graphics2D from '../spreadsheet/gdi/Graphics2D.js';
import Point from '../spreadsheet/gdi/Point.js';
import Rectangle from '../spreadsheet/gdi/Rectangle.js';
import Text from '../spreadsheet/gdi/text.js';

//将常用的类放到全局变量中，方便应用级的脚本中使用它们，而不是必须与spreadsheet的源码一并做打包
// 打包后，可以全局访问的类。如果有需要访问的类，请在下面暴露
window.spreadsheet = {
    base:
        {
            Class: Class,
            Esprima: Esprima
        },
    brick:
        {
            EChartBrick: EChartBrick,
            CKEditorBrick: CKEditorBrick,
            TabBrick: TabBrick,
            HTMLBrick: HTMLBrick,
            DBPageBrick: DBPageBrick,
            TreeBrick: TreeBrick,
            SheetContainer: SheetContainer,
            BasicBrick: BasicBrick,
            Button: Button,
            TabContentBrick: TabContentBrick,
            PopupSheetContainer: PopupSheetContainer,
            UploadBrick:UploadBrick
        },
    core:
        {
            Cell: Cell,
            DataSourceConfig: DataSourceConfig,
            DBBindConfig: DBBindConfig,
            EditStyle: EditStyle,
            Property: Property,
            Range: Range,
            Row: Row,
            RowProperty: RowProperty,
            UniformDataType: UniformDataType,
            WorkBook: WorkBook,
            WorkBookView: WorkBookView,
            WorkSheet: WorkSheet,
            WorkSheetView: WorkSheetView,
            Property:Property
        },
    db:
        {
            ColumnProperty: ColumnProperty,
            DataBuffer: DataBuffer,
            DataStore: DataStore,
            DsItem: DsItem,
            DsRow: DsRow,
            ItemStatus: ItemStatus,
            ObjectTool: ObjectTool,
            ObjectType: ObjectType,
            SqlParse: SqlParse,
            Types: Types

        },
    gdi:
        {
            Color:Color,
            Graphics2D:Graphics2D,
            Point:Point,
            Text:Text
        },
    util:
        {
            ajax: ajax,
            Map: Map,
            ObjectPool: ObjectPool,
            Tools: Tools,
            UnitConv: UnitConv,
            Util: Util


        }

};

