/**
 * HiDPI Canvas Polyfill (1.0.10)
 *
 * Author: Jonathan D. Johnson (http://jondavidjohn.com)
 * Homepage: https://github.com/jondavidjohn/hidpi-canvas-polyfill
 * Issue Tracker: https://github.com/jondavidjohn/hidpi-canvas-polyfill/issues
 * License: Apache-2.0
 *
 * 直接修改prototype来自适应高清屏，但是echart自已也做了相关的处理，所以二者有冲突
 * 因此，仅当canvas是用于workbook时，才做自适应的处理，
 *
 */
(function (prototype) {

    var pixelRatio = (function () {
            var canvas = document.createElement('canvas'),
                context = canvas.getContext('2d'),
                backingStore = context.backingStorePixelRatio ||
                    context.webkitBackingStorePixelRatio ||
                    context.mozBackingStorePixelRatio ||
                    context.msBackingStorePixelRatio ||
                    context.oBackingStorePixelRatio ||
                    context.backingStorePixelRatio || 1;

            var ratio= (window.devicePixelRatio || 1) / backingStore;

            return ratio;
        })(),

        forEach = function (obj, func) {
            for (var p in obj)
            {
                if (obj.hasOwnProperty(p))
                {
                    func(obj[p], p);
                }
            }
        },

        //对函数的参数进行放大处理， all表示所有参数都需要放大，否则只对指定序号的参数进行放大
        ratioArgs = {
            'fillRect': 'all',
            'clearRect': 'all',
            'strokeRect': 'all',
            'moveTo': 'all',
            'lineTo': 'all',
            'arc': [0, 1, 2],
            'arcTo': 'all',
            'bezierCurveTo': 'all',
            'isPointinPath': 'all',
            'isPointinStroke': 'all',
            'quadraticCurveTo': 'all',
            'rect': 'all',
            'translate': 'all',
            'createRadialGradient': 'all',
            'createLinearGradient': 'all',
            'getImageData': 'all',//2020.06.04 增加
            'putImageData': [1,2],//2020.06.04 增加

            'drawImage':[1,2,3,4,5,6,7,8]
        };


    if (pixelRatio === 1) return;

    forEach(ratioArgs, function (value, key) {
        prototype[key] = (function (_super) {
            return function () {
                var i, len,
                    args = Array.prototype.slice.call(arguments);

                var ratio= pixelRatio;
                if( this.ratio) ratio= this.ratio;

                if (value === 'all')
                {
                    args = args.map(function (a) {
                        return a * ratio;
                    });
                }
                else if (Array.isArray(value))
                {
                    for (i = 0, len = value.length; i < len; i++)
                    {
                        args[value[i]] *= ratio;
                    }
                }

                return _super.apply(this, args);
            };
        })(prototype[key]);
    });

    // Stroke lineWidth adjustment
    prototype.stroke = (function (_super) {
        var ratio= pixelRatio;
        if( this.ratio) ratio= this.ratio;

        return function () {
            this.lineWidth *= ratio;
            _super.apply(this, arguments);
            this.lineWidth /= ratio;
        };
    })(prototype.stroke);

    // Text
    //
    prototype.fillText = (function (_super) {
        return function () {
            var args = Array.prototype.slice.call(arguments);
            var ratio= pixelRatio;
            if( this.ratio)
            {
                ratio= this.ratio;
            }


            args[1] *= ratio; // x
            args[2] *= ratio; // y

            this.font = this.font.replace(
                /(\d+)(px|em|rem|pt)/g,
                function (w, m, u) {
                    return (m * ratio) + u;
                }
            );

            _super.apply(this, args);

            this.font = this.font.replace(
                /(\d+)(px|em|rem|pt)/g,
                function (w, m, u) {
                    return (m / ratio) + u;
                }
            );
        };
    })(prototype.fillText);

    prototype.strokeText = (function (_super) {
        return function () {
            var args = Array.prototype.slice.call(arguments);
            var ratio= pixelRatio;
            if( this.ratio) ratio= this.ratio;

            args[1] *= ratio; // x
            args[2] *= ratio; // y

            this.font = this.font.replace(
                /(\d+)(px|em|rem|pt)/g,
                function (w, m, u) {
                    return (m * ratio) + u;
                }
            );

            _super.apply(this, args);

            this.font = this.font.replace(
                /(\d+)(px|em|rem|pt)/g,
                function (w, m, u) {
                    return (m / ratio) + u;
                }
            );
        };
    })(prototype.strokeText);
})(CanvasRenderingContext2D.prototype);
;

(function (prototype) {
    prototype.getContext = (function (_super) {
        return function (type) {
            var backingStore, ratio,
                context = _super.call(this, type);



            if (type === '2d')
            {

                backingStore = context.backingStorePixelRatio ||
                    context.webkitBackingStorePixelRatio ||
                    context.mozBackingStorePixelRatio ||
                    context.msBackingStorePixelRatio ||
                    context.oBackingStorePixelRatio ||
                    context.backingStorePixelRatio || 1;

                ratio = (window.devicePixelRatio || 1) / backingStore;



                    //下面很重要，可能canvas的size发生了变化，那么重新设置一下画布的size

                context.ratio = ratio; //增加一个属性，可供外面使用

                if( !$(this).attr('workbook'))  context.ratio=1;
                // ratio 影响下面的画布缩放，而 context.ratio 则影响各个绘图函数
                // 2017.12 增加了强制非 workbook的画布，强制context.ratio=1;即还原成1 ，这是为了兼容echart ,因为 echart 自已做了高清屏的适应
                //  这样处理后， 基本能让workbook与echart共存于一个页面。稍有一点不完美的是这样处理后的echart 中的一些线条，都加粗了，不够细腻


                //下面的操作，会清空画布
                // 实践证明，整个canvas清空了重绘比局部重绘，效率更高
                //这个结果与windows中的绘图机制不符。 能想到的解释是，
                // canvas 与常规桌面程序的UI是不一样的。 常规控件的UI绘制是交给程序来重绘的
                // 当控件被遮挡后再显示时，它不会自动重绘，而是需要程序来重新绘制它。即控件并不记住自已的样子，
                // 当需要重绘时，由程序来完成重绘
                // 但是，canvas更象是记住了绘画命令，程序做绘制操作后， canvas记住了这些绘制命令，当它被遮盖或其它原因需要重绘时
                // canvas自动按记住的命令进制重绘。所以当不做清除，程序不断局部重绘时，实际上是在不断地增加绘画动作，导致绘画操作越来越多
                // 当canvas需要重绘自已时，它就要重做很多命令
                // 所以说 canvas它是基于绘图指令的， 它不存在重绘事件，你如果反复绘制同一个东西，那么它就记住了这些反复的命令，就可能出现
                // 一条线画无数遍。
                // 解决办法就是每次需要更新时，就全部清除，整个重新画
                // 事实证明，清空重绘更快。因为它清除了历史绘图命令

                //下面的设置尺寸的操作，会将canvas清空

                this.ratioInited = true;
                var w = $(this).width();
                var h = $(this).height();
                this.style.height = h + 'px';
                this.style.width = w + 'px';
                this.width = w * ratio;
                this.height = h * ratio;

            }

            return context;
        };
    })(prototype.getContext);
})(HTMLCanvasElement.prototype);
