/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';
import Util from '../util/Util.js';


var Rectangle = Class.extend({

    constructor: function () {
        if (arguments.length == 4)
        {
            var x = arguments[0];
            var y = arguments[1];
            var width = arguments[2];
            var height = arguments[3];
            this.setBounds(x, y, width, height);
            return;
        }
        if (arguments.length == 1)
        {
            var p1 = arguments[0];
            if (Util.isClas$(p1))
            {
                if (p1.instanceOf(Rectangle))
                {
                    this.x = p1.x;
                    this.y = p1.y;
                    this.width = p1.width;
                    this.height = p1.height;
                }
            }
            return;
        }

        this.setBounds(0,0,0,0);


    },

    setBounds: function (x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    },

    clone: function () {
        var ret = new Rectangle(this.x, this.y, this.width, this.height);
        return ret;
    },

    contains: function (p) {
        if (this.x <= p.x && this.x + this.width >= p.x && this.y <= p.y && this.y + this.height >= p.y) return true;
        return false;
    }
    ,
    /**
     * 求两个Rectangle的并集， 代码改编自 java.awt.Rectangle;
     * @param r
     */
    union: function (r) {
        var tx2 = this.width;
        var ty2 = this.height;
        if ((tx2 | ty2) < 0)
        {
            // This rectangle has negative dimensions...
            // If r has non-negative dimensions then it is the answer.
            // If r is non-existant (has a negative dimension), then both
            // are non-existant and we can return any non-existant rectangle
            // as an answer.  Thus, returning r meets that criterion.
            // Either way, r is our answer.
            return new Rectangle(r);
        }
        var rx2 = r.width;
        var ry2 = r.height;
        if ((rx2 | ry2) < 0)
        {
            return new Rectangle(this);
        }
        var tx1 = this.x;
        var ty1 = this.y;
        tx2 += tx1;
        ty2 += ty1;
        var rx1 = r.x;
        var ry1 = r.y;
        rx2 += rx1;
        ry2 += ry1;
        if (tx1 > rx1) tx1 = rx1;
        if (ty1 > ry1) ty1 = ry1;
        if (tx2 < rx2) tx2 = rx2;
        if (ty2 < ry2) ty2 = ry2;
        tx2 -= tx1;
        ty2 -= ty1;
        // tx2,ty2 will never underflow since both original rectangles
        // were already proven to be non-empty
        // they might overflow, though...

        return new Rectangle(tx1, ty1, tx2, ty2);
    },

    /**
     * 交集
     * @param rect
     */
    intersection: function (r) {
        var tx1 = this.x;
        var ty1 = this.y;
        var rx1 = r.x;
        var ry1 = r.y;
        var tx2 = tx1;
        tx2 += this.width;
        var ty2 = ty1;
        ty2 += this.height;
        var rx2 = rx1;
        rx2 += r.width;
        var ry2 = ry1;
        ry2 += r.height;
        if (tx1 < rx1) tx1 = rx1;
        if (ty1 < ry1) ty1 = ry1;
        if (tx2 > rx2) tx2 = rx2;
        if (ty2 > ry2) ty2 = ry2;
        tx2 -= tx1;
        ty2 -= ty1;

        return new Rectangle(tx1, ty1, tx2, ty2);
    },

    /**
     * 判断是否相交
     * @param r
     * @returns {boolean}
     */
    intersects: function (r) {
        var tw = this.width;
        var th = this.height;
        var rw = r.width;
        var rh = r.height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0)
        {
            return false;
        }
        var tx = this.x;
        var ty = this.y;
        var rx = r.x;
        var ry = r.y;
        rw += rx;
        rh += ry;
        tw += tx;
        th += ty;
        //      overflow || intersect
        return ((rw < rx || rw > tx) &&
            (rh < ry || rh > ty) &&
            (tw < tx || tw > rx) &&
            (th < ty || th > ry));
    },

    /**
     * 把自已撑大
     * @param left
     * @param top
     * @param right
     * @param bottom
     */
    append: function (left, top, right, bottom) {
        this.x -= left;
        this.y -= top;
        this.width += left + right;
        this.height += top + bottom;
    },

    toString: function () {
        return `x:${this.x};y:${this.y};width:${this.width};height:${this.height};`;
    },

    equals: function (rc) {
        return this.x == rc.x && this.y == rc.y && this.width == rc.width && this.height == rc.height;
    }

});

export default Rectangle;
