/**
 * Created by 三宝爹
 *
 *  四则运算函数
 *
 */


import FU from './FuncUtil.js';
import Util from '../../util/Util.js';
import AJAX from '../../util/ajax.js';

var $rpc = AJAX.rpc;

function round(num, n)
{


    if (num == null) return 0;
    if (n == null) return 0;
    if (n < 0) return num;
    try
    {
        if (isNaN(num)) num = parseFloat(num);
        return new Number(num.toFixed(n));

    } catch (err)
    {
        return null;
    }

    /*
    return $div(Math.round($mul(num, Math.pow(10, n))), Math.pow(10, n));
     //2019.08.24 上面这个搞法也仍然不对
     */


}

//     + 不一定是数字相加，所以允许直接+，但是-*/不可能对非数字型进行运算
function $add(a, b)
{
    if (a == null && b == null) return null;
    if (b == null && a != null) return a;
    if (a == null && b != null) return b;


    if (typeof (a) != 'number' || typeof (b) != 'number') return a + b;

    var c, d, e;
    try
    {
        c = a.toString().split(".")[1].length;
    } catch (f)
    {
        c = 0;
    }
    try
    {
        d = b.toString().split(".")[1].length;
    } catch (f)
    {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), ($mul(a, e) + $mul(b, e)) / e;
}

function $sub(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;

    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);

    var c, d, e;
    try
    {
        c = a.toString().split(".")[1].length;
    } catch (f)
    {
        c = 0;
    }
    try
    {
        d = b.toString().split(".")[1].length;
    } catch (f)
    {
        d = 0;
    }
    return e = Math.pow(10, Math.max(c, d)), ($mul(a, e) - $mul(b, e)) / e;
}

function $mul(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;


    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);


    var c = 0,
        d = a.toString(),
        e = b.toString();
    try
    {
        c += d.split(".")[1].length;
    } catch (f)
    {}
    try
    {
        c += e.split(".")[1].length;
    } catch (f)
    {}
    return Number(d.replace(".", "")) * Number(e.replace(".", "")) / Math.pow(10, c);
}

function $div(a, b)
{
    if (a == null) a = 0;
    if (b == null) b = 0;

    if (b == 0) return null;

    if (typeof (a) != 'number') a = new Number('' + a);
    if (typeof (b) != 'number') b = new Number('' + b);

    var c, d, e = 0,
        f = 0;
    try
    {
        e = a.toString().split(".")[1].length;
    } catch (g)
    {}
    try
    {
        f = b.toString().split(".")[1].length;
    } catch (g)
    {}
    return c = Number(a.toString().replace(".", "")), d = Number(b.toString().replace(".", "")), $mul(c / d, Math.pow(10, f - e));
}


function random(n)
{

    var ret = $rpc("script", "debug.ScriptAgent", "mathFunction",
        {
            method: 'random',
            n: n
        }
    );
    return ret.value;
}


function abs(n)
{
    if (isNaN(n)) return 0;
    if (n > 0) return n;
    return -n;
}

function mod(a, b)
{
    if (b == 0) return null;
    return a % b;
}


var MathFunc= {

    round: round,
    add: $add,
    sub: $sub,
    div: $div,
    mul: $mul,
    random: random,
    abs: abs,
    mod: mod


};

export default  MathFunc;

