/**
 * Created by 三宝爹 on 2017/7/22.
 *
 * 聚合函数，通常参数是多个，或参数可能是数组， 函数的返回值是一个单值，比如 sum 无论有多少个参数，最后都是全部加起来，返回一个值
 *
 */


import FU from './FuncUtil.js';
import Util from '../../util/Util.js';

/**
 * 求和
 *
 * 示例：
 *  sum( 1,2,3,4)  =1+2+3+4
 *  sum( [1,2,3] , 4 , [5,6])  = 1+2+3+4+5+6
 * @returns {*}
 */
function sum()
{
    //a,b都是简单数据时，相加
    var add = function (a, b) {
        if (a == null) return b;
        if (!b) return a;
        return a + b;
    };
    //p 是数组时相加
    var addArray = function (p) {
        var ret = null;
        for (var i = 0; i < p.length; i++)
        {
            ret = add(ret, p[i]);
        }
        return ret;
    };

    var ret = null;
    for (var i = 0; i < arguments.length; i++)
    {
        var p = arguments[i];
        if (FU.theOneIsArray([p]))
        {
            var v2 = addArray(p);
            ret = add(ret, v2);
        } else
        {
            ret = add(ret, p);
        }

    }
    return ret;

}

function join()
{

    var ret=[];

    for (var i = 0; i < arguments.length; i++)
    {
        var p = arguments[i];
        if (FU.theOneIsArray([p]))
        {
           ret=ret.concat(p);
        } else
        {
            ret.push(p);
        }

    }

    //去掉null或''
    ret=ret.filter(function (s) {
        if(s==null) return false;
        if( s=='') return false;
        return true;
    });

    return ret.join(',');

}

function joinBy()
{

    var ret=[];

    for (var i = 0; i < arguments.length-1; i++)
    {
        var p = arguments[i];
        if (FU.theOneIsArray([p]))
        {
            ret=ret.concat(p);
        } else
        {
            ret.push(p);
        }

    }

    //去掉null或''
    ret=ret.filter(function (s) {
        if(s==null) return false;
        if( s=='') return false;
        if( s=='null') return false;

        return true;
    });

    return ret.join(arguments[arguments.length-1]);

}

function count(p)
{
    if (Util.isArray(p)) return p.length;
    return 1;
}

function max()
{

    //a,b都是简单数据时，相加
    var max_simple = function (a, b) {
        if (a == null) return b;
        if (!b) return a;
        return Math.max(a, b);
    };
    //p 是数组时
    var max_array = function (p) {
        var ret = null;
        for (var i = 0; i < p.length; i++)
        {
            ret = max_simple(ret, p[i]);
        }
        return ret;
    };

    var ret = null;
    for (var i = 0; i < arguments.length; i++)
    {
        var p = arguments[i];
        if (Util.isArray(p))
        {
            var v2 = max_array(p);
            ret = max_simple(ret, v2);
        } else
        {
            ret = max_simple(ret, p);
        }

    }
    return ret;

}

function min()
{

    //a,b都是简单数据时，相加
    var min_simple = function (a, b) {
        if (a == null) return b;
        if (!b) return a;
        return Math.min(a, b);
    };
    //p 是数组时
    var min_array = function (p) {
        var ret = null;
        for (var i = 0; i < p.length; i++)
        {
            ret = min_simple(ret, p[i]);
        }
        return ret;
    };

    var ret = null;
    for (var i = 0; i < arguments.length; i++)
    {
        var p = arguments[i];
        if (Util.isArray(p))
        {
            var v2 = min_array(p);
            ret = min_simple(ret, v2);
        } else
        {
            ret = min_simple(ret, p);
        }

    }



    return ret;

}


var AggregateFunc= {
    sum: sum,
    max: max,
    min: min,
    count: count,
    join:join,
    joinBy:joinBy

};

export default AggregateFunc;

