/**
 * Created by 三宝爹 on 2017/10
 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';
import Point from '../gdi/Point.js';
import Property from '../core/Property.js';
import Graphics2D from '../gdi/Graphics2D.js';
import Color from '../gdi/Color.js';
import Rectangle from '../gdi/Rectangle.js';
import ALIGNMENT from '../core/ALIGNMENT.js';
import Edit from './Edit.js';


var RadioAndMultiCheckEdit = BasicEdit.extend({


    constructor: function (domObj, editStyle) {
        this.$uper.constructor(domObj);
        this.ES = editStyle;
        this.checked = [];

        this.lastFocusItemIndex = -1; //鼠标所在的项目的索引号
        this.lastFocusRect = null;
    },


    // 构造编辑框显示的内容
    buildEditText: function (value) {
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }
        this.setValue(s);

        //选中复位
        this.checked.clear();

        var cell = this.Sheet.cells(this.Row, this.Col);
        //根据数据 值构建选中列表
        var vs = (s == null ? '' : ('' + s)).split(',');
        for (var i = 0; i < vs.length; i++)
        {
            var v = vs[i];
            var index = this.ES.dropDownData.dataValue.indexOf(v);
            if (index >= 0) this.checked.push(index);
        }


        this.paint();


    },

    // 回填的值
    getWriteBackValue: function () {

        var v = [];
        for (var i = 0; i < this.checked.length; i++)
        {
            v.push(this.ES.dropDownData.dataValue[this.checked[i]]);
        }

        if (v.length == 1)
        {
            v = v[0];
        } else
        {
            v = v.join(',');
        }


        var ev = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), v, this.currentDBRow]);

        if (ev == null) return v;
        if (ev == undefined) return v;
        return ev;
    },

    //本编辑格式使用的DOM对象是canvas,不是input ,所以要覆盖此方法，返回当前编辑的视觉数据
    //override
    getText: function () {
        return '';
    },


    paint: function () {

        var cell = this.Sheet.cells(this.Row, this.Col);

        var rc = this.getBounds();

        rc.x = 0;
        rc.y = 0;

        var w = rc.width;
        var h = rc.height;


        var /*Property*/ prop = cell.getPropertyObject();// 不要直接用成员变量this.property,因为它可能为空
        var /*Color*/ font_color_default = prop.get(Property.color, Color.BLACK);
        var /*String*/ font_color_expression = prop.get(Property.font_color_expression, "");
        var /*String*/ background_color_expression = prop.get(Property.background_color_expression, "");


        var /*Color*/ groupRowBackground = new Color(0x0000ff);
        var /*String*/ font_family = "FontAwesome";

        var /*int*/ font_size = prop.get(Property.font_size, 12);
        var /*boolean*/ font_bold = prop.get(Property.font_bold, false);
        var /*boolean*/ font_italic = prop.get(Property.font_italic, false);
        var /*boolean*/ font_underline = prop.get(Property.font_underline, false);
        var /*int*/ align_h = prop.get(Property.text_align, ALIGNMENT.Left);
        var /*int*/ align_v = prop.get(Property.vertical_align, ALIGNMENT.Center);


        var /*boolean*/ word_wrap = prop.get(Property.word_wrap, false);


        var graphics = new Graphics2D(this.domObj);


        var background_color = prop.get(Property.background_color, '');
        if (background_color != '' && background_color != 'transparent')
        {
            graphics.setColor(background_color);
            graphics.fillRect(0, 0, w, h);
        }
        //如果是在一个多行绑定行中，那么正在编辑的行肯定说法是当前亮显行
        var mrdsn = this.Sheet.RPM.getMultiRowDataSourceName(this.Row);
        if (mrdsn != '')
        {
            graphics.setColor(this.Sheet.Book.options.gridFocusRowBackgroundColor );
            graphics.fillRect(0, 0, w, h);

        }


        var innerRow = this.currentDBRow;

        var dropDownData = this.ES.getDropDownDataForEdit(cell, innerRow);

        var colCount = dropDownData.dataValue.length;

        var listCount = dropDownData.dataValue.length;
        //需要显示几行
        //当实际的数据不足列数时，原先是以实际为准，现在改在以设置为准，这样方便对齐
        var colCount = Math.max(1, this.ES.columnCount);
        var rowCount = Math.max(1, Math.floor((listCount - 1) / colCount) + 1); //肯定不为0

        var itemRC = new Rectangle();
        itemRC.width = Math.floor(rc.width / colCount);
        itemRC.height = Math.floor(rc.height / rowCount);

        for (var ri = 0; ri < rowCount; ri++)
        {
            itemRC.y = rc.y + ri * itemRC.height;
            for (var ci = 0; ci < colCount; ci++)
            {
                itemRC.x = rc.x + ci * itemRC.width;
                var index = ri * colCount + ci;
                if (index > listCount - 1) break;
                var str = this.checked.contains(index) ?
                    ( this.ES.ET == EditStyle.$RadioButton ? this.ES.radioCheckOnChar : this.ES.multiCheckOnChar) :
                    ( this.ES.ET == EditStyle.$RadioButton ? this.ES.radioCheckOffChar : this.ES.multiCheckOffChar);
                str = ' ' + str + ' ' + dropDownData.showText[index];

                graphics.drawStringWordwrap(itemRC, str, 0, background_color, font_color_default,
                    font_family, font_size, font_bold, font_italic, font_underline,
                    cell.$AutoHalign(align_h), align_v, word_wrap);
            }
        }

        if (this.lastFocusRect != null)
        {
            graphics.setColor(new Color(140, 140, 140, 0.1));
            graphics.fillRect(this.lastFocusRect);
        }
    },

    loopInItems: function (e, callback) {
        //点击后，数据立即入
        var rc = this.getBounds();


        var point = new Point(e.offsetX, e.offsetY);
        if (e.currentTarget != this.domObj[0])
        {
            //如果是在sheetView上点击，在beginEdit中调用mouoseClicked,那么鼠标点是相对 sheetView的
            //如果是在本 this.domObj上点击，那么坐标是相对本domObj的，坐标不一样
            point = new Point(e.offsetX - rc.x, e.offsetY - rc.y);
        }

        rc.x = 0;
        rc.y = 0;
        //手工调整一下， 上面的rc 与 单元格绘制时的，rc 是有偏差的，象下面这样调整一下，就一样了
        rc.width -= 1;
        rc.height -= 2;


        var innerRow = this.currentDBRow;
        var cell = this.Sheet.cells(this.Row, this.Col);
        var dropDownData = this.ES.getDropDownDataForEdit(cell, innerRow);

        var colCount = dropDownData.dataValue.length;

        var listCount = dropDownData.dataValue.length;
        //需要显示几行
        //当实际的数据不足列数时，原先是以实际为准，现在改在以设置为准，这样方便对齐
        var colCount = Math.max(1, this.ES.columnCount);
        var rowCount = Math.max(1, Math.floor((listCount - 1) / colCount) + 1); //肯定不为0

        var itemRC = new Rectangle();
        itemRC.width = Math.floor(rc.width / colCount); //避免在某列最左边附近点击时，前一列被点中
        itemRC.height = Math.floor(rc.height / rowCount);

        for (var ri = 0; ri < rowCount; ri++)
        {
            itemRC.y = rc.y + ri * itemRC.height;
            for (var ci = 0; ci < colCount; ci++)
            {
                itemRC.x = rc.x + ci * itemRC.width;
                var index = ri * colCount + ci;
                if (index > listCount - 1) break;

                if (itemRC.contains(point))
                {
                    //如果只想callback执行一次后，就返回，那么在callback中返回true
                    if (callback(index, itemRC)) return;


                }


            }
        }
    },

    mouseClicked: function (e) {
        //点击后，数据立即入

        this.loopInItems(e, function (index, itemRC) {

            if (this.ES.ET == EditStyle.$RadioButton)
            {
                this.checked.clear();
                this.checked.push(index);
            } else
            {
                if (this.checked.contains(index))
                {
                    this.checked.remove(index);
                } else
                {
                    this.checked.push(index);
                }
            }
            return true;

        }.bind(this));

        //  强制回填数据 ,这一段改篇　BasicEdit.focusLost()
        var value = this.getWriteBackValue();
        var cell = this.Sheet.cells(this.Row, this.Col);
        //dbRow 并不一定就是dbRow,它仅表示鼠标点击可能点击的dbRow
        //2020.05.02 正在编辑中，并且它是被档住的，不需要重绘，再一个，如果是多行绑定，那么重绘把把焦点行亮显示背影擦除，所以不需重绘
        cell.setValue(value, this.currentDBRow,false);
        // 触发事件
        this.Sheet.Book.EM.fire("cellValueChangedByEdit", [this.Sheet, cell, value, this.currentDBRow]);
        // 增加，这样在点击时就触发cellClick事件
        this.$uper.mouseClicked.call(this, e);

        this.paint();

    },

    mouseMoved: function (e) {

        this.loopInItems(e, function (index, itemRC) {

            if (this.lastFocusItemIndex != index)
            {
                this.lastFocusItemIndex = index;
                this.lastFocusRect = itemRC;
                this.paint();
            }
            return true;

        }.bind(this));


    },

    /**
     * 通常是返回  cellRect 做编辑框的坐标，但是对于 radio checkbox 等，它不需要外框，只需要text 绘制部分的坐标
     * 所以应该返回 editRC ,而不是 cellRect
     */
    getBounds: function () {
        return this.editRC.clone();
    },


});

export default RadioAndMultiCheckEdit;
