/**
 * Created by 三宝爹 on 2017/10
 *
 *
 * 如下的操作引起的函数调用顺序如下： 操作：用鼠标点击某个Cell，让它编辑，然后按回车，于是下一个Cell处于编辑状态
 *
 *
 * 1 NormalEdit focusLost 　
 * 2 NormalEdit endEdit
 * 3 NormalEdit valueChanged
 * 4  keyPressed
 * 5  keyTyped
 * 6 NormalEdit BeginEdit
 * 7 NormalEdit keyReleased
 * 8  keyReleased
 *
 *
 *
 *
 *
 * 鼠标点击处所在的数据行this.mouseOnDBRow与当前实际的数据行this.currentDBRow是分离的,
 *   this.mouseOnDBRow 表示的是鼠标点击处可能的DBthis.Row，如果没有绑定，它可能为 0 ，但并不表示点击了第1个数据行，而
 *   是说，点击处理可能是第1个数据行
 *
 *   在得到数据或设置数据时，使用this.currentDBRow ,在触发相关事件时，使用 this.mouseOnDBRow
 *
 *
 *
 *   2020.05.02 终于理清了坐标问题：
 *    cellRect 是单元格的原始坐标
 *    editRC是这个单元格的编辑
 */


import Edit from './Edit.js';

import Point from '../gdi/Point.js';
import EditStyle from '../core/EditStyle.js';
import Property from '../core/Property.js';
import ALIGNMENT from '../core/ALIGNMENT.js';
import DataSourceConfig from '../core/DataSourceConfig.js';
import Tools from '../util/Tools.js';

const Logger = console;

var BasicEdit = Edit.extend({


    static:
        {

            /**
             * 把自动完成显示出的列表框移动到合适的显示位置
             * @param domObj   处理编辑状态的input对象
             */
            moveAutocomplateToAppropriatePosition: function (domObj) {

                //2019.04.18 对列表框的位置进行调整。当列表超出窗口显示区域时，把列表位置向上调
                //但不能简单地向上调，因为可能是允许编辑的，因此编辑框不能挡住。
                //所以需要把列表显示在编辑框的上面
                //autocomplete列表框显示时，会执行本事件
                //当点击单元格进入列表选择时，open事件会执行两次，原因不明，但没有什么不良影响，待查

                //$('.ui-autocomplete')是弹出的列表DOM对象

                let listHeight = $('.ui-autocomplete').height();
                let listTop = $('.ui-autocomplete').position().top;
                let windowHeight = $(window).height();
                if (listHeight + listTop > windowHeight) //超出窗口了，那么列表上移到编辑框的上面
                {
                    let top = $(domObj).offset().top - listHeight - 4;  //-4 是调试的结果
                    $('.ui-autocomplete').css('top', top + 'px');

                }

                //坐标微调，向左移一下，宽度拉宽一点，优化视觉效果
                //2020.01.09  jconfirm 库它把自已的z-index 设置成 99999999 ，列表必须比它高一层， 不然被遮挡
                $('.ui-autocomplete').css(
                    {
                        'left': ($('.ui-autocomplete').position().left - 1) + 'px',
                        'width': ($('.ui-autocomplete').width() + 6) + 'px',
                        'z-index': 99999999 + 1
                    }
                );
            }
        },

    /**
     *
     * @param domObj
     * @param focusNeedToListen  是否需要侦听 焦点失去事件
     * @param canvasClickedForceLostFocus  是否需要在点击其它地方时，回调本编辑的某个事件，补尝没有焦点失去事件
     *
     * 现在已经的编辑方式中  DatetimeEdit 是  （false, false)
     *                     TreeEdit 是（ false, true)
     *
     */
    constructor: function (domObj, focusNeedToListen, outsideClickedForceLostFocus) {

        this.$uper.constructor();

        if (focusNeedToListen == undefined) focusNeedToListen = true; //焦点事件需要侦听，用来控制编辑回填吗

        if (outsideClickedForceLostFocus == undefined) outsideClickedForceLostFocus = false;

        this.domObj = domObj;

        this.focusLosted = false;
        this.Sheet = null;
        this.View = null;
        this.Row = 0;
        this.Col = 0;
        this.mouseOnDBRow = -1;
        this.currentDBRow = -1;

        this.Escape = false;
        this.beginEditRequestFocus = true;
        this.clearData = false;
        this.contextMenuEnabled = true;
        this.enterKeyPressed = false;
        this.isShiftDown = false;
        this.isControlDown = false;
        this.showDebugInfo = false;
        this.readOnly = false;

        this.cellRect = null;
        this.editRC = null;
        this.buildinButtonRC = null; //内建按钮所在的区域。有时会在编辑框上显示一个假按钮 ，用来提供一些功能，这个用来做点击测试
        this.textWhenBeginEdit = "";
        this.buttonImage = null;
        //下在两个在beginEdit 中用到，对焦点事件做特别的处理
        this.focusNeedToListen = focusNeedToListen;
        this.outsideClickedForceLostFocus = outsideClickedForceLostFocus;


    },

    debugInfo: function (info) {
        if (this.showDebugInfo) console.info(info);

    },


    getCurrentDBtRow: function () {
        return this.currentDBRow;
    },


    valueWhenBeginEdit: function () {
        var cell = this.Sheet.cells(this.Row, this.Col);
        var s = cell.getEditText(this.currentDBRow);
        return s;
    },


    beginEdit: function (sheet, view, row, col, value, rect, mouseEvent, innerRow, readOnly) {

        this.readOnly = readOnly;
        var mouse = null;
        if (mouseEvent != null) mouse = new Point(mouseEvent.offsetX, mouseEvent.offsetY);


        this.cellRect = rect.clone();
        this.editRC = rect.clone();

        this.Row = row;
        this.Col = col;
        this.Sheet = sheet;
        this.View = view;
        var /*String*/  s = "";

        var cell = this.Sheet.cells(row, col);

        this.editRC = cell.getTextRectangleOfCell(this.editRC);


        if (readOnly) this.setEditable(false);
        var prop = cell.getPropertyObject();


        view.$setCurrentEditingEdit(this);
        cell.setIsEditing(true);


        this.setFont(cell.getPropertyObject());

        this.setPlaceholder(cell.placeholder);


        var /*DBBindConfig*/ bind = cell.bind;
        var RPM = this.Sheet.RPM;

        var dbRowHeight = RPM.getRowHeight(row);
        var yOffset = 0;  //单元格内在垂直方向显示的偏移量

        var /*boolean*/  isBindToMultiRowDataSource = false;
        if (bind == null)
        {
            this.mouseOnDBRow = -1;
            this.currentDBRow = -1;

            if (mouse != null)
            {

                this.mouseOnDBRow = innerRow;

            }
        } else
        {
            var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(bind.dataSource);
            // 如果是绑定到单行DataStore上
            if (bind.dataSourceType == DataSourceConfig.SingleRowDataSource)
            {
                this.mouseOnDBRow = 0;
            } else if (bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource)
            {
                this.mouseOnDBRow = dsc.currentBindRow;
            } else
            {
                isBindToMultiRowDataSource = true;
                this.mouseOnDBRow = Math.min(innerRow, dsc.dataStore.rowCount - 1);
            }

            this.currentDBRow = this.mouseOnDBRow;
            //编辑坐标，其实与单元格自身绑定到单行，还是多行数据源无关，因为一个绑定到单元行数据源的单元格，也可能处于一个多行绑定区中
            var mrdsn = this.Sheet.RPM.getMultiRowDataSourceName(row);
            if (mrdsn != '')
            {
                var oneDataRowHeight = this.Sheet.RPM.getOneDataRowHeightOfDataSource(mrdsn);

                this.cellRect.y += this.mouseOnDBRow * oneDataRowHeight - yOffset;
                this.editRC.y += this.mouseOnDBRow * oneDataRowHeight - yOffset;


            }

        }


        //控制区域在有效的范围内
        var limitSize = function (sheet, cellRect) {
            var RHW = sheet.RPM.getRowHeadWidth();
            if (cellRect.x < RHW)
            {
                cellRect.width = cellRect.width + cellRect.x - RHW;
                cellRect.x = RHW;
            }
            var CHH = sheet.CPM.getColumnHeadHeight();
            if (cellRect.y < CHH)
            {
                cellRect.height = cellRect.height + cellRect.y - CHH - 1;
                cellRect.y = CHH + 1;
            }
        };

        limitSize(this.Sheet, this.cellRect);
        limitSize(this.Sheet, this.editRC);


        this.setBounds(this.getBounds(), cell.getPropertyValue(Property.word_wrap, false));

        this.setAttributer();

        this.customizeBeginEdit();//要放在buildEditText前面， 因为 TreeEdit中tree在这里初始化，而在buildEditText中设置树的当前选中项
        //可能有这种情况：单元格是有数据的，比如 aaa ,但是直接按了一个b ,激活了编辑状态，并且编辑框中是b
        //意味着要用b替换原值aaa ,
        this.buildEditText(value);
        //记录下开始编辑前，单元格的原值（字符化后的）
        //注意，它与value 可能并不是一样的。 比如上例中， textWhenBeginEdit=aaa
        this.textWhenBeginEdit = this.valueWhenBeginEdit();


        if (this.beginEditRequestFocus) this.longForFocus();


        //事件的侦听
        this.addMouseListener(this);
        this.addKeyListener(this);

        //如果用焦点事件来控制编辑回填，那么注册焦点事件
        if (this.focusNeedToListen)
        {
            this.addFocusListener(this);
        }

        if (this.outsideClickedForceLostFocus)
        {
            //否则在视图的click事件中回调本对象的focusLost函数
            // 对于一些复杂界面的编辑方式，比如弹出一个树，或一个sheet来编辑的方式，就不能用本对象对应的DOM对象的focusLost事件来回填数据
            // 因为弹出界面中的编辑对象得到焦点时，本对象的DOM对象的blur就触发了，而此时是不能回填数据的
            // 所以需要临时在document(或canvas)上 注册click事件来触发本对象的 focusLost

            //bind注册事件，当失去焦点函数被调用后，需要取消click事件注册，下次点击时，不需要再执行
            //这里有两个细节，
            // 1 不能直接传入this.canvasClickedForceLostFocus , 因为在document的click触发事件时
            // canvasClickedForceLostFocus函数中的this是document对象，即事件发生时的对象，而不是本对象
            // 所以需要用 canvasClickedForceLostFocus.bind(this)来绑定this对象
            // 2  canvasClickedForceLostFocus.bind(this)必须缓存起来， 因为在unbind中需要用来此函数句柄，
            // 不能用   $(document).unbind( 'click' , this.canvasClickedForceLostFocus.bind(this));
            // 这是因为  var  f1= this.canvasClickedForceLostFocus.bind(this);
            //          var  f2= this.canvasClickedForceLostFocus.bind(this);
            //   f1 != f2  ,所以如果不缓存函数句柄，那么在unbind时，会出现无法取消事件注册

            this.handle_canvasClickedForceLostFocus = this.canvasClickedForceLostFocus.bind(this);
            $(document).bind("click", this.handle_canvasClickedForceLostFocus);

        }

        this.Sheet.Book.EM.fire('beginEdit', [this.Sheet, this.Row, this.Col, this.mouseOnDBRow]);

        //TODO 这个Rect，用来做点击测试
        //calcuBuildinButtonRC();

        // 如果是点击鼠标引起的开始编辑，那么手工强制触发一下编辑控件的mouseClicked 事件
        //但需要注意，在 事件中，getPoint()得到的点是相对workthis.SheetView的坐标，需要自已转换成相对编辑控件的坐标
        if (mouse != null) this.mouseClicked(mouseEvent);

        this.initCaretPosition();

    },

    //设置光标的位置
    initCaretPosition: function () {

    },

    reloadEdit: function () {
        var cell = this.Sheet.cells(this.Row, this.Col);

        this.buildEditText(null);

        this.Sheet.Book.EM.fire('beginEdit', [this.Sheet, this.Row, this.Col, this.mouseOnDBRow]);


    },

    /**
     * 当点击View让单元格处于编辑状态后， 本对象的DOM对象会在cell的位置上显示 ，如果此时在它上面点击鼠标，那么事件冒泡到document上
     * 后，本函数被执行，此时要根据点击的坐标来判断，如果是在本对象对应的DOM上点击，那么不要执行focusLost ,否则，执行focusLost
     * 并取消document的click事件注册 。
     * @param e
     */
    canvasClickedForceLostFocus: function (e) {

        //是真实的点击，而不是模拟时，判断点击点
        if (e != null)
        {
            var rc = this.getBounds(); //rc 是相对sheetView的
            var x, y;
            if (this.domObj != null && e.target == this.domObj[0])//此时是直接点击在input内，所以此时的offsetX是相对于input的,现在转换成相对sheetView
            {
                x = e.offsetX + this.editRC.x;
                y = e.offsetY + this.editRC.y;
            } else//当鼠标在canvas上点击，此时  e.target是canvas ,此时的 e.offsetX是相对于canvas左上角的
            {
                x = e.offsetX;
                y = e.offsetY;

            }

            if (rc.contains({x: x, y: y}))
            {

                console.info("click on self");
                return;
            }
        }

        this.focusLost();
        if (this.outsideClickedForceLostFocus)
        {
            $(document).unbind("click", this.handle_canvasClickedForceLostFocus);
        }
    },


    addMouseListener: function () {
        var me = this.domObj;

        me.click({clickCount: 1}, this.mouseClicked.bind(this));
        me.dblclick({clickCount: 2}, this.mouseClicked.bind(this));
        me.mousedown(this.mousePressed.bind(this));
        me.mouseup(this.mouseReleased.bind(this));
        me.mouseenter(this.mouseEntered.bind(this));
        me.mouseout(this.mouseExited.bind(this));
        me.mousemove(this.mouseMoved.bind(this));


    },

    addKeyListener: function () {
        var me = this.domObj;
        me.keydown(this.keyPressed.bind(this));//按下任意键
        me.keyup(this.keyReleased.bind(this));//松开
        me.keypress(this.keyTyped.bind(this));//按了一个可显示的字符
    },

    addFocusListener: function () {
        var me = this.domObj;

        //2020.03.29修正 ， 当在移动设备上选择日期时，input的 readOnly=true
        //但是它仍是可以获取 focus和失去focus事件的，
        //此时在日期面板上操作时，会触发 focusLost，那么此时数据回填是不需要的
        //所以在创建DOM时，直接就把 readOnly设置成了true ,此种情况下， 不需要焦点事件
        if (this.focusNeedToListen)
        {
            console.info(" add foucs listen");
            me.focus(this.focusGained.bind(this));
            me.blur(this.focusLost.bind(this));
        } else
        {
            console.error("dont listen focus ");
        }

    },

    setAttributer: function () {
        var es = this.Sheet.cells(this.Row, this.Col).ES;
        if (es == null) return;
        var attrs = es.inputAttribute || '';
        if (attrs == '') return;


        attrs = attrs.trim(); //去掉前后空格
        attrs = attrs.replace(/\s+/g, ',"');

        attrs = attrs.replace(/=/g, '":');
        attrs = '{"' + attrs + '}';

        try
        {
            attrs = JSON.parse(attrs);

            for (var p in attrs)
            {
                this.domObj.attr(p, attrs[p]);
            }

        } catch (err)
        {
            console.error(err);

        }


    },
    setBounds: function (rc, word_wrap) {


        var es = this.Sheet.cells(this.Row, this.Col).ES;

        var b = true;

        if (es != null)
        {
            if (es.ET == EditStyle.$DDLB && Tools.isMobile())
            {
                this.domObj.css("readonly", 'true');
                this.domObj.css("display", 'none');
                return;
            }

            if (es.ET == EditStyle.$CheckBox ||
                es.ET == EditStyle.$RadioButton ||
                es.ET == EditStyle.$MultiCheckBox
            )
            {
                b = false;
            }



        }

        // checkbox , radiobutton 要保证查看时及编辑时，坐标保持一至，所以它的坐标是严格保持一至
        //其它的编辑格式，都缩小一个点
        if (b)
        {
            rc.x = rc.x+1;
            rc.y = rc.y+ 1;
            rc.width  = rc.width-1;
            rc.height  =rc.height - 1;
        }

        this.domObj.css("left", rc.x + "px");
        this.domObj.css("top", rc.y + "px");
        this.domObj.css("width", rc.width + "px");
        this.domObj.css("height", rc.height + "px");

        var es = this.Sheet.cells(this.Row, this.Col).ES;
        if (es != null)
        {
            if (es.ET != EditStyle.$MultiLine)
            {
                if (word_wrap == '') this.domObj.css("line-height", rc.height + "px");
            }
        } else
        {
            if (word_wrap == '') this.domObj.css("line-height", rc.height + "px");
        }

    },

    setPlaceholder: function (ph) {
        var obj = this.domObj[0];
        if (obj) obj.placeholder = ph;
    },

    /**
     * 定制编辑，在beginEdit 事件触发前执行
     */
    customizeBeginEdit: function () {

    },


    getBounds: function () {
        return this.cellRect.clone();
    },

    /**
     * 得到输入焦点
     */
    longForFocus: function () {
        this.domObj[0].focus();
    },


    setFont: function (prop) {

        var font_family = prop.get(Property.font_family, "");
        var font_size = prop.get(Property.font_size, 12);
        var font_bold = prop.get(Property.font_bold, false);
        var font_italic = prop.get(Property.font_italic, false);
        var font_underline = prop.get(Property.font_underline, false);
        var align_h = prop.get(Property.text_align, ALIGNMENT.Left);
        var align_v = prop.get(Property.vertical_align, ALIGNMENT.Center);

        //设置 line-height

        if (font_family != '') this.domObj.css("font-family", font_family);
        this.domObj.css('font-size', font_size + "px");
        if (font_bold) this.domObj.css('font-weight', "bold");
        if (font_italic) this.domObj.css('font-style', 'italic');

        if (align_h == ALIGNMENT.Left) this.domObj.css('text-align', 'left');
        if (align_h == ALIGNMENT.Right) this.domObj.css('text-align', 'right');
        if (align_h == ALIGNMENT.Center) this.domObj.css('text-align', 'center');

        if (align_v == ALIGNMENT.Top) this.domObj.css('vertical-align', 'top');
        if (align_v == ALIGNMENT.Bottom) this.domObj.css('vertical-align', 'bottom');
        if (align_v == ALIGNMENT.center) this.domObj.css('vertical-align', 'middle');

    },


    setEditable: function (b) {
        if (b)
        {

        } else
        {
            this.domObj.attr("readonly", true);
            this.domObj.attr("disabled", true);
        }

    },

    //TODO  splash
    splash: function (/*boolean*/  b) {
        if (!b)
        {
        }


    },


    setValue: function (s) {
        if (this.domObj) this.domObj.val(s);
        this.focusGained(null);

    },

    getText: function () {
        if (this.domObj)
        {
            return this.domObj.val();
        } else
        {
            return this.text;
        }
    },

    setText: function (t) {
        if (this.domObj)
        {
            this.domObj.val(t);
        } else
        {
            this.text = t;
        }
    },

    calcuBuildinButtonRC: function () {
        this.buildinButtonRC = new Rectangle(0, 0, 0, 0);
        var cell = this.Sheet.cells(this.Row, this.Col);

    },


    getButtonImage: function () {
        return "spreadsheet/img/comment.png";

    },


    giveUpFocus: function () {

        if (this.domObj) this.domObj[0].blur();

    },


    focusGained: function (e) {
        //TODO 选中
        /*
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
        try
        {
            this.setCaretPosition(this.getText().length());
        } catch (Exception ee)
        {

        }
        */
    },

    getCell: function () {
        if (this.Sheet == null) return null;
        return this.Sheet.cells(this.Row, this.Col);
    },

    // 失去焦点

    removeSelf: function () {
        if (!this.domObj) return;

        this.domObj.remove();
        this.domObj = null; //
    },


    fillBack: function () {
        if (this.Sheet == null) return;
        if (this.readOnly) return;

        var cell = this.Sheet.cells(this.Row, this.Col);
        var value = null;
        if (!this.clearData) value = this.getWriteBackValue();
        //
        // dbthis.Row这个很重要，
        // 因为有可能会出现 dbthis.Row 与 数据源的currentBindRow不相等，这将导致数据回填错位
        // 所以强制带上参数dbthis.Row 保证了数据不会错位
        var /*String*/  currentText = this.getText();

        // 如果编辑中的文本与开始编辑时一样，那么不需要回填到单元格中，因为整了一圈什么事都没有发生
        if (currentText != this.textWhenBeginEdit || this.clearData)
        {

            //2019.09.11 增加，如果设置值成功，那么才触发事件
            if (cell.setValue(value, this.currentDBRow))
            {
                // 触发事件
                this.Sheet.EM.fire("cellValueChangedByEdit", [this.Sheet, cell, value, this.currentDBRow]);
            }
        }

    },

    focusLost: function (e) {


        this.splash(false);

        var cell = this.Sheet.cells(this.Row, this.Col);
        //先设置成不在编辑状态，这样下面用setvalue时，才不会在CellValueChanged事件中导致自己ReloadEdit
        cell.setIsEditing(false);

        //为什么要先判断domObj是不是存在。是因为在DatetimeEdit 中，会把domObj先移除，再加一个input来接收弹出窗口选择的日期值
        //当弹出窗口关闭时，还要手工触发本函数来回填，而此时this.domObj早已不存在了
        try
        {
            //先不可见，下面的重绘，就不会被挡住，如果不先隐匿，会闪一下
            if (this.domObj) this.domObj.css("display", "hidden");
        } catch (err)
        {
            console.info(err);
        }

        if (this.View == null) return;
        var currentEdit = this.View.$getCurrentEditingEdit();


        // 把当前编辑控件置为非自己，（因为可能当前已经是其它编辑控件了）

        if (currentEdit == this) this.View.$clearCurrentEditingEdit(this);

        if (!this.Escape) // 如果不是忽略
        {
            this.fillBack();
        }


        cell.repaint();


        this.Sheet.EM.fire('endEdit', [this.Sheet, this.Row, this.Col, this.mouseOnDBRow,
            this.enterKeyPressed, this.isShiftDown, this.isControlDown]);


        this.removeSelf();//最后再移除，并设置this.domObm=null


    },

    keyTyped: function (e) {
        this.Sheet.Book.View.lastKeyEvent = e;
        this.splash(false);

        switch (e.keyCode)
        {
            case Edit.VK_TAB:
            case Edit.VK_ENTER:
                var es = this.Sheet.cells(this.Row, this.Col).ES;
                if (es != null)
                {
                    if (es.ET == EditStyle.$MultiLine) return; //多行编辑，那么这些按钮都需要被textarea接收，而不是跳出编辑
                }
                e.preventDefault();
                break;
        }

    },

    keyPressed: function (e) {

        this.Sheet.Book.View.lastKeyEvent = e;

        this.isShiftDown = e.shiftKey;
        this.isControlDown = e.ctrlKey;

        var keyCode = e.keyCode;
        //console.info(keyCode);

        var es = this.Sheet.cells(this.Row, this.Col).ES;
        if (es != null)
        {
            if (es.ET == EditStyle.$MultiLine) return; //多行编辑，那么这些按钮都需要被textarea接收，而不是跳出编辑
        }

        switch (keyCode)
        {
            //

            case Edit.VK_UP:
            case Edit.VK_DOWN:

                this.enterKeyPressed = true;

                // 触发本窗口的OnKillFocus事件，将编辑的内容回填到网格中
                this.giveUpFocus();

                this.View.keyPressed(e, this.Row, this.Col, this.mouseOnDBRow);
                //这个实际上是模拟按回车，进入编辑状态
                e.keyCode = Edit.VK_ENTER;

                this.View.keyTyped(e);

                break;

            case Edit.VK_TAB:
                // 触发本窗口的OnKillFocus事件，将编辑的内容回填到网格中
                this.giveUpFocus();
                break;
            case Edit.VK_ENTER:
                // 触发本窗口的OnKillFocus事件，将编辑的内容回填到网格中
                this.enterKeyPressed = true;

                // 触发本窗口的OnKillFocus事件，将编辑的内容回填到网格中
                this.giveUpFocus();
                this.View.keyPressed(e, this.Row, this.Col, this.mouseOnDBRow);
                this.View.keyTyped(e);
                break;

            case Edit.VK_ESCAPE:
                this.Escape = true;
                this.giveUpFocus();
                return;
            case Edit.VK_DELETE:
                if (e.ctrlKey)
                {
                    this.clear();
                    return;
                }

            default:
                break;
        }

    },

    keyReleased: function (e) {
        this.Sheet.Book.View.lastKeyEvent = e;

        this.View.keyReleased(e, this.Row, this.Col, this.mouseOnDBRow);
    },


    clear: function () {

        this.clearData = true;

        this.giveUpFocus();
    },

    /*@Override*/
    //本函数主要用来处理从Excel粘贴数据
    // 从Excel中选中一个区域后，复制，再粘贴这到里，数据变成了以\t分隔列以回车（如果本控件是多行的）
    // 或空格（如果本控件是单行的）分隔的字符串，因此需要对数据进行拆分
    // 粘贴遵循如下的原则：
    // 如果当前是设计模式，那么进行单元格对应的粘贴
    //如果是运行模式
    // 如果当前单元格是单行绑定的，那么理解为Excel中选中的区域中的所有单元格与本this.Sheet相应单元格
    //之间进行的都是单行绑定的粘贴，如果其中的某些单元格没有绑定数据源，那么忽略对它们的处理
    //如果当前单元格是多行绑定的，那么理解为把Excel中区域的数据粘贴到同一个数据源中的不同行中。
    paste()
    {

        //TODO paste

    },


    addContextSubMenu: function (pmi, subMenu) {
        //TOOD  addContextSubMenu
    },

    mouseClicked: function (e) {


    },

    mouseEntered: function (e) {

    },

    mouseExited: function (e) {

    },

    mousePressed: function (e) {
        this.splash(false);
    },

    mouseReleased: function (e) {

    },

    mouseDragged: function (e) {

    },

    mouseMoved: function (e) {


    },


    edit_selectAll()
    {

    },

    edit_copy()
    {


    },

    edit_paste()
    {
        this.paste();

    },

    edit_cut()
    {

    },

    edit_clear()
    {
        this.clear();
        this.setValue("");

    },

    getCaretPosition: function () {
        if (!this.domObj) return 0;
        var el = $(this.domObj)[0];
        return el.selectionStart;

    },

    setCaretPosition: function (index) {
        if (!this.domObj) return;
        var el = $(this.domObj)[0];
        el.selectionStart = index;
        el.selectionEnd = index;

    },

    getSelectionPosition: function () {
        if (!this.domObj) return 0;
        var el = $(this.domObj)[0];
        return {start: el.selectionStart, end: el.selectionEnd};

    },
    setSelectionPosition: function (leftIndex, rightIndex) {
        if (!this.domObj) return;
        var el = $(this.domObj)[0];
        el.selectionStart = leftIndex;
        el.selectionEnd = rightIndex;

    },

    replaceSelection: function (txt) {
        if (!this.domObj) return;
        var el = $(this.domObj)[0];
        var start = el.selectionStart;
        var end = el.selectionEnd;
        var t = el.value;
        t = t.substring(0, start) + txt + t.substring(end);
        el.value = t;
        this.setCaretPosition(start + txt.length);

    }

});

export default BasicEdit;
