/**
 *
 * 数据库方言
 * Created by zengjun on 2017/5
 */


import Dialect from './Dialect.js';
import UniformDataType from '../core/UniformDataType.js';
import ObjectTool from "./ObjectTool.js";

var  DialectOracle = Dialect.extend({


    constructor: function (ds) {

        this.$uper.constructor(ds, "Oracle");

    },

    getFormatedTextValue: function (/*Object*/ v, /*UniformDataType*/ dataType, /*int*/ decimalCount) {
        if (v == null) return "NULL";

        var bstr = "";  //

        switch (dataType)
        {

            case UniformDataType.$Datetime:
                var t = ObjectTool.changeType(v, UniformDataType.$Datetime);

                if (t == null) return "NULL";
                bstr = "to_date('" + t.Format("yyyy.MM.dd HH:mm:ss")  +"','YYYY.MM.DD HH24:MI:SS')";
                break;
            default :

                bstr = this.$uper.getFormatedTextValue(v, dataType, decimalCount);
                break;
        }


        return bstr;

    },
    /**
     *  日期需要用-分隔，同不是用.号
     * @param sql
     * @returns {*}
     */
    toLocalSyntax: function (sql) {
        /*

         " \\s*([a-zA-Z0-9_\\)]+)\\s*([><=!]{1,2})\\s*('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}')"
         \\s* 表示字段名前面可以有或或者没有空格
         ([a-zA-Z0-9_\\)]+) 表示到少一个字符表示的字段名 或一个函数包围起来的至少以回括号结束，
         比如 ( rq>=   或　aa.rq>=  或   nvl( rq, sysdate) >=  都匹配 , 最后一个示例中运算符号之前是一个回括号
         \\s*\\(*\\s*表示字段名后可以有或者没有空格，可能会有(
         ([><=!]{1,2})表示其中的字符出现一个，或两个
         \\s*表示算符后可以有０到n个空格
         ('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}')  表示　yyyy.mm.dd 表示的格式并且用单引号引着
         \\s*\\)*\\s*表示字段名后可以有或者没有空格，可能会有)

         */

        //TODO
        return sql;
    }


});

export default DialectOracle;
