/**
 *
 * 数据库方言
 * Created by zengjun on 2017/5
 */


import Dialect from './Dialect.js';
import UniformDataType from '../core/UniformDataType.js';
import ObjectTool from "./ObjectTool.js";

var DialectMySQL = Dialect.extend({


    constructor: function (ds) {

        this.$uper.constructor(ds, "MySQL");

    },

    getFormatedTextValue: function (/*Object*/ v, /*UniformDataType*/ dataType, /*int*/ decimalCount) {
        if (v == null) return "NULL";

        var bstr = "";  //

        switch (dataType)
        {

            case UniformDataType.$String:
                var t = '' + v;
                if (t == null) return "NULL";
                t = this.escapeString(t);
                bstr = "'" + t + "'";
                break;
            default :

                bstr = this.$uper.getFormatedTextValue(v, dataType, decimalCount);
                break;
        }


        return bstr;

    },

    toLocalSyntax: function (sql) {
        sql = this.escapeString(sql);
        return sql;
    },

    escapeString: function (t) {
        t = t.replace(/\\/g, '\\\\\\\\');
        return t;
    }


});

export default DialectMySQL;
