/**
 * 由所在服务提供数据的检索更新的功能支持
 *
 * 其中  name , id , templateid 分别是结果集在模板中的名称 ，校验ID  ， 模板ID
 *
 * 其中 id用于校验 name是否被非法篡改， 模板ID用于服务端where的支持及更严格的数据操作权限控制，它也是加密过了
 * 任何企图篡改 name , id 及 templateid的行为都会在服务端校验中触发异常。
 *
 */


import DataProvider from './DataProvider.js';
import ajax from '../util/ajax.js';

var DataProviderByNode = DataProvider.extend({

    constructor: function (url) {
        if (!url.endsWith('/')) url += '/';
        this.homeURL = url;

    },

    newDataStore: function (name, id, templateid, dsn, select) {
        var dsConfig = null;
        ajax.post(this.homeURL + 'DataStore/newDataStore',
            {
                name: name,
                id: id,
                templateid: templateid,
                dsn: dsn,
                select: select,
                currentGUID: $('meta[name="currentGUID"]').attr("content") || '',
                moduleDefine: $('meta[name="moduleDefine"]').attr('content') ||'',
                authorizationKey: $('meta[name="AuthorizationKey"]').attr("content") || '',
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr("content") || ''

            },
            function (result) {
                dsConfig = JSON.parse(result);
            },
            'text',
            false);
        return dsConfig;

    },

    //additionalWhere 可能是一个where条件数组，它已经拼在select 中了，之所以单独放一个参数传到后端，是
    //因为可能后台会用脚本来组织数据，而 additionalWhere 则是前台传到后台的条件参数，可在脚本中使用
    retrieve: function (name, id, templateid, dsn, select, where, onceRetrieveCount, absolute,
                        additionalWhere, originalSQL,orderby , retrieveContext ,callback,useCache) {
        var result = null;
        console.info("DataProviderDefault.retrieve");

        ajax.post(this.homeURL + 'DataStore/retrieve',
            {
                name: name,
                id: id,
                templateid: templateid,
                dsn: dsn,
                select: select,
                where: where,
                additionalWhere: additionalWhere,
                orderby:orderby,
                onceRetrieveCount: onceRetrieveCount,
                originalSQL: originalSQL,
                retrieveContext:retrieveContext,
                absolute: absolute,
                useCache:useCache,
                currentGUID: $('meta[name="currentGUID"]').attr("content") || '',
                moduleDefine: $('meta[name="moduleDefine"]').attr('content') ||'',
                authorizationKey: $('meta[name="AuthorizationKey"]').attr("content") || '',
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr("content") || ''
            },
            function (retVal) {
                result = JSON.parse(retVal);
                if (callback) callback(result);
            },
            'text',
            callback != undefined);  //callback==undefined时，是同步调用
        return result;
    },


    update: function (name, id, templateid, dsn, sqls) {
        var result = null;
        ajax.post(this.homeURL + 'DataStore/update',
            {
                name: name,
                id: id,
                templateid: templateid,
                dsn: dsn,
                sqls: sqls,
                currentGUID: $('meta[name="currentGUID"]').attr("content") || '',
                moduleDefine: $('meta[name="moduleDefine"]').attr('content') ||'',
                authorizationKey: $('meta[name="AuthorizationKey"]').attr("content") || '',
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr("content") || ''
            },
            function (retVal) {
                result = JSON.parse(retVal);
            },
            'text',
            false);
        return result;

    },

    /**
     * 当不提供 callback时， 是同步调用 ，否则是异步调用
     * @param dsn
     * @param select
     * @param where
     * @param callback
     * @returns {*}
     */
    getDBRowCount: function (name, id, templateid, dsn, select, where, additionalWhere, orderby, retrieveContext,callback) {

        var result = null;
        ajax.post(this.homeURL + 'DataStore/getDBRowCount',
            {
                name: name,
                id: id,
                templateid: templateid,
                dsn: dsn,
                select: select,
                where: where,
                additionalWhere: additionalWhere,
                orderby:orderby,
                retrieveContext:retrieveContext,
                currentGUID: $('meta[name="currentGUID"]').attr("content") || '',
                moduleDefine: $('meta[name="moduleDefine"]').attr('content') ||'',
                authorizationKey: $('meta[name="AuthorizationKey"]').attr("content") || '',
                authorizationTemplate: $('meta[name="AuthorizationTemplate"]').attr("content") || ''
            },
            function (retVal) {
                result = JSON.parse(retVal);
                if (callback) callback(result.DBRowCount);
            },
            'text',
            callback != undefined);  //callback==undefined时，是同步调用
        return result;
    },

    toLocalSyntax: function (sql) {

        return sql;
    }


});

export default DataProviderByNode ;
