/**
 * Created by zengjun on 2017/5
 */

import Class from '../base/Class.js';
import AggregateType from './AggregateType.js';
import AggregateDefine from './AggregateDefine.js';
import ObjectTool from "./ObjectTool.js";
import UniformDataType from '../core/UniformDataType.js';

var ColumnProperty = Class.extend({

    constructor: function (ds) {
        this.m_ds = ds;
        /*DataStore  */
        this.m_Name = "";
        this.m_DBName = "";
        this.m_DBTable = "";
        this.m_DatabaseName = '';
        this.m_UpdateWhereClause = '';
        this.m_Updatable = false;
        ''									//是否允许更新
        this.m_DataType = 0;
        /*int*/
        this.m_UniformDataType = 0;
        /*int*/
        this.m_DataTypeName = '';
        this.m_ObjType = 0;										//int 对象类型

        this.m_Formula = '';										//表达式
        this.m_DependMap = null;
        /*HashMap*/			//依赖列表
        this.m_AffectMap = null;
        /*HashMap*/			//影响列表

        this.m_ColumnLabel = "";									//标签名称
        this.m_ColumnTag = null;									// 附加数据
        this.m_DefaultValue = null;        //缺省数据，在InsertRow后，自动填充到字段
        this.m_ColumnClassName = "";
        this.m_IncludeUnsureFunction = false; //是不是包含有非确定性函数或变量
        this.m_FillBack = "";
        this.m_typeRedefine = "";

        this.ColumnDisplaySize = '';
        /*int*/
        this.Precision = 0;
        /*int*/
        this.Scale = 0;
        /*int*/
        this.Nullable = true;
        /*boolean*/
        this.m_Property = null;
        /*HashMap*/
        this.m_format = ""; // 输出成字符串时的格式
        this.m_AggregateDefine = null;
        /*AggregateDefine*/

        this.m_InsteadOfNull = null;					// 一定设成私有
        this.m_Data2ViewMap = null;


    },

    /**
     * 当本列中的某行中的值为空时，在表达式中（计算列的表达式等）用这个函数的返回值代替
     * @return
     */
    /*Object*/ getValueInsteadOfNull: function () {
        if (this.m_InsteadOfNull != null)
        {
            return this.m_InsteadOfNull;
        }

        switch (this.m_UniformDataType)
        {
            case UniformDataType.$Integer :
                this.m_InsteadOfNull = 0;
                break;
            case UniformDataType.$Numeric :
                this.m_InsteadOfNull = 0.0;
                break;
            case UniformDataType.$String :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Datetime :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Binary :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Other :
                this.m_InsteadOfNull = '';
                break;

        }
        return this.m_InsteadOfNull;
    },

    /**
     * 在解析表达式时，如果值为空，就用this.m_InsteadOfNull代替。系统会缺省给出这个值（如果没有指定的话）
     * 也可以用本函数强制指定代替空值的值
     * @param obj
     * @return boolean
     */
    setValueInsteadOfNull: function (obj) {
        if (obj == null) return false;
        this.m_InsteadOfNull = ObjectTool.ChangeType(obj, this.m_UniformDataType);
        return true;

    },

    getUniformDataType: function () {
        return this.m_UniformDataType;
    },

    serializerToXML: function (XmlWriter) {

    },

    /**
     * 得到该列的说明
     * @return  String
     */

    getColumnLabel: function () {
        return this.m_ColumnLabel;
    },
    /**
     * 设置该列的文字说明
     * @param columnLabel
     */
    setColumnLabel: function (columnLabel) {
        this.m_ColumnLabel = columnLabel;
    },
    /**
     *  得到该列的附加数据
     * @return  Object类型
     */

    getColumnTag: function () {
        return this.m_ColumnTag;
    },
    /**
     * 为该列设置一个附加数据
     * @param columnTag   Object型
     */
    setColumnTag: function (columnTag) {
        this.m_ColumnTag = columnTag;
    },
    /**
     * 该列是否允许Update
     * @return
     */

    isUpdatable: function () {
        return this.m_Updatable;
    },
    /**
     * 得到该列是否允许Update
     * @param updatable
     */
    setUpdatable: function (updatable) {
        if (m_ObjType != ObjectType.isColumn) return;
        this.m_Updatable = updatable;
    },

    /**
     * 得到该列是否参与构造where 子句
     * @return boolean
     */

    isInUpdateWhereClause: function () {
        return this.m_UpdateWhereClause;
    },
    /**
     * 设置该列是否参与构造where 子句
     * @param updateWhereClause
     */

    setUpdateWhereClause: function (updateWhereClause) {
        this.m_UpdateWhereClause = updateWhereClause;
    },
    /**
     * 得到该列的数据类型
     * @returnn  int
     */

    getDataType: function () {
        return this.m_DataType;
    },
    /**
     * 得到该列的数据类型 名称
     * @return String
     */

    getDataTypeName: function () {
        return this.m_DataTypeName;
    },


    /**
     * 该列对应的数据库中的字段名称
     * @return String
     */


    getDBName: function () {
        return this.m_DBName;
    },


    /**
     * 得到该列所属的表
     * @return  String
     */


    getDBTable: function () {
        return this.m_DBTable;
    },


    setDBTable: function (table) {
        this.m_DBTable = table;
    },
    /**
     * 如果本列是计算列，那么得到它的公式
     * @return  String
     */


    getFormula: function () {
        return this.m_Formula;
    },
    /**
     * 得到本列的名称
     * @return String
     */

    getName: function () {
        return this.m_Name;
    },
    /**
     * 得到本列的类型，它们是接口ObjectType中定义的常量
     *
     * @return 列的类型   int
     *
     * <pre>
     * isColumn = 0;
     * isDBComputer = 1;
     * isUserComputer = 2;
     * isUserColumn = 4;
     * isAggregateComputer = 8;
     * isUnknown = 99;
     * </pre>
     */

    getObjType: function () {
        return this.m_ObjType;
    },


    getColumnDisplaySize: function () {
        return this.ColumnDisplaySize;
    },

    setColumnDisplaySize: function (columnDisplaySize) {
        this.ColumnDisplaySize = columnDisplaySize;
    },

    isNullable: function () {
        return this.Nullable;
    },

    setNullable: function (nullable) {
        this.Nullable = nullable;
    },

    getPrecision: function () {
        return this.Precision;
    },

    setPrecision: function (precision) {
        this.Precision = precision;
    },


    getScale: function () {
        return this.Scale;
    },

    setScale: function (scale) {
        this.Scale = scale;
    },


    getDefaultValue: function () {

        return this.m_DefaultValue;
    },


    setDefaultValue: function (value) {
        this.m_DefaultValue = value;

    },


    getPropertyObject: function (index) {
        if (index < 0) return null;
        if (index >= this.getPropertyCount()) return null;
        if (this.m_Property == null) return null;
        var n = 0;
        for (var p in this.m_Property)
        {
            if (n == index) return this.m_Property[p];
            n++;
        }

        return null;

    },


    getPropertyObject: function (propName) {
        if (this.m_Property == null) return null;
        return this.m_Property[propName.toLocaleString()];

    },


    getPropertyCount: function () {
        if (this.m_Property == null) return 0;
        var n = 0;
        for (var p in this.m_Property)
        {
            n++;
        }
        return n;
    },


    setProperty: function (propName, value) {
        if (this.m_Property == null) this.m_Property = {};
        this.m_Property[propName.toLowerCase()] = value;

    },


    getData2ViewMap: function () {
        return this.m_Data2ViewMap;
    },


    setData2ViewMap: function (map) {
        this.m_Data2ViewMap = map;

    },


    getViewText: function (data) {
        if (data == null) return "";
        var s = this.m_ds.getDataAdapter().getFormatedTextValue(data, this.m_DataType, this.Scale);


        if (this.m_Data2ViewMap == null)
        {
            if (data == null) return "";
            return s;
        }

        return m_Data2ViewMap[ObjectTool.changeType(data, UniformDataType.$String)];


    },


    getFillBack: function () {

        return this.m_FillBack;
    },


    setFillBack: function (dbcol) {
        this.m_FillBack = dbcol;

    },


    isIncludeUnsureFunction: function () {
        return this.m_IncludeUnsureFunction;
    },


    setIncludeUnsureFunction: function (includeUnsureFunction) {
        this.m_IncludeUnsureFunction = includeUnsureFunction;
    },


    getColumnClassName: function () {
        return this.m_ColumnClassName;
    },


    getDBTypeAndPrecision: function () {

        var /*DataAdapter*/   da = this.m_ds.getDataAdapter();
        try
        {
            return da.assembleColumnType(this.getDataTypeName(), this.getPrecision(), this.getScale(), this.getColumnTypeRedefine());
        } catch (e)
        {
            return e;
        }


    },


    getColumnTypeRedefine: function () {

        return this.m_typeRedefine;
    },


    setColumnTypeRedefine: function (type) {
        this.m_typeRedefine = type;

    },


    getDatabaseName: function () {
        return this.m_DatabaseName;
    },


    setFormat: function (format) {
        this.m_format = format;

    },


    getFormat: function () {

        return this.m_format;
    }


});



export default ColumnProperty;
