/**
 * Created by zengjun 事件接口定义
 */


import Class from '../../base/Class.js';

var WorkBookListener = Class.extend({

        constructor: function () {
            this.$uper.constructor();

        },

        // 事件列表：

        nameChanged: function (sheet, /*String*/ oldName, /*String*/ newName) {},
        // 单元格的值将发生改变，接不接受改变
        /*boolean*/
        cellValueChangeAccept: function (sheet, /*Cell*/ cell, /*Object*/ oldValue, /*Object*/ newValue, innerRow) {},
        cellValueChanged: function (sheet, /*Cell*/ cell, /*Object*/ oldValue, /*Object*/ newValue, /*int*/ innerRow) {},

        cellValueChangedByEdit: function (sheet, /*Cell*/ cell, /*Object*/ newValue, /*int*/ innerRow) {},

        /**
         * 在编辑结束后，但是把数据回填到单元格之前
         * @param sheet
         * @param cell
         * @param value
         * @param innerRow
         * @return  返回需要回填到单元格的数据，如果不能数据做处理，可以直接返回参数 value
         */
        /*Object*/
        afterEditFocusLostAndBeforeWriteBackToCell: function (sheet, /*Cell*/ cell, /*Object*/ value, /*int*/ innerRow) {},


        //焦点变化
        cellFocusGained: function (sheet, /*int*/ row, /*int*/ col) {},
        cellFocusLost: function (sheet, /*int*/ row, /*int*/ col) {},
        cellClicked: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},
        cellDblClicked: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},
        cellRightClicked: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},


        keyPressed: function (sheet, /*KeyEvent*/  e, /*int*/ editingRow, /*int*/ editingCol, /*int*/ dbRow) {},
        keyReleased: function (sheet, /*KeyEvent*/  e, /*int*/ editingRow, /*int*/ editingCol, /*int*/ dbRow) {},
        beginEdit: function (sheet, /*int*/ row, /*int*/ col, /*int*/ dbRow) {},
        endEdit: function (sheet, /*int*/ row, /*int*/ col, /*int*/ dbRow, /*boolean*/ enterKeyPressed,
                           /*boolean*/ isShiftDown, /*boolean*/ isControlDown) {},


        //单元格需要重新计算
        cellNeedRecalculate: function (sheet, /*Cell*/ cell) {},

        // 单元格的属性发生改变
        cellPropertyChanged: function (sheet, /*Cell*/ cell, /*String*/ propertyName,
                                       /*Object*/ oldPropertyValue, /*Object*/ newPropertyValue) {},
        error: function (/*String*/ errorInfo) {},
        // 新建一个Sheet
        afterNew: function (sheet) {},
        //Sheet允许删除吗
        /*boolean*/
        deletePermit: function (sheet) {},

        /*boolean*/
        isCellEditable: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},

        buttonOnClick: function (sheet, /*Cell*/ cell, /*String*/ button) {},

        /**
         * 调取打印设置
         * @param sheet
         */
        loadPrintConfig: function (sheet) {return "";},
        /**
         * 打印设置保存
         * @param sheet
         */
        savePrintConfig: function (sheet, printConfig) {},

        /*boolean*/
        canPrint: function (sheet) {},

        afterPrint: function (sheet) {},

        //系统级的比如显示Select，复制绑定信息等菜单是否允许显示
        isSysContextMenuEnable: function (sheet) {return true},

        /**
         * 对图表的数据做修饰
         * @param sheet
         * @param chart
         * @param data
         */
        chartDataDecorate: function (sheet, /*Chart*/  chart, /*ArrayList*/  data) {},

        getDropDownDataForEdit: function (editStyle, cell, innerRow) {},

        refreshEditStyleOf/*Cell*/: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},

        editFocusChanged: function (sheet, /*int*/ lastRow, /*int*/ lastCol, /*int*/ newRow, /*int*/ newCol) {},

        sheetActiveStateChanged: function (activeSheet, deActiveSheet) {},

        onMouseMove: function (/*View*/  pView, /*Cell*/ cell, /*MouseEvent*/  evt) {},

        onContextMenuClicked: function (sheet, /*Cell*/ cell, /*int*/ innerRow, /*String*/ menuName) {},

        currentBindRowChanged: function (/*String*/ dsname, /*int*/ row) {},

        /*String*/
        buildToolTip: function (sheet, /*Cell*/ cell, /*int*/ innerRow) {},

        popupedOnOK: function (sheet) {},
        popupedOnCancel: function (sheet) {},

        onDragDrop: function (/*String*/ type, /*String*/ data, sheet, /*Cell*/ cell) {},

        /**
         *
         * @param treeName 树的名称
         * @param group　数据分类
         * @param text 树节点的文本
         * @param data 树节点的数据　
         */
        onTreeSelectionChanged: function (/*String*/  treeName, /*String*/ group, /*String*/ text, /*String*/ data) {},

        /**
         *
         * @param sheet
         * @param dir   卷滚条方向    1 垂直  0 水平
         */

        onScroll: function (sheet, /*int*/ dir) {},

        /*boolean*/
        isBalloonTipEditPermit: function (/*String*/ dsname, /*String*/ dbcol, /*int*/ innerRow) {},


        ColumnWidthChanged: function (sheet, /*int*/ col, /*int*/ oldWidth, /*int*/ newWidth) {},
        RowHeightChanged: function (sheet, /*int*/ row, /*int*/ oldHeight, /*int*/ newHeight) {},

        // 2020.03.29 增加对移动设备上划屏至顶端或底部时的事件支持
        /**
         * 划屏到顶部时的提示内容
         * @param sheet
         */
        loadMoreTipInfoWhenScrollToTop: function (sheet) {},

        /**
         * 划屏到顶部并松开手后触发的事件
         * @param sheet
         */
        loadMoreWhenScrollToTop: function (sheet) {},
        /**
         * 划屏到底部时的提示内容
         * @param sheet
         */
        loadMoreTipInfoWhenScrollToBottom: function (sheet) {},
        /**
         * 划屏到底部并松开手后触发的事件
         * @param sheet
         */
        loadMoreWhenScrollToBottom: function (sheet) {},

        /**
         *  ckeditor5上传文件前，可以在本事件中往表单对象中再注入一些数据
         * @param formData  FormData类型
         */
        buildCKEditorUploadParam: function (formData) {},

        /**
         * CKEditor5 文件上传完成事件ÒÒ
         * @param response
         */
        afterCKEditorUploadFile: function (response) {}

    }
);


export default WorkBookListener;
