/**
 * Created by zengjun on 2017/4/26.
 */


import Class from '../base/Class.js';

var Row = Class.extend(
    {

        properties:
            {
                "rowIndex":
                    {
                        get: function () { return this.getRowIndex();}
                    }
            },

        /**
         * 构建函数，
         * @param sheet
         * @param colCount  列数
         */
        constructor: function (sheet, colCount) {
            this.cells = [];
            this.Sheet = sheet;
            for (var i = 0; i < colCount; i++)
            {
                this.cells.push(null);
            }

        },

        /**
         * 请 // 确保该Cell是合法的
         * @param col
         * @returns {*}
         */
        getCell: function (col) {
            return this.Sheet.cells(this.getRowIndex(), col);
        },

        /**
         *  快速返回第col个单元格，不管它是否为null
         * @param col
         * @returns {*}
         */
        $getCell: function (col) {
            return this.cells[col];
        },

        $setCell: function (column, cell) {
            if (column < 0) return;
            if (column >= this.getCellCount()) return;
            this.cells[column] = cell;
        },


        getCellCount: function () {

            return this.cells.length;
        },


        getRowIndex: function () {
            return this.Sheet.SheetRows.indexOf(this);
        },

        /**
         *
         * @param col 列号
         * @param append  ：boolean 是否是在最后追加
         */
        $insertBefore: function (col, append) {
            if (append)
            {
                this.cells.push(null);
            }
            else
            {
                this.cells.splice(col, 0, null); //在col位置处插入一个元素

            }
        },


        // 出于性能考虑，由调用者保证col的合法性

        $delete: function (col) {
            this.cells.splice(col, 1); //删除col位置的一个元素
        }

    }
);

export default Row ;
