/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';


var Range = Class.extend({

    constructor: function (startrow, startcol, endrow, endcol) {
        endrow = endrow || startrow;
        endcol = endcol || startcol;   //可能只有两个参数，
        this.startRow = Math.min(startrow, endrow);
        this.startCol = Math.min(startcol, endcol);
        this.endRow = Math.max(startrow, endrow);
        this.endCol = Math.max(startcol, endcol);


    },

    clone: function () {
        var ret = new Range(this.startRow, this.startCol, this.endRow, this.endCol);
        return ret;
    },

    equals: function (r) {

        if (r == null) return false;
        if (r == this) return true;

        return (  this.startRow == r.startRow && this.startCol == r.startCol &&
            this.endRow == r.endRow && this.endCol == r.endCol  );
    },

    toString: function () {
        return "startrow:" + this.startRow + "   startcol: " + this.startCol + "    endrow: " +
            this.endRow + "  endCol:" + this.endCol;
    },

    contains: function (row, col) {
        if (row >= this.startRow && row <= this.endRow && col >= this.startCol && col <= this.endCol) return true;
        return false;
    }

});

export default Range;
