/**
 * 分页配置
 */


import Class from '../base/Class.js';

var  PrintRange = Class.extend({

    /**
     *
     * @param startrow  是一个PageSplitInfo对象，不是一个简单值
     * @param startcol  是一个PageSplitInfo对象，不是一个简单值
     * @param endrow
     * @param endcol
     */
    constructor: function (/*PageSplitInfo*/startrow, /*PageSplitInfo*/ startcol, endrow, endcol) {


        this.startRow = Math.min(startrow.index, endrow);
        this.rowOffset = startrow.offset;
        this.rowBlank = startrow.blank;

        this.startCol = Math.min(startcol.index, endcol);
        this.colOffset = startcol.offset;
        this.colBlank = startcol.blank;


        this.endRow = Math.max(startrow.index, endrow);
        this.endCol = Math.max(startcol.index, endcol);


    }

});

export default PrintRange ;
