/**
 * Created by 三宝爹 on 2017/10/9.
 *
 * 在 WorkSheetView 中，所有关于尺寸计算相关的函数都归集在此，本类仅做为WorkSheetView 的功能函数包存在
 *
 */


import Rectangle from '../../gdi/Rectangle.js';
import Point from '../../gdi/Point.js';
import Util from '../../util/Util.js';

var ISize = {


// 得到某行某列的左上角的坐标

    getLeftTopOfCell: function (isPrint, row, col) {
        var x = (isPrint ? 0 : this.Sheet.RPM.getRowHeadWidth()) + this.Sheet.CPM.getColumnX(col);
        if (col >= this.Sheet.CPM.getFixedColumnCount())
        {
            //对整行列坐标不卷滚的支持
            x -= (isPrint ? this.Sheet.xPrintOffset : (this.Sheet.RPM.isColumnScrollEnabled(row) ? this.Sheet.xOffset : 0));
        }

        var y = (isPrint ? 0 : this.Sheet.CPM.getColumnHeadHeight()) + this.Sheet.RPM.getRowY(row);
        if (row >= this.Sheet.RPM.getFixedRowCount()) y -= (isPrint ? this.Sheet.yPrintOffset : this.Sheet.yOffset );

        //2019.12.17 支持打印忽略
        if (isPrint)
        {
            if (this.Sheet.ignoreBeforeRowWhenPrinting > 0)
            {
                y -= this.Sheet.RPM.getRowY(this.Sheet.ignoreBeforeRowWhenPrinting);
            }
        }
        return new Point(x, y);

    },


    /**
     *  得到单元格所占的区域，不考虑合并
     * @param isPrint
     * @param row
     * @param col
     * @returns {Rectangle}
     */
    getRectangleOfCell: function (isPrint, row, col) {
        var /*Point*/  p = this.getLeftTopOfCell(isPrint, row, col);
        return new Rectangle(p.x, p.y, this.Sheet.CPM.getColumnWidth(col), this.Sheet.RPM.getRowHeight(row));
    },


    /**
     * 得到显示该单元格所需要的区域，考虑合并情况
     * @param isPrint
     * @param row
     * @param col
     * @returns {Rectangle}
     */
    getShowRectangleOfCell: function (isPrint, row, col) {
        var /*Cell*/  cell = this.Sheet.$cells(row, col);
        // 如果是被合并的单元格，那么仅最左上角的单元格
        if (cell != null && cell.isMerged())
        {

            var /*Range*/  r = this.Sheet.getMergeMap().get(cell).getMergedRange();
            return this.getRectangleOfRange(isPrint, r);

        } else
        {
            return this.getRectangleOfCell(isPrint, row, col);
        }
    },


    /**
     * 得到指定坐标所占据的矩形
     * @param isPrint
     * @param range
     * @return
     */
    /*Rectangle*/
    getRectangleOfRange: function (isPrint, /*Range*/range) {
        var /*Range*/  r = range;

        var startRow = Math.max(0, r.startRow);
        var startCol = Math.max(0, r.startCol);

        var endRow = Math.min(this.Sheet.RPM.rowCount - 1, r.endRow);
        var endCol = Math.min(this.Sheet.CPM.columnCount - 1, r.endCol);

        var /*Point*/lt = this.getLeftTopOfCell(isPrint, startRow, startCol);
        var /*Point*/rb = this.getLeftTopOfCell(isPrint, endRow, endCol);
        rb.x += this.Sheet.CPM.getColumnWidth(endCol);
        rb.y += this.Sheet.RPM.getRowHeight(endRow);

        var w = rb.x - lt.x;
        var h = rb.y - lt.y;

        if (w < 0) // 仅当(startRow,startCol)位于固定区，(endRow,endCol)位于可滚动区时，才会出现这种情况
        {
            w = this.getFixedPointX() - lt.x;
        }


        // 原来是 h<=0 改成h<0
        //当行高度为0时，此时h=0 ,如果让h = getFixedPointY() - lt.y;那么本来不可见的行变成了在整个固定行高之间进行draw了

        if (h < 0) // 仅当(startRow,startCol)位于固定区，(endRow,endCol)位于可滚动区时，才会出现这种情况
        {
            h = this.getFixedPointY() - lt.y;
        }

        return new Rectangle(lt.x, lt.y, Math.max(0, w), Math.max(0, h));

    },


    /**
     * 得到选中区的左上角单元格的左上角坐标
     * @returns {Point}
     */
    getLeftTopPointOfSelection: function () {
        var r = this.Sheet.getSelection();
        var lt = this.getLeftTopOfCell(false, r.startRow, r.startCol);
        return lt;
    },


    /**
     * 得到选中区的右下角单元格的右下角坐标
     * 实际绘制时不一定使用这个坐标。比如当左上角位于固定区，而右下角位于滚动区时，且
     *  右下角被滚动到不可见时，这时选中区的右下角坐标应该是冻结点的坐标
     * @returns {Point}
     */
    getRightBottomPointOfSelection: function () {
        var /*Range*/  r = this.Sheet.getSelection();
        var rb = this.getLeftTopOfCell(false, r.endRow, r.endCol);
        rb.x += this.Sheet.CPM.getColumnWidth(r.endCol);
        rb.y += this.Sheet.RPM.getRowHeight(r.endRow);
        return rb;
    },

    /**
     * 得到当前选中范围所占的矩形区域
     *
     * @return
     */
    /*Rectangle*/
    getRectangleOfSelection: function () {


        var /*Range*/  sel = this.Sheet.getSelection();
        if (sel == null)
        {
            console.error("异常：getRectangleOfSelection中 selection=null");
            sel = new Range(1, 1, 1, 1);
        }

        return this.getRectangleOfRange(false, sel);

    },

    /**
     * 得到指定坐标所占据的矩形
     * @param isPrint
     * @param range
     * @return
     */
    /*Rectangle*/
    getRectangleOfRange: function (isPrint, range) {
        var /*Range*/  r = range;

        var startRow = Math.max(0, r.startRow);
        var startCol = Math.max(0, r.startCol);

        var endRow = Math.min(this.Sheet.RPM.rowCount - 1, r.endRow);
        var endCol = Math.min(this.Sheet.CPM.columnCount - 1, r.endCol);

        var /*Point*/ lt = this.getLeftTopOfCell(isPrint, startRow, startCol);
        var /*Point*/ rb = this.getLeftTopOfCell(isPrint, endRow, endCol);
        rb.x += this.Sheet.CPM.getColumnWidth(endCol);
        rb.y += this.Sheet.RPM.getRowHeight(endRow);

        var w = rb.x - lt.x;
        var h = rb.y - lt.y;

        if (w < 0) // 仅当(startRow,startCol)位于固定区，(endRow,endCol)位于可滚动区时，才会出现这种情况
        {
            w = this.getFixedPointX() - lt.x;
        }


        // 原来是 h<=0 改成h<0
        //当行高度为0时，此时h=0 ,如果让h = getFixedPointY() - lt.y;那么本来不可见的行变成了在整个固定行高之间进行draw了

        if (h < 0) // 仅当(startRow,startCol)位于固定区，(endRow,endCol)位于可滚动区时，才会出现这种情况
        {
            h = this.getFixedPointY() - lt.y;
        }

        return new Rectangle(lt.x, lt.y, Math.max(0, w), Math.max(0, h));

    },


    /**
     * 得到冻结点的坐标
     * @returns {Point}
     */
    getFixedPoint: function () {
        return new Point(this.getFixedPointX(), this.getFixedPointY());
    },


    /**
     * 得到冻结点的x坐标
     * @returns {*}
     */
    getFixedPointX: function () {
        return this.Sheet.RPM.getRowHeadWidth() + this.Sheet.CPM.getFixedColumnWidth();
    },


    /**
     * 得到冻结点的Y坐标
     * @returns {*}
     */
    getFixedPointY: function () {
        return this.Sheet.CPM.getColumnHeadHeight() + this.Sheet.RPM.getFixedRowHeight();
    },

    // 判断是不是在列头上
    isOnColumnHeader: function (point) {
        var rc = new Rectangle();
        rc.x = this.RPM.getRowHeadWidth();
        rc.width = this.getWidth() - rc.x;
        rc.y = 0;
        rc.height = this.CPM.getColumnHeadHeight();
        return rc.contains(point);
    },


    // 判断是不是在行头上
    isOnRowHeader: function (point) {

        var rc = new Rectangle();
        rc.x = 0;
        rc.y = this.CPM.getColumnHeadHeight();
        rc.width = this.RPM.getRowHeadWidth();
        rc.height = this.getHeight() - rc.y;
        return rc.contains(point);
    }
    ,


    /**
     * 得到当前选中范围所占的裁剪区
     *
     * @return {Rectangle}
     */
    getClipRectangleOfRange: function (range) {
        var r = range;
        var ret = this.getBounds();

        // 因为选中区域标志外框是以３个点宽进行绘制的，所以需要多给一个点
        if (r.startRow >= this.RPM.getFixedRowCount()) ret.y = this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight() - 1;
        if (r.startCol >= this.CPM.getFixedColumnCount()) ret.x = this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth() - 1;
        ret.height -= ret.y;
        ret.width -= ret.x;

        ret.height = Math.max(0, ret.height);
        ret.width = Math.max(0, ret.width);
        return ret;

    },


    /**
     *
     * @param point
     * @param {Rectangle }rect 它将在函数中被修改，然后带到函数外使用 TODO  建议改掉
     * @returns {*}
     * @constructor
     */
    GetColumnHeadRect: function (point, /*Rectangle*/ rect) {
        var /*Rectangle*/rc = new Rectangle();
        rc.x = this.RPM.getRowHeadWidth();
        rc.width = this.getWidth() - rc.x;
        rc.y = 0;
        rc.height = this.CPM.getColumnHeadHeight();
        // 如果点不在列头部，那么直接返回
        // 修改，不仅仅是在头部可以做resize ,
        //	if (!rc.contains(point)) return -1;

        var col = this.GetColAtPoint(false, point.x);

        rect.width = this.CPM.getColumnWidth(col);
        rect.y = 0;
        rect.height = rc.height;

        rect.x = this.RPM.getRowHeadWidth() + this.CPM.getColumnX(col);
        if (col >= this.CPM.getFixedColumnCount()) rect.x -= this.Sheet.xOffset;

        return col;
    },


    GetRowHeadRect: function (point, /*Rectangle*/ rect) {
        var /*Rectangle*/  rc = new Rectangle();
        rc.x = 0;
        rc.width = this.RPM.getRowHeadWidth();
        rc.y = this.CPM.getColumnHeadHeight();
        rc.height = this.getHeight() - rc.y;
        // 如果点不在行头部，那么直接返回
        // 修改，不仅仅是在头部可以做resize ,
        //if (!rc.contains(point)) return -1;

        var row = this.GetRowAtPoint(false, point.y);
        if (Util.isObject(row)) row = row.row;

        rect.width = rc.width;
        rect.x = 0;
        rect.height = this.RPM.getRowHeight(row);

        rect.y = this.CPM.getColumnHeadHeight() + this.RPM.getRowY(row);
        if (row >= this.RPM.getFixedRowCount()) rect.y -= this.Sheet.yOffset;

        return row;
    },

    /**
     *
     * @returns {*|jQuery}
     */
    getWidth: function () {
        return $(this.canvas).width();
    }
    ,

    /**
     *
     * @returns {*|jQuery}
     */
    getHeight: function () {
        return $(this.canvas).height();
    }
    ,

    /**
     *
     * @returns {Rectangle}
     */
    getBounds: function () {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }


};

export default ISize;
