/**
 * Created by 三宝爹 on 2017/10/26.
 */


import Rectangle from '../../gdi/Rectangle.js';
import Point from '../../gdi/Point.js';


var IResize = {

    /**
     * 是否包含有弹性宽度的列
     * @returns {boolean}
     */

    includeStretchColumn: function () {
        var CN = this.Sheet.columnCount;
        var CPM = this.Sheet.CPM;

        for (var i = 0; i < CN; i++)
        {
            var t = CPM.getColumnStretchWidth(i);
            if (t > 0) return true;
        }
        return false;
    },

    /**
     * 是否包含有弹性行高的行
     * @returns {boolean}
     */
    includeStretchRow: function () {
        var RN = this.Sheet.rowCount;
        var RPM = this.Sheet.RPM;

        for (var i = 0; i < RN; i++)
        {
            var t = RPM.getRowStretchHeight(i);
            if (t > 0) return true;
        }
        return false;
    },

    /**
     * 重新按弹性占比计算各个弹性列的宽度
     */
    reCalcuColumnsWidth: function () {
        //设计状态就不要计算了，不方便设计
        if (this.Sheet.designMode) return;



        var rc = this.getBounds();
        if (rc.width <= 0 || rc.height == 0) return;
        var totalWidth = rc.width - this.Sheet.RPM.getRowHeadWidth();

        //再计算所有非弹性行的高度
        var noStretchWidth = 0;
        var totalStretchPercent = 0;
        var CN = this.Sheet.columnCount;
        var CPM = this.Sheet.CPM;

        var stretchColumnIndex = [];
        for (var i = 0; i < CN; i++)
        {
            var t = CPM.getColumnStretchWidth(i);
            var width = CPM.getColumnWidth(i);
            if (t > 0)
            {
                totalStretchPercent += t;

                stretchColumnIndex.push(i);
            } else
            {
                noStretchWidth += width;
            }

        }

        if (stretchColumnIndex.length == 0) return;
        if (totalWidth <= noStretchWidth) return;

        let repaintPermit = this.Sheet.paintPermint;
        this.Sheet.paintPermint = false;

        var stretchColumnCount = stretchColumnIndex.length;

        var totalLeftWidth = totalWidth - noStretchWidth;
        var leftWidth = totalLeftWidth;
        for (var i = 0; i < stretchColumnCount; i++)
        {
            let col = stretchColumnIndex[i];
            if (i == stretchColumnCount - 1) //如果是最后一个可伸缩列
            {

                CPM.setColumnWidth(col, leftWidth, false);
            } else
            {
                var t = CPM.getColumnStretchWidth(col);
                var thisWidth = Math.floor(totalLeftWidth * t * 1.0 / totalStretchPercent);
                leftWidth -= thisWidth;
                CPM.setColumnWidth(col, thisWidth, false);
            }
        }
        this.Sheet.paintPermint = repaintPermit;


    },

    /**
     * 重新计算各个弹性行高
     *
     * 对别注意：绑定到多行数据源的行，禁止设置成弹性高度
     */
    reCalcuRowsHeight: function () {
        //设计状态就不要计算了，不方便设计
        if (this.Sheet.designMode) return;

        var rc = this.getBounds();
        if (rc.width <= 0 || rc.height == 0) return;
        var totalHeight = rc.height - this.Sheet.CPM.getColumnHeadHeight();

        //再计算所有非弹性行的高度
        var noStretchHeight = 0;
        var totalStretchPercent = 0;
        var RN = this.Sheet.rowCount;
        var RPM = this.Sheet.RPM;

        var stretchRowIndex = [];
        for (var i = 0; i < RN; i++)
        {
            var t = RPM.getRowStretchHeight(i);
            var Height = RPM.getRowHeight(i);
            if (t > 0)
            {
                totalStretchPercent += t;

                stretchRowIndex.push(i);
            } else
            {
                noStretchHeight += Height;
            }

        }

        if (stretchRowIndex.length == 0) return;

        if (totalHeight <= noStretchHeight) return;

        let repaintPermit = this.Sheet.paintPermint;
        this.Sheet.paintPermint = false;

        var stretchRowCount = stretchRowIndex.length;

        var totalLeftHeight = totalHeight - noStretchHeight;
        var leftHeight = totalLeftHeight;
        for (var i = 0; i < stretchRowCount; i++)
        {
            let row = stretchRowIndex[i];
            if (i == stretchRowCount - 1) //如果是最后一个可伸缩行
            {
                RPM.setRowHeight(row, leftHeight);
            } else
            {
                var t = RPM.getRowStretchHeight(row);
                var thisHeight = Math.floor(totalLeftHeight * t * 1.0 / totalStretchPercent);
                leftHeight -= thisHeight;
                RPM.setRowHeight(row, thisHeight);
            }
        }

        this.Sheet.paintPermint = repaintPermit;
        ;

    }
};

export default IResize;
