/**
 * Created by 三宝爹
 *
 * 2017/10/13 初稿
 *
 * 2020.04.06 增加对移动设备的支持，当单元格进入编辑状态时，确保单元格在屏幕的上半屏，因为无法预估输入法面板占据的高度
 * 但基本上不可能超过半屏
 *
 */


import Rectangle from '../../gdi/Rectangle.js';
import Range from '../Range.js';
import DataSourceConfig from '../DataSourceConfig.js';

import Point from '../../gdi/Point.js';
import ColumnPropertyManage from '../ColumnPropertyManage.js';
import RowPropertyManage from '../RowPropertyManage.js';
import WorkBookView from '../WorkBookView.js';
import Tools from '../../util/Tools.js'


var IFocus = {

    /**
     * 强制当前编辑框放弃焦点
     *
     */
    forceCurrentEditControlGiveUpFocus: function () {

        //强制当前编辑框放弃焦点
        var /*Edit*/edit = this.$getCurrentEditingEdit();
        if (edit && edit.ES)
        {
            if (edit.ES.focusNeedToListen) edit.giveUpFocus();
        }
        this.$clearCurrentEditingEdit(edit);

        this.requestFocusInWindow();

    },


    forceCurrentEditControlFillBack: function () {

        var edit = this.$getCurrentEditingEdit();
        if (edit != null)
        {
            edit.fillBack();
        }

    },

    requestFocusInWindow: function () {
        //TODO 可能不需要此函数了
        this.canvas.focus();
    },


    /**
     * 判断 row行col列中 innerRect这个矩形区域是不是完全在可见区域
     * @param row
     * @param col
     * @param innerRect
     */
    isOnScreen: function (row, col, innerRect) {
        //得到单元格占据的区域（考虑了合并单元格的情况）
        var rc = this.getShowRectangleOfCell(false, row, col);

        //再计算相对区域的绝对坐标
        rc.x = rc.x + innerRect.x;
        rc.y = rc.y + innerRect.y;
        rc.width = innerRect.with;
        rc.height = innerRect.height;

        //再看看 rc 是不是在可视区域内
        var bounds = this.getBounds();
        //减去列头行头
        bounds.x = this.Sheet.RPM.getRowHeadWidth();
        bounds.y = this.Sheet.CPM.getColumnHeadHeight();

        //尺寸再减去卷滚条的尺寸
        bounds.width = bounds.width - (bounds.x + WorkBookView.scrollBarSize);
        bounds.height = bounds.height - (bounds.y + WorkBookView.scrollBarSize);

        if (rc.x >= bounds.x && rc.y >= bounds.y
            && rc.x + rc.width <= bounds.x + bounds.width
            && rc.y + rc.height <= bounds.y + bounds.height)
        {
            return true;
        }

        return false;

    },


    /**
     *
     确保选中区域在屏幕上
     当某个单元格是绑定到multiRow Data 上时，就不需要了。因为可以这个Cell比一屏还要高
     为什么需要一个mousePoint参数呢: 当 mousePoint==null 时表示是通过脚本或者按键
     操作后， 需要让选中区域置于可视区中
     当  mousePoint!=null 时表示是通过鼠标点击，需要让选中区域置于可视区中
     所以当是前者情况时，如果单元格绑定到多行数据源时，需要让currentBindRow 在可视区中
     对于后者，需要让鼠标所点中的内部行在可视区就行了。
     而对于不是绑定到多行数据源的Cell，先让它的上部分处理于可视区，再调整让它的下边处于视区中
     * @param mousePointPoint
     * @param half  是不是在半屏之上
     */
    insureSelectionOnScreen: function (mousePoint , half) {


        if( half==undefined) half=false;

        var r = this.Sheet.selection;
        var rc = this.getRectangleOfRange(false, r);
        // 看行有没有被挡住
        var row = r.startRow;
        var col = r.startCol;
        // 当行在固定行区域时，行肯定是可见的。
        // 如果行号是在可滚动区，
        if (row >= this.RPM.getFixedRowCount())
        {

            var /*boolean*/ innerRowInsured = false;

            var /*Cell*/ cell = this.Sheet.$cells(row, col);

            if (cell != null)
            {
                var /*DBBindConfig*/ bind = cell.Bind;

                var mouseOnDBRow = -1;
                var currentDBRow = -1;

                var /*boolean*/  isBindToMultiRowDataSource = false;
                if (bind != null)
                {


                    //2019.06.25取消了限制
                    if (bind.dataSourceType == DataSourceConfig.MultiRowDataSource || true)
                    {
                        var oneDataRowHeight = this.Sheet.RPM.getOneDataRowHeightOfDataSource(bind.dataSource);

                        var dsc = this.Sheet.Book.getDataSource(bind.dataSource);
                        var dbRow;
                        var rect = this.getShowRectangleOfCell(false, row, col);

                        if (mousePoint != null)
                        {

                            dbRow = Math.floor((mousePoint.y - rc.y) / oneDataRowHeight);
                            dbRow = Math.max(0, dbRow);
                            dbRow = Math.min(dbRow, dsc.dataStore.rowCount - 1);
                        } else
                        {
                            dbRow = dsc.currentBindRow;
                        }


                        var innerRowY = rect.y + dbRow * oneDataRowHeight;
                        // 注意顺序不能弄反了。这样确保了区域的尾部份肯定是可见的
                        var innerDelta = innerRowY - (this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight());
                        //顶边不可见了，那么往下移一点
                        if (innerDelta < 0)
                        {
                            this.Sheet.setYOffset(this.Sheet.getYOffset() + innerDelta - 10);
                            if (mousePoint != null) mousePoint.y -= innerDelta - 10; // 为什么要这么做，参看*0815
                        }


                        //因为作了滚动，所以要重新得到Cel(row,col)的矩形
                        rect = this.getShowRectangleOfCell(false, row, col);
                        var innerRowY2 = rect.y + (dbRow - this.RPM.getRowScrolledRowCount(row)) * oneDataRowHeight;
                        //加上高度就是下边界
                        innerRowY2 += oneDataRowHeight;

                        var innerDelta2 = innerRowY2 - this.getHeight() /(  half?2:1);//手机上，确保编辑单元格在屏幕上半部
                        if (innerDelta2 >= 0)
                        {
                            this.Sheet.setYOffset(this.Sheet.getYOffset() + innerDelta2 + 10); // 留 10个点的底边距
                            // 下面这一步很重要。因为屏幕向上作了卷滚，所以
                            // 要编辑的行的位置也向上滚了，这里，可以理解，鼠标点击的那个点也应该是向上卷滚了
                            // 如果不做这一步，可能的结果就是编辑焦点到了真正需要编辑的下一行上了。
                            if (mousePoint != null) mousePoint.y -= innerDelta2; //  *0815
                        }

                        innerRowInsured = true;

                    }

                }


                //==============


            }

            if (!innerRowInsured)
            {

                // 注意顺序不能弄反了。这样确保了区域的尾部份肯定是可见的
                var delta = rc.y - (this.CPM.getColumnHeadHeight() + this.RPM.getFixedRowHeight());
                //之所以+16 是因为卷滚条可能遮挡了最下面的一行，
                if (delta < 0) this.Sheet.setYOffset(this.Sheet.getYOffset() + delta + 16);

                // 因为作了滚动，所以要重新得到选中区域的矩形
                rc = this.getRectangleOfRange(false, r);
                var delta2 = rc.y + rc.height - this.getBounds().height /( half?2:1);//手机上，确保编辑单元格在屏幕上半部
                if (delta2 >= 0) this.Sheet.setYOffset(this.Sheet.getYOffset() + delta2 + 16);
            }

        }

        // 因为作了滚动，所以要重新得到选中区域的矩形
        rc = this.getRectangleOfRange(false, r);

        // 当行在固定行区域时，行肯定是可见的。
        // 如果行号是在可滚动区，
        if (col >= this.CPM.getFixedColumnCount())
        {
            // 注意顺序不能弄反了。这样确保了区域的尾部份肯定是可见的
            var delta = rc.x - (this.RPM.getRowHeadWidth() + this.CPM.getFixedColumnWidth());
            if (delta < 0) this.Sheet.setXOffset(this.Sheet.getXOffset() + delta);

            // 因为作了滚动，所以要重新得到选中区域的矩形
            rc = this.getRectangleOfRange(false, r);

            delta = rc.x + rc.width - this.getBounds().width;
            if (delta >= 0) this.Sheet.setXOffset(this.Sheet.getXOffset() + delta + 16); //

        }

    }


};

export default IFocus ;
