/**
 * Created by 三宝爹 on 2017/7/9.
 *
 * worksheet中编辑焦点区域有关的操作
 */


import Range from '../Range.js';

var ISheetFocusRange = {
    /**
     * 清除焦点区域设置
     */

    clearFocusRange: function () {
        this.focusRange = [];
        this.currentFocusRangeIndex = 0;
    },

    /**
     * 增加一个焦点分区
     * @param startRow
     * @param startCol
     * @param endRow
     * @param endCol
     */
    addFocusRange: function (startRow, startCol, endRow, endCol) {
        // 这里并不做合法性检测。因为即使做了检测，在insertRow, deleteRow 等操作后，它可能又不合法了，
        // 所以在使用它时再做检测
        var r = new Range(startRow, startCol, endRow, endCol);
        this.focusRange.push(r);

    },

    /**
     * 移除
     * @param startRow
     * @param startCol
     * @param endRow
     * @param endCol
     * @returns {boolean}
     */
    removeFocusRange: function (startRow, startCol, endRow, endCol) {
        // 这里并不做合法性检测。因为即使做了检测，在insertRow, deleteRow 等操作后，它可能又不合法了，
        // 所以在使用它时再做检测

        for (var i = 0; i < this.focusRange.length; i++)
        {
            var r = this.focusRange[i];
            if (r.startRow == startRow && r.startCol == startCol && r.endRow == endRow && r.endCol == endCol)
            {
                this.focusRange.removeAt(i);
                return true;
            }
        }

        return false;

    },

    /**
     * 重置焦点分区的序号
     * @param startRow
     * @param startCol
     * @param endRow
     * @param endCol
     * @param no
     */
    setFocusRangeNo: function (startRow, startCol, endRow, endCol, no) {
        // 这里并不做合法性检测。因为即使做了检测，在insertRow, deleteRow 等操作后，它可能又不合法了，
        // 所以在使用它时再做检测

        if (no < 0) return;
        if (no >= this.focusRange.length) return;

        for (var i = 0; i < this.focusRange.length; i++)
        {

            var /*Range*/        r = this.focusRange[i];
            if (r.StartRow == startRow && r.StartCol == startCol && r.EndRow == endRow && r.EndCol == endCol)
            {
                this.focusRange.removeAt(i);
                this.focusRange.splice(no, 0, r);
            }
        }

    },

    getFocusRangeList: function () {
        return this.focusRange;
    },
    /**
     * 得到当前焦点分区
     * @returns {*}
     */
    getCurrentFocusRange: function () {
        var n = this.focusRange.length;
        if (n == 0) return new Range(0, 0, this.rowCount - 1, this.columnCount - 1);
        if (this.currentFocusRangeIndex < 0 || this.currentFocusRangeIndex >= n) this.currentFocusRangeIndex = 0;
        return this.focusRange[this.currentFocusRangeIndex];
    },

    /**
     * 移到下一个焦点分区
     */
    moveToNextFocusRange: function () {
        this.currentFocusRangeIndex++;
        if (this.currentFocusRangeIndex == this.focusRange.length) this.currentFocusRangeIndex = 0;
    },

    /**
     * 移到第一个焦点分区
     */
    moveToPriorFocusRange: function () {
        this.currentFocusRangeIndex--;
        if (this.currentFocusRangeIndex < 0) this.currentFocusRangeIndex = this.focusRange.length - 1;

    },

    /**
     * 当某个单元格处于编辑状态时，需要把当前焦点区切换到合适的位置
     */
    moveToFocusRange: function (row, col) {
        var n = this.focusRange.length;
        if (n == 0) return;

        for (var i = 0; i < n; i++)
        {
            var /*Range*/        r = this.focusRange[i];
            if (r.contains(row, col))
            {
                this.currentFocusRangeIndex = i;
                return;
            }
        }

    },

    /**
     * 当前是否在最后一个焦点分区内
     * @returns {boolean}
     */
    isInLastFocusRange: function () {
        var n = this.focusRange.length;
        if (n == 0) return true;
        if (this.currentFocusRangeIndex == n - 1) return true;
        return false;
    },

    /**
     * 是否在第一个焦点分区内
     * @returns {boolean}
     */
    isInFirstFocusRange()
    {
        var n = this.focusRange.length;

        if (n == 0) return true;
        if (this.currentFocusRangeIndex == 0) return true;
        return false;
    }

};

export default ISheetFocusRange;
