/**
 * Created by 三宝爹 on 2017/7/9.
 *
 * worksheet中与尺寸相关的操作
 */

import MergedRange from "../MergedRange.js";
import DataSourceConfig from '../DataSourceConfig.js';
import Util from '../../util/Util.js';


var ISheetDimension = {
    //设置列宽
    $setColumnWidth: function (colindex, width) {

        this.CPM.setColumnWidth(colindex, width);

        this.resetHScrollBarScrollRange();

    },


    $setWidthBetweenTwoColumn: function (col1, col2, delta) {
        var w1 = this.CPM.getColumnWidth(col1); // 临时保存原有宽度
        var w2 = this.CPM.getColumnWidth(col2);// 临时保存原有宽度
        var delta2 = delta - w1; // 宽度的增量
        this.CPM.setColumnWidth(col2, this.CPM.getColumnWidth(col2) - delta2); // 减去增量
        if (this.CPM.getColumnWidth(col2) == 0) // 如果宽度减去增量后小于0
        {
            this.CPM.setColumnWidth(col1, w1 + w2); // 强制为两列的宽度
        } else
        {
            this.CPM.setColumnWidth(col1, Math.max(0, delta));
        }

        this.resetHScrollBarScrollRange();

    },

    $setHeightBetweenTwoRow: function (row1, row2, delta) {
        var w1 = this.RPM.getRowHeight(row1); // 临时保存原有高度
        var w2 = this.RPM.getRowHeight(row2);// 临时保存原有高度
        var delta2 = delta - w1; // 高度的增量
        this.RPM.setRowHeight(row2, this.RPM.getRowHeight(row2) - delta2); // 减去增量
        if (this.RPM.getRowHeight(row2) == 0) // 如果高度减去增量后小于0
        {
            this.RPM.setRowHeight(row1, w1 + w2); // 强制为两列的高度
        } else
        {
            this.RPM.setRowHeight(row1, Math.max(0, delta));
        }

        this.resetVScrollBarScrollRange();

    },

    $setRowHeight: function (rowIndex, height) {
        this.RPM.setRowHeight(rowIndex, height);

        this.resetVScrollBarScrollRange();

    },


    getInnerRowAtPoint: function (cell, /*Point*/    p, /*boolean*/    setAsCurrentBindRow) {


        setAsCurrentBindRow = setAsCurrentBindRow || true;

        if (cell != null)
        {
            if (cell.Bind != null)
            {
                let dsc = this.Book.getDataSource(cell.Bind.dataSource);
                if (dsc.dataStore.rowCount == 0) return -1;

                if (cell.Bind.dataSourceType == DataSourceConfig.SingleRowDataSource) return 0;
                if (cell.Bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource) return dsc.currentBindRow;
            }
        }

        //没有绑定，或者绑定到多行时，
        var row = this.View.GetRowAtPoint(false, p.y);

        var dbRow = row.dbRow ? row.dbRow : 0;
        if (Util.isObject(row)) row = row.row;
        var mrdsn = this.RPM.getMultiRowDataSourceName(row);

        if (mrdsn == '') return -1;

        var dsc = this.Book.getDataSource(mrdsn);

        if (setAsCurrentBindRow)
        {
            dsc.currentBindRow = dbRow;

        }
        return dbRow;

    },


    //自已内部，也可能需要在尺寸变化后，做一点什么
    rowHeightChanged: function (row) {
        var CC = this.columnCount;
        for (var col = 0; col < CC; col++)
        {
            var cell = this.$cells(row, col);
            if (cell == null) continue;
            if (cell.merged) cell = cell.leftTopCorner;
            if (['html', 'image'].contains(cell.viewAs))
            {
                cell.clearInternalData();
            }
        }
    },

    //自已内部，也可能需要在尺寸变化后，做一点什么
    columnWidthChanged: function (col) {
        var RC = this.rowCount;
        for (var row = 0; row < RC; row++)
        {
            var cell = this.$cells(row, col);
            if (cell == null) continue;
            if (cell.merged) cell = cell.leftTopCorner;
            if (['html', 'image'].contains(cell.viewAs))
            {
                cell.clearInternalData();
            }
        }
    }


};

export default ISheetDimension;
