/**
 * Created by zengjun on 2017/5/4.
 *
 *
 * 关于边框，有如下几个要点
 *
 * 1 一个cell具有4个边，每个边都可以设置属性， 相临单元格它们会重叠一个像素点。比如A1的最右边与B1的最左边是重叠一个px的。为什么呢？没有
 * 为什么，就是这么设计的。要么重叠一个px ,要么不重叠。我选择了重叠，
 * 2 在设计器中，通常是针对选中区域设置边框
 * 3 在设置区域边框时，遵循相临边框都必须设置的原则。比如设置某单元格的左边框，表示该单元格左边相临单元格的右边框也必须设置成一样的
 *
 *  针对第3条的解释：
 *     比如设置B1的左边框为单线，同时也要设置A1（A1是B1左边相临的单元格）的右边框为单线。因为 A1在右边与B1的左边重叠一个点。如果仅仅
 *     设置B1的左边框为单线，A1 的右边框为空，那么当仅仅重绘A1时，会因为A1右边框为无，所以绘制A1时，右边是没有边框线的，但由于它与B1重
 *     叠了一个点，所以导致B1的左边框被覆盖。这样，A1与B1之间的边框就没有了，视觉上就是缺了边框线。
 *
 *
 */


import CMD_SetRangeBorder from '../../cmd/CMD_SetRangeBorder.js';

var IBorderDesign = {

    $setRangeBorder: function (/*Range*/ range, /*int*/ whichSide, /*String*/ style, /*int*/width, /*Color*/ color) {
        var ret = true;
        var b1, b2, b3, b4, b5, b6;
        var row, col;

        switch (whichSide)
        {
            case CMD_SetRangeBorder.BORDER_LEFT:
                ret = this.$setRangeLeftBorder(range, style, width, color);
                break;

            case CMD_SetRangeBorder.BORDER_RIGHT:
                ret = this.$setRangeRightBorder(range, style, width, color);
                break;

            case CMD_SetRangeBorder.BORDER_TOP:
                ret = this.$setRangeTopBorder(range, style, width, color);
                break;
            case CMD_SetRangeBorder.BORDER_BOTTOM:
                ret = this.$setRangeBottomBorder(range, style, width, color);
                break;

            case CMD_SetRangeBorder.BORDER_OUTER:
                b1 = this.$setRangeLeftBorder(range, style, width, color);
                b2 = this.$setRangeRightBorder(range, style, width, color);
                b3 = this.$setRangeTopBorder(range, style, width, color);
                b4 = this.$setRangeBottomBorder(range, style, width, color);
                ret = b1 || b2 || b3 || b4;
                break;

            case CMD_SetRangeBorder.BORDER_INNER:
                b5 = this.$setRangeInnerVBorder(range, style, width, color);
                b6 = this.$setRangeInnerHBorder(range, style, width, color);
                ret = b5 || b6;
                break;
            case CMD_SetRangeBorder.BORDER_INNERV:
                ret = this.$setRangeInnerVBorder(range, style, width, color);
                break;
            case CMD_SetRangeBorder.BORDER_INNERH:
                ret = this.$setRangeInnerHBorder(range, style, width, color);
                break;
            case CMD_SetRangeBorder.BORDER_ALL:
                b1 = this.$setRangeLeftBorder(range, style, width, color);
                b2 = this.$setRangeRightBorder(range, style, width, color);
                b3 = this.$setRangeTopBorder(range, style, width, color);
                b4 = this.$setRangeBottomBorder(range, style, width, color);
                b5 = this.$setRangeInnerVBorder(range, style, width, color);
                b6 = this.$setRangeInnerHBorder(range, style, width, color);
                ret = b1 || b2 || b3 || b4 || b5 || b6;
                break;

        }

        if (this.View) this.View.repaint();
        return ret;
    },


    $setCellBorder: function (cell, which, style, width, color) {

        cell.$setProperty('border-' + which + '-style', style);
        cell.$setProperty('border-' + which + '-width', width);
        cell.$setProperty('border-' + which + '-color', color);
    },


    $setRangeLeftBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;
        // 设置选中区域的左边列的左边框
        col = range.startCol;
        for (row = range.startRow; row <= range.endRow; row++)
        {

            var /*Cell*/ cell = this.createCell(row, col);
            this.$setCellBorder(cell, 'left', style, width, color);

            cell = this.createCell(row, col - 1);
            if (cell != null)
            {
                if (cell.isMerged()) cell = cell.mergedBy();
                this.$setCellBorder(cell, 'right', style, width, color);
            }

        }


        return true;
    },


    $setRangeRightBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;

        // 设置选中区域的右边列的右边框
        col = range.endCol;
        for (row = range.startRow; row <= range.endRow; row++)
        {
            var cell = this.createCell(row, col);
            if (cell.isMerged()) cell = cell.mergedBy();

            this.$setCellBorder(cell, 'right', style, width, color);


            //如果下一列存在，那么设置它左边框成一样的样式

            cell = this.createCell(row, col + 1);
            if (cell != null)
            {
                if (cell.isMerged()) cell = cell.mergedBy();
                this.$setCellBorder(cell, 'left', style, width, color);

            }

        }


        return true;
    },


    $setRangeTopBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;

        row = range.startRow;
        for (col = range.startCol; col <= range.endCol; col++)
        {

            var /*Cell*/cell = this.createCell(row, col);

            this.$setCellBorder(cell, 'top', style, width, color);


            cell = this.createCell(row - 1, col);
            if (cell != null)
            {
                if (cell.isMerged()) cell = cell.mergedBy();
                this.$setCellBorder(cell, 'bottom', style, width, color);

            }

        }


        return true;
    },


    $setRangeBottomBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;
        row = range.endRow;

        for (col = range.startCol; col <= range.endCol; col++)
        {

            var /*Cell*/cell = this.createCell(row, col);

            if (cell.isMerged()) cell = cell.mergedBy();


            this.$setCellBorder(cell, 'bottom', style, width, color);


            cell = this.createCell(row + 1, col);
            if (cell != null)
            {
                if (cell.isMerged()) cell = cell.mergedBy();
                this.$setCellBorder(cell, 'top', style, width, color);

            }


        }
        return true;
    },

    $setRangeInnerVBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;

        // 保存选中区域的内部除最后一列的右边界，除最左一列的右边界
        var startRow = range.startRow;
        var endRow = range.endRow;
        var startCol = range.startCol;
        var endCol = range.endCol;
        // 没有垂直方向的中间部分，那么不需要做
        if (startCol == endCol) return false;

        for (row = startRow; row <= endRow; row++)
        {
            for (col = startCol; col <= endCol; col++)
            {
                if (col != endCol)
                {
                    var /*Cell*/cell = this.createCell(row, col);
                    this.$setCellBorder(cell, 'right', style, width, color);

                }
                if (col != startCol)
                {
                    var /*Cell*/cell = this.createCell(row, col);
                    this.$setCellBorder(cell, 'left', style, width, color);

                }


            }
        }

        return true;

    }
    ,


    $setRangeInnerHBorder: function (/*Range*/ range, /*String*/style, /*int*/ width, /*Color*/ color) {
        var row, col;

        // 保存选中区域的内部除最后一列的右边界，除最左一列的右边界
        var startRow = range.startRow;
        var endRow = range.endRow;
        var startCol = range.startCol;
        var endCol = range.endCol;
        // 没有水平方向的中间部分，那么不需要做
        if (startRow == endRow) return false;

        for (row = startRow; row <= endRow; row++)
        {
            for (col = startCol; col <= endCol; col++)
            {
                var /*Cell*/cell = this.createCell(row, col);

                if (row != endRow)
                {

                    this.$setCellBorder(cell, 'bottom', style, width, color);

                }

                if (row != startRow)
                {
                    this.$setCellBorder(cell, 'top', style, width, color);
                }
            }
        }

        return true;

    }
}




export default IBorderDesign;
