/**
 * Created by 三宝爹 on 2017/12/20.
 */




var IExcel = {

    readXLS: function (callback) {

        var rABS = true; //使用二进制方式读文件
        if (!XLSX)
        {
            console.error('请包含xlsx.XXXX.js');
            return;
        }

        var input = $('#' + this.View.containerID + "_input_file");
        if (input.length == 0)
        {
            var html = `<form id=${this.View.containerID}_form>
                            <input type="file" id="${this.View.containerID}_input_file"  
                                   accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
                                       style="display:none; position:absolute; left:0px;top:0px; "> 
                      
                                </form>
                             `;

            //$('#' + this.containerID).append(input);
            var tabContainer = $('#' + this.View.containerID + " .tabContainer");
            tabContainer.append($(html));

            input = $('#' + this.View.containerID + "_input_file");

            input.change(function (e) {


                var reader = new FileReader();
                reader.onload = function (e) {

                    var data = e.target.result;
                    if (!rABS) data = new Uint8Array(data);
                    var workbook = XLSX.read(data, {type: rABS ? 'binary' : 'array'});

                    var result = {};
                    workbook.SheetNames.forEach(function (sheetName) {
                        var roa = XLSX.utils.sheet_to_json(workbook.Sheets[sheetName], {header: 1});
                        if (roa.length) result[sheetName] = roa;
                    });

                    if (callback)
                    {
                        callback(result);
                    } else
                    {
                        var str = JSON.stringify(result);
                        console.info(str);

                    }

                };
                var f = e.target.files[0];
                if (rABS)
                {
                    reader.readAsBinaryString(f);
                } else
                {
                    reader.readAsArrayBuffer(f);
                }


            });

        }

        var form = $('#' + this.View.containerID + "_form");
        //如果不复位一下，那么如果连续选择同一个文件，change事件是不触发的，
        form[0].reset();

        input.click();

    }

};

export default IExcel;
