/**
 * Created by zengjun in 2017
 *
 *
 *===============================
 *
 * 编辑格式配置
 */


import Class from '../base/Class.js';
import Color from '../gdi/Color.js';
import ObjectTool from '../db/ObjectTool.js';
import UniformDataType from '../core/UniformDataType.js';

 var EditStyle = Class.extend({

    static:
        {
            //编辑类型
            $Normal: 0,
            $Numeric: 1,
            $MultiLine: 2,
            $Datetime: 3,
            $DDLB: 4,
            $CheckBox: 5,
            $RadioButton: 6,
            $RichText: 7,
            $MultiCheckBox: 8,
            $Tree: 9,


            //日期缺省格式
            DefaultDatetimeFormat: "YYYY.MM.DD",



        },


    constructor: function (book, name, config) {
        this.book = book;
        this.name = name.toLowerCase().trim();
        this.ET = config.type || 0;


        // 多行编辑自动换行，当按回车时，编辑生效
        this.autoWordWrap = ObjectTool.changeType(config.autoWordWrap || true, UniformDataType.$Boolean);

        this.inputAttribute=  config.inputAttribute || "";


        //小数
        this.showComma = ObjectTool.changeType(config.showComma || false, UniformDataType.$Boolean);
        this.decimalCount = ObjectTool.changeType(config.decimalCount, UniformDataType.$Integer);


        if (config.zeroVisible == undefined) config.zeroVisible = true;
        this.zeroVisible = ObjectTool.changeType(config.zeroVisible || false, UniformDataType.$Boolean);


        //日期
        this.datetimeFormat = config.datetimeFormat || this.Clas$.DefaultDatetimeFormat;

        //下拉列表
        this.ddlbName = config.ddlbName || "";//列表配置的名称
        this.valueMustInDDLB = ObjectTool.changeType(config.valueMustInDDLB || false, UniformDataType.$Boolean);


        this.dropDownListEditable = ObjectTool.changeType(config.dropDownListEditable || false, UniformDataType.$Boolean);
        //当初始始时没有带入dropDownData参数时，系统提供一个缺省的没有数据的数据包，并且标记成没有初始化完成
        //这样，编辑时，不会因变量没有初始化而出错，同时也可以让程序在之后再异步加载列表项，加载完成后，记得把inited设置成true
        this.dropDownData = config.dropDownData || {dataValue: [], showText: [], inited: false};
        this.ddlbFilterBy = config.ddlbFilterBy || '';
        this.showRealData = ObjectTool.changeType(config.showRealData || false, UniformDataType.$Boolean);
        this.widthPercent = parseInt(config.widthPercent || 100);
        this.minLenInput = parseInt(config.minLenInput || 0);
        this.ddlbInnerItems = config.ddlbInnerItems || "";

        //下拉按钮是否显示
        this.dropDownButtonVisible = ObjectTool.changeType(config.dropDownButtonVisible || true, UniformDataType.$Boolean);


        //复选框
        this.checkOnValue = config.checkOnValue || 1;
        this.checkOffValue = config.checkOffValue || 0;
        this.checkOnChar = config.checkOnChar || '\uf058'; //  \uf14a'; // \uf058'; //      '\uf205';     \uf058   \uf00c
        this.checkOffChar = config.checkOffChar || '\uf1db';// \uf096'; // \uf1db' ; // '\uf204';      \uf1db   \uf1db
        this.checkCaption = config.checkCaption || '';// \uf096'; // \uf1db' ; // '\uf204';      \uf1db   \uf1db


        this.radioCheckOnChar = '\uf192';
        this.radioCheckOffChar = '\uf1db';


        this.multiCheckOnChar = '\uf046';
        this.multiCheckOffChar = '\uf096';


        //radio , multiCheckBox 分几列显示
        this.columnCount = ObjectTool.changeType(config.columnCount, UniformDataType.$Integer);

        this.readOnly = ObjectTool.changeType(config.readOnly || false, UniformDataType.$Boolean);

        //树
        this.treeName = config.treeName || "";//列表配置的名称
        this.treeNodes = config.treeNodes || [];
        this.treeNodesInited = config.treeNodesInited || false; //表明 treeNodes还没有初始化
        this.treeWidth = parseInt(config.treeWidth);  //树面板的宽度
        this.treeHeight = parseInt(config.treeHeight);  //树面板的高度
        this.treeSelectMulti = ObjectTool.changeType(config.treeSelectMulti || false, UniformDataType.$Boolean); //多选
        this.treeFilterBy = config.treeFilterBy || '';


    },


    getEditType: function () {
        return this.ET;
    },

    getEditTypeName: function () {
        switch (this.ET)
        {
            case this.Clas$.$CheckBox:
                return "checkbox";
            case this.Clas$.$Datetime:
                return "datetime";
            case this.Clas$.$DDLB:
                return "ddlb";
            case this.Clas$.$MultiCheckBox:
                return "multicheckbox";
            case this.Clas$.$Numeric:
                return "numeric";
            case this.Clas$.$RadioButton:
                return "radio";
            case this.Clas$.$RichText:
                return "richtext";
            case this.Clas$.$Tree:
                return "tree";
            default:
                return "unnamed " + this.ET;
        }

    },

    ddlb_data2text: function (v) {
        if (v == null) return '';
        let dataValue = '' + v;
        let showText = dataValue;

        //2020.12.01
        if( !this.dropDownData.inited) return showText;

        let i = this.dropDownData.dataValue.indexOf(dataValue);
        if (i >= 0){
            showText = this.dropDownData.showText[i];
        }
        return showText;
    },

    ddlb_text2data: function (s) {
        if (s == '') s = null;
        if (s == null) return s;


        let showText = s;

        //2020.12.01
        if( !this.dropDownData.inited) return showText;

        let i = this.dropDownData.showText.indexOf(showText);
        if (i < 0)
        {
            if (this.valueMustInDDLB) return null;
            return showText;
        }

        let dataValue = this.dropDownData.dataValue[i];
        return dataValue;
    },

    //下面两个是交互式列表所需

    setDDLBFilterBy: function (ddlbFilterBy_) {
        this.ddlbFilterBy = ddlbFilterBy_;
        if (this.ddlbFilterBy == null) return;
        this.ddlbFilterBy = this.ddlbFilterBy.trim();
        if (this.ddlbFilterBy.equals("")) this.ddlbFilterBy = null;
    },

    /**
     * 交互列表
     * @param innerRow
     * @returns {*}
     */
    getDropDownDataForEdit: function (cell, innerRow) {
        if (this.ddlbFilterBy == null) return this.dropDownData;
        if (this.ddlbFilterBy == '') return this.dropDownData;

        let ddlb = this.book.EM.fire("getDropDownDataForEdit", [this, cell, innerRow]);
        if (ddlb != null) return ddlb;
        return this.dropDownDataMap;

    },


    //2018.08.29 支持树形编辑
    //下面两个函数是树控件需在用到的
    setTreeFilterBy: function (treeFilterBy_) {
        this.treeFilterBy = treeFilterBy_;
        if (this.treeFilterBy == null) return;
        this.treeFilterBy = this.treeFilterBy.trim();
        if (this.treeFilterBy.equals("")) this.treeFilterBy = null;
    },

    getTreeNodesForEdit: function (cell, innerRow) {

        if (this.treeNodesInited)
        {
            if (this.treeFilterBy == null) return this.treeNodes;
            if (this.treeFilterBy == '') return this.treeNodes;
        }

        let nodes = this.book.EM.fire("getTreeNodesForEdit", [this, cell, innerRow]);
        if (nodes != null) return nodes;
        return this.treeNodes;

    },


});

export default EditStyle;
