/**
 * Created by 三宝爹 on 2017/8/1
 */


import Class from '../base/Class.js';
import IChangeListener from './IChangeListener.js';
import DataSourceConfig from './DataSourceConfig.js';
import ItemStatus from '../db/ItemStatus.js';
import DataStoreActionAdapter from '../db/DataStoreActionAdapter.js';


var DataStoreEventAdapter = DataStoreActionAdapter.extend({

    constructor: function (/*WorkBook*/ book, /*DataSourceConfig*/ dsc) {

        this.Book = book;
        this.DSC = dsc;
        this.DSC.DSEA = this;
        this.subscribeList = null;
        // 用来记录绑定到相应DataStore的Cell
        this.BindList = []; //ArrayList<Cell>

    },


    /**
     * 本函数不一定有机会调用
     */
    destructor: function () {
        this.Book = null;
        this.DSC = null;
        this.subscribeList = null;
        this.BindList = null;

    },

    /**
     * 通知订阅者，本单元格改变了，
     */
    notifyChangedToSubscriber: function () {

        if (this.subscribeList != null)
        {
            var n = this.subscribeList.length;
            for (var i = 0; i < n; i++)
            {
                var /*IChangeListener*/subscriber = this.subscribeList[i];
                subscriber.changed();
            }
        }

    },


    addSubscriber: function (/*IChangeListener*/ subscriber) {
        if (this.subscribeList == null) this.subscribeList = [];
        this.subscribeList.push(subscriber);
    },

    removeSubscriber: function (/*IChangeListener*/ subscriber) {

        if (this.subscribeList == null) return;
        this.subscribeList.remove(subscriber);
    },

    // 这个函数在 Cell中被调用
    registerCell: function (/*Cell*/ cell) {
        if (!this.BindList.contains(cell)) this.BindList.push(cell);

        // 在把单元格注册后，检查一下当前行是不是没有设置，
        if (this.DSC.currentBindRow < 0) this.ResetCurrentBindRow();

        //绑定变了，需要通告依赖它的单元格重新计算自己
        cell.$fireSelfValueChanged(-1);
    },

    // 这个函数在Cell中调用
    unRegisterCell: function (/*Cell*/ cell) {

        if (!this.BindList.contains(cell)) return;

        this.BindList.remove(cell);

        //绑定变了，需要通告依赖它的单元格重新计算自己
        cell.$fireSelfValueChanged(-1);
    },

    // 这个函数不是在Cell中调用 ,而是在WorkBook中RemoveDataStore中调用
    unRegisterAllCells: function () {
        // 注意不能用 for( Cell cell : BindList)及 for( int i=0;i<this.BindList.length;i++)来遍历列表
        //因为在 cell.clearBind函数中会将BindList中的元素移掉，即每执行一次clearBind后，bindlist
        // 中的元素就会发生变化。
        while (this.BindList.length > 0)
        {
            var /*Cell*/ cell = this.BindList[0];
            cell.clearBind();
        }

    },

    // 让相关的所有Cell都重绘
    repaintAllCells: function () {
        var views = [];


        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            var view = cell.Sheet.View;
            if (!views.contains(view) && view != null) views.push(view);

        }

        for (var i = 0; i < views.length; i++)
        {
            views[i].repaint();
        }

    },

    // 让相关的所有Cell 当前绑定行都在单元格的可视区域内, 本函数在  DataSourceConfig.setCurrentBindRow()中被调用

    assumeAllCellsCurrentBindRowOnCellVisibleRectangle: function () {

        if (this.DSC.dataSourceType == DataSourceConfig.SingleRowDataSource) return;

        var currentRow = this.DSC.currentBindRow;
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];

            var row = cell.rowIndex;
            var /*WorkSheet*/ sheet = cell.workSheet;
            if (cell.bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource) return;

            var /*RowPropertyManage*/ RPM = sheet.RPM;
            if (RPM.isAutoAsyncHeightWithDBRowHeight(row)) continue; //所有数据行都显示，没有卷滚条，那么不需要做什么

            if (this.DSC.dataStore.rowCount == 0)
            {
                RPM.setRowScrolledRowCount(row, 0);
                continue;
            }

            var scrolledRC = RPM.getRowScrolledRowCount(row);

            if (currentRow < scrolledRC)
            {

                RPM.setRowScrolledRowCount(row, currentRow);
                continue;
            }

            var /*WorkSheetView*/ view = sheet.workSheetView;
            if (view == null) return;
            var /*Rectangle*/ rc;
            rc = view.getShowRectangleOfCell(false, row, cell.columnIndex);

            //TODO


        }

    },


    // 让相关的所有Cell都触发值发生变化事件
    // 此函数在 retrieveend , afterdelete , afterinsert , itemchanged , afterfilter , aftersort 都需要调用
    // 这个如果有其它的单元格引用了绑定到这个数据源的单元格的内容，那么它们会得到重新计算的时机
    FireAllBindCellsValueChanged: function (/*int*/ innerRow) {

        var views = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            cell.$fireSelfValueChanged(innerRow);
            var view = cell.Sheet.View;
            if (!views.contains(view) && view != null) views.push(view);
        }
        //通知订阅者自已改变了
        this.notifyChangedToSubscriber();


        for (var i = 0; i < views.length; i++)
        {
            views[i].repaint();
        }


    },

    FireAllBindViewRepaint: function ( ) {

        var views = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];

            var view = cell.Sheet.View;
            if (!views.contains(view) && view != null) views.push(view);
        }


        for (var i = 0; i < views.length; i++)
        {
            views[i].repaint();
        }

    },

    /**
     * 行发生变化后，需要重新设置垂直卷滚条的滚动高度
     * @constructor
     */
    FireSheetOfAllBindCellsResetVScrollBarScrollRange: function () {
        var sheetList = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];

            if (cell.bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource) return;

            var sheet = cell.workSheet;
            if (sheetList.contains(sheet)) continue;
            sheetList.push(sheet);

            sheet.resetVScrollBarScrollRange();


        }

    },

    FireSheetOfAllBindCellsResetYOffset: function () {
        //当Retrieve后，本函数会调用，因为如果本行正好就是锁定的行，并且有y上的scroll, 那么把y上的offset设置为0
        // 主要是解决当做了垂直卷滚后，又检索数据，如果不把y上的offset复位，那么数据可能就看不见
        //产生没有数据的错觉

        if (this.DSC.dataSourceType == DataSourceConfig.SingleRowDataSource) return;


        var sheetList = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];

            if (cell.bind.dataSourceType == DataSourceConfig.AsSingleRowDataSource) return;

            var sheet = cell.workSheet;
            if (sheetList.contains(sheet)) continue;
            sheetList.push(sheet);

            var /*RowPropertyManage*/ RPM = sheet.RPM;
            //如果该行是内建卷滚的，那么内建卷滚条复位，否则整个Sheet的yoffset复位
            var row = cell.rowIndex;
            if (RPM.getRowScrolledRowCount(row) > 0)
            {
                RPM.setRowScrolledRowCount(row, 0);
            } else
            {
                var /*Cell*/ fc = sheet.getFreezedCell();//如果表单是有锁定单元格的，并且就在这个Cell所在行上锁定，那么复位它
                if (fc != null)
                {
                    if (sheet.yOffset != 0)
                    {
                        if (fc.rowIndex == row) sheet.yOffset = 0;
                    }
                }
            }

            //2019.078.18 可能需要对控制的显示隐藏做调整
            sheet.bricksShowOrHideWithWorkSheet();

        }


    },


    // 功能同上面的FireAllBindCellsValueChanged，只是它只是触发绑定到指定数据列的所有单元格
    // 做一些动作， 本函数在 计算列或字段发生变化时被调用
    FireSomeOneBindCellsValueChanged: function (/*int*/ dbRow, /*String*/ dbcol) {

        var views = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            var /*DBBindConfig*/ bind = cell.bind;
            if (bind.DBCol.equalsIgnoreCase(dbcol))
            {
                cell.$fireSelfValueChanged(dbRow);
                var view = cell.Sheet.View;
                if (!views.contains(view) && view != null) views.push(view);
                if(   cell.temp_needRepaint!=undefined)
                {
                    //2020.05.02  单元格如果是 Radio等编辑格式时， 当点击单元格，立即进入编辑，并且点击导致数据变化，此时
                    // 会进入到这里来， 对于radio 编辑是在当前编辑单元格位置上嵌了另一个canvas来提供一样的视觉效果并响应鼠标点击
                    // 此canvas并不是与单元格一样大，而是周围留出了padding ,这样如果单元格重绘，那么那些padding 处并不被此编辑
                    // canvas 覆盖 ，如果此单元格是一个绑定多行的单元格，那么它的亮显背景在 padding 那块就没有显示，出现一圈白边
                    //不好看，所以加了一个临时变量，用来控制不要重绘。此变量会及时删除（参看Cell.js中标记20200502-01）
                    if(! cell.temp_needRepaint ) continue;
                }
                cell.repaint();
            }
        }
        //通知订阅者自已改变了
        this.notifyChangedToSubscriber();

        /*  2020.05.02 取消了整体重绘， 改成单元格单独重绘
        for (var i = 0; i < views.length; i++)
        {
            views[i].repaint();
        }
        */
    },

    /**
     * 得到绑定到某个字段的所有单元格
     * @param dbcol
     * @return
     */
    getAllCellsWhichBindTheCol: function (/*String*/ dbcol) {
        var list = [];

        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            var /*DBBindConfig*/ bind = cell.bind;
            if (bind.DBCol.equalsIgnoreCase(dbcol))
            {
                list.push(cell);
            }
        }
        return list;
    },


    // 让绑定到某列的所有Cell都重绘
    RepaintCell: function (/*String*/ dbcol) {

        var views = [];
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            cell.clearInternalData();
            var /*DBBindConfig*/ bind = cell.bind;
            if (bind.DBCol.equalsIgnoreCase(dbcol))
            {
                var view = cell.Sheet.View;
                if (!views.contains(view) && view != null) views.push(view);
            }

        }

        for (var i = 0; i < views.length; i++)
        {
            views[i].repaint();
        }
    },

    // 在Retrieve ， filter , sor 后，复位当前绑定行，setCurrentBindRow会引起重绘，所以不需要再触发重绘了
    ResetCurrentBindRow: function () {

        if (this.DSC.dataStore.rowCount == 0)
        {
            this.DSC.setCurrentBindRow(-1);
        } else
        {
            this.DSC.setCurrentBindRow(0);
        }

    },


    /*@Override*/
    afterDeleteRow: function (/*int*/row) {
        var rc = this.DSC.dataStore.rowCount;
        if (row < rc)
        {
            this.DSC.setCurrentBindRow(row);
        } else
        {
            this.DSC.setCurrentBindRow(rc - 1);
        }

        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        // 备注1： 因为删除了某行，通知单元格发生变化。删除了row行，并不是说是row行变了，应该用 -1
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetVScrollBarScrollRange();
    },

    /*@Override*/
    afterFilter: function (/*int*/ primaryBufferRowCount, /*int*/ filterBufferRowCount) {
        this.ResetCurrentBindRow();

        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetVScrollBarScrollRange();
    },

    /*@Override*/
    afterReset: function () {
        this.ResetCurrentBindRow();

        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetVScrollBarScrollRange();
        this.FireSheetOfAllBindCellsResetYOffset();

    },

    /*@Override*/
    afterInsertRow: function (row) {
        this.DSC.setCurrentBindRow(row);

        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        this.FireAllBindCellsValueChanged(row);
        this.FireSheetOfAllBindCellsResetVScrollBarScrollRange();
    },

    /*@Override*/
    afterSort: function () {
        this.ResetCurrentBindRow();
        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        this.FireAllBindCellsValueChanged(-1);
        this.FireSheetOfAllBindCellsResetYOffset();
    },

    /*@Override*/
    computerChanged: function (/*int*/ row, /*String*/ computer) {

        this.FireSomeOneBindCellsValueChanged(row, computer);
    },

    /*@Override*/
    deleteRowPermit: function (/*int*/ row) {
        return true;
    },

    /*@Override*/
    itemChangeAccept: function (/*int*/row, /*String*/ col, /*Object*/ value) {
        return true;
    },

    /*@Override*/
    itemChanged: function (/*int*/row, /*String*/ col, /*Object*/ oldValue, /*Object*/ newValue) {
        this.FireSomeOneBindCellsValueChanged(row, col);
    },

    /*@Override*/
    retrieveEnd: function (/*int*/rowCount, /*boolean*/ withLastSelect, isResetBeforeRetrieve) {
        this.retrieveOnceMoreEnd(1, rowCount ,isResetBeforeRetrieve);
    },

    refreshRetrieveEnd: function (row) {
        this.FireAllBindViewRepaint();
    }, //某行刷新检索完成

    /*@Override*/
    retrieveOnceMoreEnd: function (/*int*/ retrieveTimes, /*int*/rowCount ,isResetBeforeRetrieve) {

        console.info("retrieveOnceMoreEnd");
        /*
        * 2020.05.24 增加：
        * 当划屏追加检索时，不能重设置当前绑定行
        * */

        if( isResetBeforeRetrieve==undefined) isResetBeforeRetrieve=true;
        if( isResetBeforeRetrieve) this.ResetCurrentBindRow();


        this.FireSheetOfAllBindCellsResetVScrollBarScrollRange();

        if( isResetBeforeRetrieve) this.FireSheetOfAllBindCellsResetYOffset();

        // 让绑定到这个数据源的所有单元格通知依赖他们的Cells要重新计算自己
        // 在下面的调用中，如果有垂直的free,并且的y方向上的offset ，那么会把yoffset复位，参看 Cell_.$ResetContainerRowHeight
        this.FireAllBindCellsValueChanged(-1);


    },

    /**
     * 解析结果集定义中的内联参数
     * @param expression
     */
    parseInnerParameter: function (expression) {
        var sheet = this.Book.activeSheet;
        return sheet.evaluate(expression);

    },

    /**
     * DS把Cell的Define当作DefaultValue来调取
     *
     */
    loadValueFromCellDefineAsDefaultValue: function () {
        var /*DataStore*/ ds = this.DSC.dataStore;
        var rc = ds.rowCount;
        for (var bi = 0; bi < this.BindList.length; bi++)
        {
            var /*Cell*/ cell = this.BindList[bi];
            var /*DBBindConfig*/ bind = cell.bind;
            var /*String*/ dbcol = bind.DBCol;
            var /*String*/ define = cell.define.trim();
            if (define == '') continue;

            for (var i = 0; i < rc; i++)
            {


                var status = ds.getPrimaryBuffer().getItemStatus(i, dbcol);
                if (status == ItemStatus.isNew || status == -1)
                {
                    ds.setValue(i, dbcol, define);

                } else if (ds.getValue(i, dbcol) == null)
                {
                    ds.setValue(i, dbcol, define);
                }
            }

        }

    }


});

export default DataStoreEventAdapter;
