/**
 * Created by 三宝爹 on 2017/8/5.
 */


import Class from '../base/Class.js';
import RowProperty from './RowProperty.js';


var ColumnConfig = function (size) {
    this.size = size;
    this.size2 = -1;
    this.stretchSize = 0;
    this.tag = null;
};


var ColumnPropertyManage = Class.extend({

    static: {
        defaultColumnWidth: 100//缺省宽度
    },

    properties: {

        /**
         * @api {columnCount} 只读属性 [属性]columnCount
         * @apiName  columnCount
         * @apiDescription WorkSheet的列数
         * @apiGroup ColumnPropertyManage
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){int} - 列数
         * @apiExample {js}(示例：)
         *
         * var cc = book.sheet0.getColumnPropertyManage().columnCount;
         *
         */
        "columnCount": {
            get: function () { return this.widthList.length;}
        },

        /**
         * @api {fixedColumnCount} 只读属性 [属性]fixedColumnCount
         * @apiName  fixedColumnCount
         * @apiDescription WorkSheet的被锁定的列数
         * @apiGroup ColumnPropertyManage
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){int} - 被锁定的列数
         * @apiExample {js}(示例：)
         *
         * var fcc = book.sheet0.getColumnPropertyManage().fixedColumnCount;
         *
         */
        "fixedColumnCount": {
            get: function () { return this.getFixedColumnCount();}
        },

        /**
         * @api {columnHeadHeight} 可读可写属性 [属性]columnHeadHeight
         * @apiName  columnHeadHeight
         * @apiDescription WorkSheet的列头的高度
         * @apiGroup ColumnPropertyManage
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){int} - 列头的高度
         * @apiExample {js}(示例：)
         *
         * var chh = book.sheet0.getColumnPropertyManage().columnHeadHeight;
         *  book.sheet0.getColumnPropertyManage().columnHeadHeight=0; //隐藏列头
         *
         */
        "columnHeadHeight": {
            get: function () { return this.getColumnHeadHeight();},
            set: function (val) { this.ColumnHeadHeight = Math.max(0, val);}
        },

        /**
         * @api {showColumnIndex} 可读可写属性 [属性]showColumnIndex
         * @apiName  showColumnIndex
         * @apiDescription true表示 列头显示序号，false表示列头显示字母
         * @apiGroup ColumnPropertyManage
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){boolean} - 列头显示序号还是字母
         * @apiExample {js}(示例：)
         *
         * var b = book.sheet0.getColumnPropertyManage().showColumnIndex;
         *  book.sheet0.getColumnPropertyManage().showColumnIndex=true;
         *
         */
        "showColumnIndex": {
            get: function () { return this.isShowColumnIndex();},
            set: function (val) { this.setShowColumnIndex(val);}
        }

    },
    constructor: function (/*int*/columnCount, /*WorkSheet*/ sheet) {


        this.widthList = []; //ArrayList<ColumnConfig>
        this.ShowColumnIndex = false;//显示列名称时同时是否显示列号
        this.ColumnHeadHeight = 25;
        this.Sheet = sheet;

        for (var i = 0; i < columnCount; i++)
        {
            this.widthList.push(new ColumnConfig(this.Clas$.defaultColumnWidth));
        }


    },

    getColumnCount: function () {
        return this.widthList.length;
    },

    getFixedColumnCount: function () {
        var /*Cell*/ cell = this.Sheet.getFreezedCell();
        if (cell == null) return 0;
        return cell.columnIndex;
    },


    /**
     * @api {getColumnWidth} 函数   getColumnWidth
     *
     * @apiDescription  getColumnWidth(col)
     * <br><br> 返回列的宽度
     *
     * @apiName  getColumnWidth
     * @apiGroup ColumnPropertyManage
     * @apiVersion 1.0.0
     *
     * @apiParam {int} col 列号，从0开始计数
     *
     *
     * @apiSuccess (返回值){int} - 返回列的宽度
     *
     *
     * @apiExample   {js}示例：
     *
     *  var  cw=  book.sheet0.getColumnPropertyManage().getColumnWidth(0);
     *
     */
    getColumnWidth: function (/*int*/ col) {
        if (col < 0) return 0;
        if (col >= this.columnCount) return 0;
        return this.widthList[col].size;
    },

    getColumnHeadHeight: function () {
        return this.ColumnHeadHeight;
    },

    getColumnStretchWidth: function (/*int*/ col) {
        if (col < 0) return 0;
        if (col >= this.columnCount) return 0;
        return this.widthList[col].stretchSize;
    },

    getColumnX: function (/*int*/ col) {
        var ret = 0;

        for (var i = 0; i < col; i++)
        {
            if (col >= this.widthList.length) break;
            ret += this.widthList[i].size;
        }
        return ret;
    },


    /**
     * @api {setColumnWidth} 函数   setColumnWidth
     *
     * @apiDescription  setColumnWidth(col,newWidth)
     * <br><br> 设置列的宽度
     *
     * @apiName  setColumnWidth
     * @apiGroup ColumnPropertyManage
     * @apiVersion 1.0.0
     *
     * @apiParam {int} col 列号，从0开始计数
     *@apiParam {int} newWidth 列宽,大于等于0的整数
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     *
     * @apiExample   {js}示例：
     *
     *  var  cpm=  book.sheet0.getColumnPropertyManage();
     *  cpm.setColumnWidth(0,100);
     *
     */

    //needCalculateStretchWidth 本函数会在 view.reCalcuColumnsWidth又被调用，此参数可避免死循环
    setColumnWidth: function (/*int*/ col, /*int*/ newWidth, needCalculateStretchWidth) {
        if (col < 0) return;
        if (col >= this.columnCount) return;
        if (newWidth == this.widthList[col].size) return;
        if (newWidth < 0) return;
        if (needCalculateStretchWidth == undefined) needCalculateStretchWidth = true; //设置列宽后，是否需要触发弹性列重新计算列宽
        var oldWidth = this.widthList[col].size;
        this.widthList[col].size = newWidth;

        var /*WorkSheetView*/ view = this.Sheet.View;


        //自已内部，也可能需要在尺寸变化后，做一点什么
        this.Sheet.columnWidthChanged(col);

        if (view != null)
        {
            //重绘
            view.repaint();
            //触发事件
            view.EM.fire("columnWidthChanged", [this.Sheet, col, oldWidth, newWidth]);
            //重新计算弹性列的宽度
            if (needCalculateStretchWidth) view.reCalcuColumnsWidth();

        }


    },

    setColumnStretchWidth: function (/*int*/ col, /*int*/ percent) {
        if (col < 0) return;
        if (col >= this.columnCount) return;
        if (percent == this.widthList[col].stretchSize) return;
        if (percent < 0) return;

        this.widthList[col].stretchSize = percent;

        var /*WorkSheetView*/ view = this.Sheet.workSheetView;

        if (view != null)
        {
            //重绘
            view.reCalcuColumnsWidth();

        }

    },

    getFixedColumnWidth: function () {
        return this.getColumnX(this.getFixedColumnCount());
    },

    getAllColumnsWidth: function () {
        var ret = 0;
        var n = this.columnCount;
        for (var i = 0; i < n; i++)
        {
            ret += this.widthList[i].size;
        }
        return ret;

    },


    getColumnName: function (col) {
        if (col < 0) return "";

        var s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

        var a = Math.floor(col / 26);
        var ret = "";
        var b = col - a * 26;

        if (col >= 26)
        {
            ret = s.substring(a - 1, a) + s.substring(b, b + 1);
        } else
        {
            ret = s.substring(col, col + 1);
        }

        return ret;

    },

    $$insertBefore: function (/*int*/beforeCol) {
        if (beforeCol < 0) beforeCol = 0;

        var cc = this.columnCount;
        if (beforeCol >= cc)
        {
            this.widthList.push(new ColumnConfig(this.Clas$.defaultColumnWidth)); //在最后追加
        } else
        {
            this.widthList.splice(beforeCol, 0, new ColumnConfig(this.Clas$.defaultColumnWidth)); // 在beforeRow 位置追加
        }
    },

    $insertMultiColumn: function (/*int*/ startCol, /*int*/ endCol) {
        for (var i = startCol; i <= endCol; i++)
        {
            this.$$insertBefore(i);
        }
    },

    $deleteColumn: function (/*int*/col) {
        if (col < 0) return;

        var cc = this.columnCount;
        if (col >= cc) return;
        this.widthList.removeAt(col);

    },

    isShowColumnIndex: function () {
        return this.ShowColumnIndex;
    },

    setShowColumnIndex: function (/*boolean*/ b) {
        if (this.ShowColumnIndex == b) return;
        this.ShowColumnIndex = b;

        var /*WorkSheetView*/ view = this.Sheet.workSheetView;
        if (view != null)
        {
            //重绘
            view.repaint();
        }
    },


    getColumnShowText: function (/*int*/ col) {
        var s = this.getColumnName(col);
        if (this.ShowColumnIndex) s = col + 1;
        return s;
    },

    getColumnTag: function (/*int*/ col) {

        return this.widthList[col].tag;
    },

    setColumnTag: function (/*int*/ col, /*Object*/ tag) {
        this.widthList[col].tag = tag;

    },

    getColumnWidth2: function (/*int*/ col) {
        return this.widthList[col].size2;
    },

    setColumnWidth2: function (/*int*/ col, /*int*/ newWidth) {
        this.widthList[col].size2 = newWidth;

    }


});

export default ColumnPropertyManage;
