/**
 * Created by 三宝爹 on 2017/7/15.
 */


import Class from '../base/Class.js';

import Property from './Property.js';

var  ClipBoard = Class.extend({

    static: {
        COPY: 1,
        CUT: 2,

        saveCellRangeToScene: function (sheet, range, scene, withSize) {
            //保存
            var r1 = range.startRow;
            var c1 = range.startCol;
            var r2 = range.endRow;
            var c2 = range.endCol;
            withSize = withSize == undefined ? false : withSize;

            for (var row = r1; row <= r2; row++)
            {

                if (withSize) scene.put('rowHeight-' + row, sheet.RPM.getRowHeight(row));
                for (var col = c1; col <= c2; col++)
                {

                    if (row == r1 && withSize) scene.put('columnWidth-' + col, sheet.CPM.getColumnWidth(col));
                    var cell = sheet.$cells(row, col);
                    if (cell == null)
                    {
                        scene.put(row + "-" + col, null);
                    }
                    else
                    {
                        scene.put(row + "-" + col, cell.serialize);
                    }

                }
            }

            scene.put("startRow", range.startRow);
            scene.put("startCol", range.startCol);
            scene.put("endRow", range.endRow);
            scene.put("endCol", range.endCol);

        },


        /**
         * 把　保存在 source  中的　位置由 scenePos描述的内容复制到sheet 的从 startRow, startCol 开始的单元区域中
         * @param sheet
         * @param startRow
         * @param startCol
         * @param source
         * @param scenePos
         * @return
         */

        restoreCellRangeFromScene: function (/*WorkSheet*/toSheet, /*int*/ toStartRow, /*int*/toStartCol,
                                             /*Property*/source, /*Range*/scenePos, /*boolean*/aliasReplace, withSize) {

            if (withSize == undefined) withSize = false;

            var r1 = scenePos.startRow;
            var c1 = scenePos.startCol;
            var r2 = scenePos.endRow;
            var c2 = scenePos.endCol;


            var dr = toStartRow - r1;
            var dc = toStartCol - c1;
            // 取得要复制的内容

            var pp = toSheet.paintPermit;

            toSheet.paintPermit = false;


            for (var row = r1; row <= r2; row++)
            {
                if (row + dr >= toSheet.rowCount) toSheet.insertMultiRow(999999, 999999);
                if (withSize)
                {
                    var h = source.get("rowHeight-" + row);
                    if (h != undefined) toSheet.RPM.setRowHeight(row + dr, h);
                }

                for (var col = c1; col <= c2; col++)
                {
                    if (col + dc >= toSheet.columnCount) toSheet.insertMultiColumn(9999, 9999);
                    if (row == r1 && withSize)
                    {
                        var w = source.get("columnWidth-" + col);
                        if (w != undefined) toSheet.CPM.setColumnWidth(col + dc, w);
                    }

                    var cs = source.get(row + "-" + col);
                    var cell = toSheet.$cells(row + dr, col + dc);
                    // 如果要复制的内容是空的，单元格也是空的，那么什么也不需要做
                    if (cell == null && cs == null) continue;
                    //确保cell已经创建
                    if (cell == null) cell = toSheet.cells(row + dr, col + dc);
                    //有可能是行列越界了
                    if (cell == null) continue;

                    cell.serializeFrom(cs, aliasReplace, false);

                }
            }

            toSheet.paintPermit = pp;

            return true;

        }


    },
    constructor: function (sheet, /*Range*/ r, /*int*/ action, withSize) {
        this.Sheet = sheet;
        this.range = r.clone();
        this.Action = action;
        this.Scene = new Property();
        this.Clas$.saveCellRangeToScene(this.Sheet, this.range, this.Scene, withSize);
    }


});

export default ClipBoard;
