/**
 * Created by zengjun in  2017
 */


import Class from '../base/Class.js';

var CommandManage = Class.extend({

    properties: {
        "needUndo": {
            get: function () { return this.getNeedUndo();},
            set: function (val) { this.setNeedUndo(val)},

        }
    },

    constructor: function (sheet) {
        this.UndoStack = []; //
        this.RedoStack = [];//
        this.level = 0;
        this.NeedUndo = true;
        this.Owner = sheet;
    },


    _$CommandManage: function () {
        this.UndoStack = null;
        this.RedoStack = null;
        this.Owner = null;
    },

    stepIn: function () {
        this.level++;
    },

    stepOut: function () {
        this.level--;
    },

    getLevel: function () {
        return this.level;
    },


    pushCommand: function (/*Command*/ cmd) {
        this.UndoStack.push(cmd);
        this.RedoStack.clear();
        /* <pre>
         当使用Undo后，要么立即使用Redo，否则当做了一个新的操作后，所有的Undo不可以被再次Redo
         示例：操作序列
         1 把单元格的内容设置成1，
         2 设置成2 ，
         3 设置成3 ，
         4   Undo（后为2）
         5   Undo（为1）
         6 再设置成4，
         7 再设置成5 ，
         8   Undo（后为4），
         9   Undo后为1，
         10 再Undo（变成最初状态），
         11 这时Rodo为4，
         12 再Redo为5
         说明：.因为前面第5，第6的两次Undo后（操作被加入到了Redo列表），当第6步再设置成4这个操作执行时，
         Redo列表被清空，所以第2，第3步不可能再被Redo了。

         以上是分析Excel的Redo，Undo得出的结果。 这个原则可能理解为：如果一个操作在作了之后立即Undo，要么再立即Redo，
         否则在做的新的操作后，它将被视为没有发生过。

         <pre>

         */

    },

    redo: function () {
        if (this.RedoStack.length == 0) return;
        var cmd = this.RedoStack.pop();

        var ok = cmd.redo();
        if (ok) this.UndoStack.push(cmd);
        // 参看  *1
        if (cmd.getLevel() != 1) this.redo();
    },

    undo: function () {
        if (this.UndoStack.length == 0) return;
        var cmd = this.UndoStack.pop();

        var ok = cmd.undo();
        if (ok) this.RedoStack.push(cmd);

        // *1 当一个Command的$Execute中又调用其它的Command时，被调用的其它的Command
        // 会先压栈，自己最后压栈，所以在Undo时，是自己先Undo，然后是被调用的其它的Command
        // 再Undo，直接下一个Command.getLevel==1时这表示所以嵌套调用的Command已经全部Undo了
        // 此时，是自已先被压入Redo栈，然后才是被嵌套调用的Command压入Redo栈，所以在Redo时
        // 是当 command.getLevel() !=1 时表示嵌套的命令组还没有全部Redo结束
        if (this.UndoStack.length > 0)
        {
            cmd = this.UndoStack[this.UndoStack.length - 1]; //访问最后一个，但不删除
            if (cmd.getLevel() != 1) this.undo();
        }
    },


    getNeedUndo: function () {
        // 如果是运行模式，那么不需要Undo
        return this.NeedUndo && this.Owner.designMode;
    },

    setNeedUndo: function (b) {
        this.NeedUndo = b;

    }

});

export default CommandManage;
