/**
 * Created by 三宝爹 on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetWidthBetweenTwoColumn = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var /*ColumnPropertyManage*/ CPM = this.Sheet.getColumnPropertyManage();

        var col1 = Scene.get("col1", 0);
        var col2 = Scene.get("col2", 0);

        this.Scene.put("oldwidth1", CPM.getColumnWidth(col1));
        this.Scene.put("oldwidth2", CPM.getColumnWidth(col2));

    },

    $execute: function () {
        var col1 = this.Scene.get("col1", 0);
        var col2 = this.Scene.get("col2", 0);

        var delta = this.Scene.get("delta", 0);
        this.Sheet.$setWidthBetweenTwoColumn(col1, col2, delta);

        return true;

    },

    $undo: function () {
        var col1 = this.Scene.get("col1", 0);
        var col2 = this.Scene.get("col2", 0);

        var oldWidth1 = this.Scene.get("oldwidth1", 0);
        var oldWidth2 = this.Scene.get("oldwidth2", 0);

        this.Sheet.$setColumnWidth(col1, oldWidth1);
        this.Sheet.$setColumnWidth(col2, oldWidth2);
        return true;

    }

});


export default CMD_SetWidthBetweenTwoColumn;
