/**
 * Created by 三宝爹 on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetRowHeight = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var /*RowPropertyManage*/ RPM = this.Sheet.getRowPropertyManage();
        var row = this.Scene.get("row", 0);
        var oldHeight = CPM.getRowHeight(row);
        this.Scene.put("oldheight", oldHeight);
    },

    $execute: function () {
        var row = this.Scene.get("row", 0);
        var height = this.Scene.get("height", 0);
        this.Sheet.$setRowHeight(row, height);
        return true;

    },

    $undo: function () {
        var row = this.Scene.get("row", 0);
        var oldheight = this.Scene.get("oldheight", 0);
        this.Sheet.$setRowHeight(row, oldheight);
        return true;
    }

});

export default CMD_SetRowHeight;

