/**
 * 设置边框
 * Created by zengjun on 2017/5/4.
 */


import Command from './Command.js';
import Property from '../core/Property.js';
import Color from '../gdi/Color.js';
import Util from '../util/Util.js';


var CMD_SetRangeBorder = Command.extend({

    static: {
        BORDER_LEFT: 0,
        BORDER_RIGHT: 1,
        BORDER_TOP: 2,
        BORDER_BOTTOM: 3,
        BORDER_INNERH: 4,
        BORDER_INNERV: 5,
        BORDER_OUTER: 6,
        BORDER_INNER: 7,
        BORDER_ALL: 8
    },

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var range = this.Scene.get("range");
        var whichSide = this.Scene.get("side", this.Clas$.BORDER_LEFT);
        var style = this.Scene.get("style", 0);
        var width = this.Scene.get("width", 0);
        var backup = [];
        var row, col;
        switch (whichSide)
        {
            case this.Clas$.BORDER_LEFT :
                this.SaveLeft(range, backup);
                break;

            case this.Clas$.BORDER_RIGHT :
                this.SaveRight(range, backup);
                break;
            case this.Clas$.BORDER_TOP :
                this.SaveTop(range, backup);
                break;

            case this.Clas$.BORDER_BOTTOM :
                this.SaveBottom(range, backup);
                break;

            case this.Clas$.BORDER_OUTER :
                this.SaveLeft(range, backup);
                this.SaveRight(range, backup);
                this.SaveTop(range, backup);
                this.SaveBottom(range, backup);
                break;

            case this.Clas$.BORDER_INNER :
                this.SaveInnerV(range, backup);
                this.SaveInnerH(range, backup);
                break;

            case this.Clas$.BORDER_INNERV :
                this.SaveInnerV(range, backup);
                break;
            case this.Clas$.BORDER_INNERH :
                this.SaveInnerH(range, backup);
                break;
            case this.Clas$.BORDER_ALL :
                this.SaveLeft(range, backup);
                this.SaveRight(range, backup);
                this.SaveTop(range, backup);
                this.SaveBottom(range, backup);
                this.SaveInnerV(range, backup);
                this.SaveInnerH(range, backup);
                break;
        }

        this.Scene.put("backup", backup);
    },

    $execute: function () {
        var range = this.Scene.get("range");
        var whichSide = this.Scene.get("side", 0);
        var style = this.Scene.get("style", 0);
        var width = this.Scene.get("width", 0);
        var color = this.Scene.get("color", Color.BLACK);
        if (Util.isString(color)) color = new Color(color);

        return this.Sheet.$setRangeBorder(range, whichSide, style, width, color);

    },

    $undo: function () {
        var backup = this.Scene.get("backup");

        for (var ci = 0; ci < backup.length; ci++)
        {
            var cs = backup[ci];
            var row = cs.get("row", 0);
            var col = cs.get("col", 0);
            var propertyName = cs.get("propertyname", "");
            var propertyValue = cs.get("propertyvalue", null);

            var cell = this.Sheet.cells(row, col);
            if (propertyValue != null) if (propertyValue == cell.getPropertyValue(propertyName)) continue;
            cell.$setProperty(propertyName, propertyValue);// 注意不能直接调用setProperty

        }
        return true;
    },


    SaveLeft: function (range, backup) {
        var row, col;
        // 保存选中区域的左边列的左边框
        col = range.startCol;
        for (row = range.startRow; row <= range.endRow; row++)
        {

            backup.push(this.getPropertyObject(row, col, Property.border_left_style));
            backup.push(this.getPropertyObject(row, col, Property.border_left_width));
            backup.push(this.getPropertyObject(row, col, Property.border_left_color));

        }

        col--;
        // 保存选中区域的左边列的左边列的右边框
        if (col >= 0)
        {

            for (row = range.startRow; row <= range.endRow; row++)
            {
                backup.push(this.getPropertyObject(row, col, Property.border_right_style));

            }
        }

    },

    SaveRight: function (range, backup) {
        var row, col;
        // 保存选中区域的右边列的右边框
        col = range.endCol;
        for (row = range.startRow; row <= range.endRow; row++)
        {

            backup.push(this.getPropertyObject(row, col, Property.border_right_style));
            backup.push(this.getPropertyObject(row, col, Property.border_right_width));
            backup.push(this.getPropertyObject(row, col, Property.border_right_color));

        }

        // 保存选中区域的右边列的右边列的左边框
        col++;
        if (col < Sheet.getColumnPropertyManage().getColumnCount())
        {

            for (row = range.startRow; row <= range.endRow; row++)
            {
                backup.push(this.getPropertyObject(row, col, Property.border_left_style));

            }
        }
    },

    SaveTop: function (range, backup) {
        var row, col;

        // 保存选中区域的上边列的上边框
        row = range.startRow;
        for (col = range.startCol; col <= range.endCol; col++)
        {

            backup.push(this.getPropertyObject(row, col, Property.border_top_style));
            backup.push(this.getPropertyObject(row, col, Property.border_top_width));
            backup.push(this.getPropertyObject(row, col, Property.border_top_color));

        }

        // 保存选中区域的上边列的上边列的下边框
        row--;
        if (row >= 0)
        {

            for (col = range.startCol; col <= range.endCol; col++)
            {
                backup.push(this.getPropertyObject(row, col, Property.border_bottom_style));

            }
        }

    },

    SaveBottom: function (range, backup) {
        var row, col;
        // 保存选中区域的下边列的下边框
        row = range.endRow;
        for (col = range.startCol; col <= range.endCol; col++)
        {

            backup.push(this.getPropertyObject(row, col, Property.border_bottom_style));
            backup.push(this.getPropertyObject(row, col, Property.border_bottom_width));
            backup.push(this.getPropertyObject(row, col, Property.border_bottom_color));

        }

        // 保存选中区域的下边列的下边列的上边框
        row++;
        if (row < Sheet.getRowPropertyManage().getRowCount())
        {

            for (col = range.startCol; col <= range.endCol; col++)
            {
                backup.push(this.getPropertyObject(row, col, Property.border_top_style));

            }
        }

    },

    SaveInnerV: function (range, backup) {
        var row, col;

        // 保存选中区域的内部除最后一列的右边界，除最左一列的右边界
        var startRow = range.startRow;
        var endRow = range.endRow;
        var startCol = range.startCol;
        var endCol = range.endCol;
        for (row = startRow; row <= endRow; row++)
        {
            for (col = startCol; col <= endCol; col++)
            {
                if (col != endCol)
                {
                    backup.push(this.getPropertyObject(row, col, Property.border_right_style));
                    backup.push(this.getPropertyObject(row, col, Property.border_right_width));
                    backup.push(this.getPropertyObject(row, col, Property.border_right_color));
                }

                if (col != startCol)
                {
                    backup.push(this.getPropertyObject(row, col, Property.border_left_style));
                }
            }
        }

    },

    SaveInnerH: function (range, backup) {
        var row, col;

        // 保存选中区域的内部除最后一行的下边界，除最上一行的下边界
        var startRow = range.startRow;
        var endRow = range.endRow;
        var startCol = range.startCol;
        var endCol = range.endCol;
        for (row = startRow; row <= endRow; row++)
        {
            for (col = startCol; col <= endCol; col++)
            {
                if (row != endRow)
                {
                    backup.push(this.getPropertyObject(row, col, Property.border_bottom_style));
                    backup.push(this.getPropertyObject(row, col, Property.border_bottom_width));
                    backup.push(this.getPropertyObject(row, col, Property.border_bottom_color));
                }

                if (row != startRow)
                {
                    backup.push(this.getPropertyObject(row, col, Property.border_top_style));
                }
            }
        }

    },

    // 某个属性的配置保存到一个CommandScene中
    getPropertyObject: function (row, col, propertyName) {
        var cell = this.Sheet.createCell(row, col);
        var cs = new Property;
        cs.put("row", row);
        cs.put("col", col);
        cs.put("propertyname", propertyName);
        cs.put("propertyvalue", cell.getPropertyValue(propertyName));
        return cs;
    }

});


export default CMD_SetRangeBorder;
