/**
 * Created by 三宝爹 on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetHeightBetweenTwoRow = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var /*RowPropertyManage*/ RPM = this.Sheet.getRowPropertyManage();

        var row1 = Scene.get("row1", 0);
        var row2 = Scene.get("row2", 0);

        this.Scene.put("oldheight1", RPM.getRowHeight(row1));
        this.Scene.put("oldheight2", RPM.getRowHeight(row2));

    },

    $execute: function () {
        var row1 = this.Scene.get("row1", 0);
        var row2 = this.Scene.get("row2", 0);

        var delta = this.Scene.get("delta", 0);
        this.Sheet.$setHeightBetweenTwoRow(row1, row2, delta);

        return true;

    },

    $undo: function () {
        var row1 = this.Scene.get("row1", 0);
        var row2 = this.Scene.get("row2", 0);

        var oldHeight1 = this.Scene.get("oldheight1", 0);
        var oldHeight2 = this.Scene.get("oldheight2", 0);

        this.Sheet.$setRowHeight(row1, oldHeight1);
        this.Sheet.$setRowHeight(row2, oldHeight2);
        return true;

    }

});


export default CMD_SetHeightBetweenTwoRow;
