/**
 * Created by 三宝爹 on 2017/7/16.
 */


import Command from './Command.js';
import ClipBoard from '../core/ClipBoard.js';
import Property from '../core/Property.js';

var CMD_Paste = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        var startRow = this.Scene.get("startrow", 0);
        var startCol = this.Scene.get("startcol", 0);

        var r = this.Scene.get("range", null);

        //确保不要超界
        var endRow = Math.min(startRow + (r.endRow - r.startRow), this.Sheet.rowCount - 1);
        var endCol = Math.min(startCol + (r.endCol - r.startCol), this.Sheet.columnCount - 1);

        var r2 = new Range(startRow, startCol, endRow, endCol);
        // 把需要恢复的区域范围保存起来
        this.Scene.put("restorerange", r2);
        // 把旧的内容保存到起来
        ClipBoard.saveCellRangeToScene(this.Sheet, r2, this.Scene);
    },

    $execute: function () {
        var startRow = this.Scene.get("startrow", 0);
        var startCol = this.Scene.get("startcol", 0);

        var /*Range*/ r = this.Scene.get("range");
        // 取得内容
        var source = this.Scene.get("source", null);
        var withSize = this.Scene.get("withsize", false);


        var isCut = this.Scene.get("action", ClipBoard.COPY) == ClipBoard.CUT;

        if (isCut)
        {
            var /*ClipBoard*/ CB = this.Sheet.Book.getClipBoard();
            // 有可能在做了剪切后，一直没有做Paste，之后剪贴板又可能失效了
            if (CB != null)
            {
                var /*WorkSheet*/  sourceSheet = this.Sheet.Book.getClipBoard().Sheet;
                if (sourceSheet != null) // 如果这个Sheet还在（比如没有被删除),那么清除它的内容
                {
                    var nullScene = new Property();
                    ClipBoard.restoreCellRangeFromScene(sourceSheet, r.startRow, r.startCol, nullScene, r, false);
                    this.repaint(sourceSheet, r);
                }
            }
        }

        //把保存在 source  中的位置由 r描述的内容复制到Sheet 的从 startRow, startCol 开始的单元区域中
        //如果是复制粘贴，那么别名不复制，如果是cut & paste 那么新区域别名也要带上，被cut的单元格别名也清除
        ClipBoard.restoreCellRangeFromScene(this.Sheet, startRow, startCol, source, r, isCut, withSize);


        this.repaint(this.Sheet, this.Scene.get("restorerange", null));


        return true;

    },

    repaint: function (sheet, r) {
        if (sheet == null) return;
        var /*WorkSheetView*/ view = sheet.getWorkSheetView();
        view.repaint();

        // var /*Rectangle*/ invalidRc = view.getRectangleOfRange(false, r);
        //view.repaint(invalidRc.x - 5, invalidRc.y - 5, invalidRc.width + 10, invalidRc.height + 10);
    },

    $undo: function () {
        // 直接从Scene中取出要恢复的区域
        var startRow = this.Scene.get("startrow", 0);
        var startCol = this.Scene.get("startcol", 0);
        var /*Range*/ r = this.Scene.get("restorerange", null);
        ClipBoard.restoreCellRangeFromScene(this.Sheet, startRow, startCol, this.Scene, r, true);
        this.repaint(Sheet, r);

        //如果是Cut那么还原原先的范围
        if (this.Scene.get("action", ClipBoard.COPY) == ClipBoard.CUT)
        {
            var /*ClipBoard*/ CB = this.Sheet.Book.getClipBoard();
            // 有可能在做了剪切后，一直没有做Paste，之后剪贴板又可能失效了
            if (CB != null)
            {
                var sourceSheet = this.Sheet.Book.getClipBoard().Sheet;
                if (sourceSheet != null) // 如果这个Sheet还在（比如没有被删除),那么清除它的内容
                {
                    //取得内容
                    var source = this.Scene.get("source", null);
                    r = this.Scene.get("range", null);
                    ClipBoard.restoreCellRangeFromScene(sourceSheet, r.getStartRow(), r.getStartCol(), source, r, true);
                    this.repaint(sourceSheet, r);
                }
            }

        }

        return true;
    }


});

export default CMD_Paste;
