/**
 * 合并单元格
 * Created by zengjun on 2017/5/4.
 */


import Command from './Command.js';


var CMD_Merge = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        // 没有什么需要做的
    },

    $execute: function () {
        var startRow = this.Scene.get("startrow", 0);
        var startCol = this.Scene.get("startcol", 0);
        var endRow = this.Scene.get("endrow", 0);
        var endCol = this.Scene.get("endcol", 0);
        return this.Sheet.$merge(startRow, startCol, endRow, endCol);

    },

    $undo: function () {
        var startRow = this.Scene.get("startrow", 0);
        var startCol = this.Scene.get("startcol", 0);
        var endRow = this.Scene.get("endrow", 0);
        var endCol = this.Scene.get("endcol", 0);
        return this.Sheet.$unMerge(startRow, startCol, endRow, endCol);

    }


});

export default CMD_Merge ;
