/**
 * Created by 三宝爹 on 2017/7/14.
 */


import Command from './Command.js';

import RedefineBecause from '../core/RedefineBecause.js';
import ColumnPropertyManage from '../core/ColumnPropertyManage.js';


var CMD_DeleteMultiColumn = Command.extend({

    static: {


//	把数据保存到Scene中
        SaveScene: function (Scene, Sheet, startCol, endCol) {
            var CPM = Sheet.getColumnPropertyManage();
            // 把将要删除的数据列保存起来,还有列宽也保存起来
            for (var i = startCol; i <= endCol; i++)
            {
                var r = Sheet.getColumn(i);
                Scene.put("col:" + i, r);
                Scene.put("cp:" + i, CPM.getColumnWidth(i));
            }
        },

        // 从Scene 中还原数据
        RestoreData: function (Scene, Sheet, startCol, endCol) {

            var CPM = Sheet.getColumnPropertyManage();

            for (var i = startCol; i <= endCol; i++)
            {

                var r = Scene.get("col:" + i);
                Sheet.$setColumn(i, r);

                var w = Scene.get("cp:" + i, ColumnPropertyManage.defaultColumnWidth);
                CPM.setColumnWidth(i, w);

            }
        }

    },
    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    }
    ,

    $saveScene: function () {

        var startCol = Scene.get("startcol", 0);
        var endCol = Scene.get("endcol", 0);
        this.Clas$.SaveScene(Scene, Sheet, startCol, endCol);

    }
    ,

    $execute: function () {

        var startCol = this.Scene.get("startcol", 0);
        var endCol = this.Scene.get("endcol", 0);
        var ret = this.Sheet.$deleteMultiColumn(startCol, endCol);
        // 自动更新公式
        var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseDeleteColumn, 0, startCol, 0, endCol);
        this.Sheet.Book.RebuildAllDefine(this.Sheet, why);


        return ret;
    }
    ,

    $undo: function () {
        var startCol = this.Scene.get("startcol", 0);
        var endCol = this.Scene.get("endcol", 0);
        this.Sheet.$insertMultiColumn(startCol, endCol);

        this.Clas$.RestoreData(this.Scene, this.Sheet, startCol, endCol);

        var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseInsertColumn, 0, startCol, 0, endCol);
        // 自动更新公式
        this.Sheet.Book.RebuildAllDefine(this.Sheet, why);

        return true;
    }


});

export default CMD_DeleteMultiColumn;
