/**
 * Created by 三宝爹 on 2020/04/07.
 *
 *
 * 这是一个集成的上传图片的组件，用于选择图片上传。用到了gridly 对缩略图做排列显示，以及拖拽排序
 *
 * 通过 config.action = 'new','edit','view' 来控制上传动作。当action=='view'时，只读，不允许上传及删除
 *
 * 删除前触发事件用来控制删除权限。上传所需要的参数配置与 全局的 uploadFile 函数参数一至，需要配合formEngine才能工作
 *
 * 实现细节描述
 *
 * 1 默认的上传文件INPUT太丑，解决办法是，临时创建一个 input ,并模拟触发它的click，弹出选择文件，选择后，它的change
 *   事件被触发 ，因此在change事件中，直接触发上传
 *
 * 2 根据 action ,最所有图片最后面增加一个 [+] 触发新的上传
 *
 * 3 所有图片 ，以及 [+] 组成一组 gridly ,可以拖动排序 ，注意，可能[+]在拖动后不在最后面，解决办法就是先删除这个按钮，再增加这个按钮
 *
 * 4 根据action ，在图片右上角显示 删除按钮
 *
 * 5 点击图片，弹出，浏览该组大图 ， 然而，居然，没有找到方法获取当前的图片顺序列表。最后只好，按坐标进行比较排序
 *
 *
 * 2020.05.08增加自动加载图片的支持，实现原理是传入一个函数名，执行这个函数，返回值就是所需要的图片信息
 * 在 formEngine中增加一个默认的根据配置返回图片清单的函数，这样，基本上0开发就可以实现所有功能
 *
 *
 *
 */


import HTMLBrick from './HTMLBrick.js';
import Util from '../util/Util.js';
import Gridly from '../base/jquery.gridly.js'; //只需要导入，它会自已注入到jquery中
import Tools from '../util/Tools.js';
import ImageUtil from '../util/ImageUtil.js'
import uploadDemoData from '../util/UploadDemoData.js';
import Property from "../core/Property.js";


//根据坐标来排序
function compare(img1, img2)
{
    if (img1.y > img2.y) return 1;
    if (img1.y < img2.y) return -1;

    if (img1.x > img2.x) return 1;
    return -1;
}


var UploadBrick = HTMLBrick.extend({

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        console.info("upload init ");
        this.type = 'uploadImage';


        //所有的参数理论上都可以用公式来定义 ， 以=开头即表示是公式，
        //但这样，就需要在使用参数前，每次都 parseConfig()才行， 现在没有这个需求，等需要时再扩展
        this.config = Util.merge(this.config, {
                gutter: 10, //图块间隔
                columns: 3, // 一行显示几个图块
                blockSize: 64, //生成的缩略图大小
                action: '=currentAction()',
                maxCount: 3, //最多允许上传几张图
                homeURL: "",
                imgMaxSize:1920,

                //上传选项
                serverIndex: 1, //上传到哪个文件服务器

                dbpool: '', //上传结果保存到哪个连接池
                logTable: 'app_fileupload', //上传结果保存到哪个表
                tableName: '=currentMasterTableName()',   // 数据相关的表名称
                path: '=currentMasterTableName()',
                gguid: '=currentGUID()',
                autoLoad: false
            },
            false //表示不要用默认值覆盖传入的值，仅当没有设置某参数时，才使用用缺省参数
        );


        //参数规整一下类型
        this.config.gutter = parseInt(this.config.gutter);
        this.config.blockSize = parseInt(this.config.blockSize);
        this.config.columns = parseInt(this.config.columns);

        this.config.maxCount = parseInt(this.config.maxCount);
        this.config.imgMaxSize = parseInt(this.config.imgMaxSize);
        this.config.maxThumbnailSize = this.config.blockSize ; // 上传缩略图的大小


    },

    //在自已加入到单元格后， 本事件触发
    bind: function () {

        var that = this;

        if (!this.pSheet.designMode)
        {
            console.info("autoLoad uploaded image");
            if (this.config.autoLoad && this.config.autoLoadFunction != '')
            {
                // 通过事件簇的方式增加一个 formOpen 响应函数，formOpen之后执行的响应函数
                window['formOpen$loadImage' + (new Date()).getTime()] = function () {
                    try
                    {
                        //得到数据来源函数，并执行它，
                        //把当前的配置做参数代入，注意，需要临时再解析一下， 因为此时的公式值可能变化了
                        // 比如 单据翻到下一张后， currentGUID()就变化了，所以需要再解析一下
                        // 因为本响应是在flowOpen后执行，所以相关的一些与单据有关的数据，都已经初始化完成了
                        let func = window[that.config.autoLoadFunction];
                        if (func)
                        {
                            func(that.parseConfig(), function (ret) {
                                if (ret.success) that.buildGridly(ret.data);
                            });
                        }

                    } catch (err)
                    {
                        alert("图片上传控件加载图片异常：" + err);
                    }
                }
            }
        }

    },

    getAction: function () {

        console.info(" upload image  action:" + this.config.action);
        return this.getConfig("action").toLowerCase();

    },

    getConfig: function (propName) {
        let t = this.config[propName];
        if (t == undefined) return "";
        if (typeof (t) != 'string') return t;

        t = t.trim();

        if (t.startsWith("="))
        {
            t = t.substring(1);

            let ret = this.pSheet.evaluate(t);

            if (ret == null) ret = "";
            return ret;
        } else
        {
            return t;
        }

    },

    /**
     * this.config 中不少属性是公式，本函数就是负责把它们解析成数据
     */
    parseConfig: function () {
        var ret = {};
        for (var p in this.config)
        {
            ret[p] = this.getConfig(p);
        }
        return ret;
    },

    paint: function (/*boolean */isPrint  /*int*/, /*Graphics2D*/ g, /*Rectangle*/ parentRC) {

        if (!this.Visible) return;

        if (this.dom == null) return;


        var rc = this.getBounds(parentRC);

        this.dom.css("position", "absolute");

        this.dom.css("left", rc.x + "px");
        this.dom.css("top", rc.y + "px");
        this.dom.css("width", rc.width + "px");
        this.dom.css("height", rc.height + "px");
        this.dom.css("overflow", "hidden");

        if (this.lastWidth == undefined)
        {
            this.lastWidth = rc.width;
            return;
        }

        //当单元格需要重绘时，echart并不一定需要重绘，仅当size变化时，才需要重绘
        if (this.lastWidth != rc.width)
        {
            this.lastWidth = rc.width;
            this.rebuildGridly();
        }


    },


    createDOM: function () {

        this.domID = this.DOMName + Tools.newGUID();
        this.gridlyID = 'gridly_' + this.domID;

        var html = `<div><div id='${this.domID}' style='width:100%;height:100%;background-color: transparent;'></div></div>`;

        this.config.html = html;//是为了下面授createDOM


        this.$uper.createDOM.call(this);


        this.buildGridly([]);

    },

    //构建内容
    buildGridly: function (data) {

        console.info("初始化 gridly ");

        this.justBuilding = true;
        //创建CSS，因为这些小块的尺寸是通过参数传入的，而不是预先定好了
        if (!this.dom) this.createDOM();

        $(`#${this.domID}`).html(''); //清空旧的内容

        let that = this;

        let w = this.pCell.getBounds().width;

        //在手机上，默认是resize图块大小， 在PC上， 默认是 resize 列数
        if (Tools.isMobile())
        {

            //(b )*n + (n-1)*10 = w;
            //  b= (w - (n-1)*10 )/ n  ;
            //gutter 是块间间隔 ，  columns是每行显示块数
            //visualBlockSize  是每个块的视觉宽度
            this.visualBlockSize = Math.floor((w - (this.config.columns - 1) * this.config.gutter ) / this.config.columns);

        } else //在PC上， 图块大小保持不变，自动设置列数
        {
            // n = ( w+g)/(b+g);
            this.visualBlockSize = this.config.blockSize;
            this.config.columns = Math.floor((w + this.config.gutter) / ( this.config.blockSize + this.config.gutter));
        }

        let visualBlockSize = this.visualBlockSize;


        let t = `
            <style>
                #${this.gridlyID} { }  
                #${this.gridlyID} .gridly_brick{
                        width: ${visualBlockSize}px;
                        height: ${visualBlockSize}px;
                        background-color:transparent;
                        
                        }       
                
                #${this.gridlyID} .gridly_brick  .brickInner{
                        position:absolute;
                        left:10px; top:10px; right:10px;  bottom:10px;
                         width:${visualBlockSize - 22}px;
                        height:${visualBlockSize - 22}px;
                        border:1px  solid  lightgray; cursor:pointer;
                        font-size:2em;  color:#606060;  overflow:hidden;
                        /*flex 布局*/
                        display: flex;
                        /*实现垂直居中*/
                        align-items: center;
                        /*实现水平居中*/
                        justify-content: center;
                        
                        
                        
                }
                
                #${this.gridlyID} .gridly_brick  .brickInner img{
                    
                       max-width:${visualBlockSize - 22}px;
                       max-height:${visualBlockSize - 22}px;
                       
                    }
                    
                 #${this.gridlyID} .gridly_brick  .brickInner  .imageUploading
                 {
                        
                        position:absolute; left:0; bottom:0; width:100%; height:100%;
                        color:white; font-size:0.9em;
                        /*flex 布局*/
                        display: flex;
                        /*实现垂直居中*/
                        align-items: center;
                        /*实现水平居中*/
                        justify-content: center;
                 }
                  #${this.gridlyID} .gridly_brick  .brickInner  .uploadingProgress
                 {
                        
                        position:absolute; left:0; bottom:0; width:100%; height:100%;
                        color:white; font-size:0.5em;
                        /*flex 布局*/
                        display: flex;
                        /*实现垂直居中*/
                        align-items: center;
                        /*实现水平居中*/
                        justify-content: center;
                 }
                    
                
                 #${this.gridlyID} .gridly_brick .deleteButton{
                        position:absolute;
                        top:5px; right:5px; width:20px; height:20px; 
                        cursor:pointer;
                        font-size:1.3em;
                        /*flex 布局*/
                        display: flex;
                        /*实现垂直居中*/
                        align-items: center;
                        /*实现水平居中*/
                        justify-content: center;
            
            </style>
            
            <div id="${this.gridlyID}">
              
            </div>
            `;

        $('#' + this.domID).html(''); //清除旧的

        $(t).appendTo($('#' + this.domID));

        //按data构建brick

        for (let i = 0; i < data.length; i++)
        {
            this.addImage(data[i]);
        }


        let gridly = $(`#${this.gridlyID}`);

        let action = this.getAction();

        if (action == 'new' || action == 'edit')
        {
            if (data.length < this.config.maxCount) this.insertNewButton();
        }
        //如果没有图片，且是只读，那么显示一个无的占位符
        if (action == 'view' && gridly.find('.gridly_brick .brickImage').length == 0)
        {
            this.insertNullButton();
        }

        gridly.gridly({
            base: visualBlockSize, // px
            gutter: this.config.gutter, // px
            columns: this.config.columns,
            callbacks: {
                reordering: function (objs) {
                    that.lastIDS = that.getIDS(objs);

                },
                reordered: function (objs, dragged) {

                    that.justDragged = false;
                    //如果有拖动，那么dragged 记录了当前被拖动的对象，否则就是undefined
                    if (dragged == undefined) return;

                    //如果点击 uploadNewImage，也会进入到这里来，那么它通常不会拖动，就视为点击
                    //必须这么做，因为下面把它删除，又加上，然后原来的点击事件在删除对象时也失效了， 这样它永远无法触发点击事件

                    if (dragged.find('.uploadNewImage').length > 0)
                    {

                        return;
                    }

                    that.justDragged = true;

                    let ids = that.getIDS(objs);

                    //可能新增上传的按钮被拖到中间去了， 把它删除一下，重新再加上
                    if (that.removeNewButton())
                    {
                        that.insertNewButton();
                        gridly.gridly('layout');
                    }

                    if (that.lastIDS.join('') != ids.join(''))
                    {
                        that.pSheet.Book.EM.fire("attachmentOrderChanged", [that.pSheet, that.config, ids]);
                    }
                }
            }
        });


        this.autoSetRowHeight();
        this.showOrHideWithWorkSheet();//不加可能会隐藏起来，原因不想找了
        this.justBuilding = false;

    },

    rebuildGridly: function () {
        if (this.justBuilding) return;

        console.info(" rebuild gridly");
        var imgs = this.getCurrentSortedImageList();


        this.buildGridly(imgs);
    },

    /**
     * 把  data 数据 生成一个图片占位符，显示缩略图，并根据  action 控制删除
     * @param data
     * @param replaceDom
     */
    addImage: function (data, replaceDom) {
        let that = this;
        let gridly = $(`#${this.gridlyID}`);
        let html = `
                    <div class="brickInner  brickImage" id="${data.id}">
                        <img  class="image" src="${data.url_thumbnail}"  largeImage="${data.url_img}"  >
                    </div>
                    `;

        if (this.getAction() != 'view')
        {
            html += ` <div class="deleteButton" >
                        <span class="fa-stack fa-lg">
                            <i class="fa fa-circle fa-stack-1x" style="color:white;"></i>
                            <i class="fa fa-times-circle fa-stack-1x" style="color:red;"></i>
                        </span>
                      </div>
                    `;
        }


        let cb = replaceDom;
        if (replaceDom == undefined) //如果没有这个参数，那么就是新加一个图片缩略图，如果有提供此参数，就是在此位置替换原内容
        {
            cb = $(` <div class="gridly_brick">${html}</div>`);

            gridly.append(cb);

        } else
        {
            cb.html(html);  //替换内容
        }

        //注册事件
        cb.find('.brickImage').on('click', function () {

            if (that.justDragged) return; //说明这是一个拖拽操作，不要触发click
            //

            var imgs = that.getCurrentSortedImageList();
            var pn = 0;  //当前点击的是第几张图片
            var items = [];
            for (var i = 0; i < imgs.length; i++)
            {
                if (imgs[i].id == data.id)
                {
                    pn = i;
                }
                items.push(imgs[i].url_img);
            }

            //整理成图片浏览所需要的数据格式
            let pb = $.photoBrowser({
                items: items,
                initIndex: pn,
                onOpen: function () {
                    //绝对置顶，所有弹窗都显示都不能阻止
                    $('.weui-photo-browser-modal').css("z-index", 999999999);
                },
                onClose: function () {
                    console.log("photoBrowser onClose");

                }
            });

            pb.open();


        });

        cb.find('.deleteButton').on('click', function () {

            $confirm("提示", "确信要删除吗?", function () {
                let ret = that.pSheet.Book.EM.fire("deleteAttachment",
                    [that.pSheet, that.config.dbpool, that.config.logTable, data], '');

                //如果事件中
                if (ret == null) ret = "";

                if (ret == '') ret = {success: true};  //return; //没有事件响应，直接退出
                if (ret.success)
                {

                    cb.remove();//把自已移除
                    //删除图片后，如果此时没有上传新图片按钮，那么重新把它另上来
                    //之所以没有上传新图片捥，是当前图片数量已经到达最大数量
                    let cb_new = $(`#${that.gridlyID} .gridly_brick .uploadNewImage`);
                    if (cb_new.length == 0) that.insertNewButton();



                } else
                {
                    toastr.error(ret.message);
                }
                gridly.gridly('layout');

            });
        });

    },

    removeNewButton: function () {
        //注意，是要把它的外围容器一并删除，不然会留一个空白
        let cb_new = $(`#${this.gridlyID} .gridly_brick .uploadNewImage`);
        if (cb_new.length == 0) return false;
        $(cb_new[0].parentNode).remove();
        return true;
    }

    ,

    /**
     * 插入一个 +  上传占位符
     */
    insertNewButton: function () {
        let brickHTML = `
                        <div class="gridly_brick">
                            <div class="brickInner  uploadNewImage" >
                                <i class="fa fa-plus"></i>
                            </div>
                        </div>
            
            `;

        let gridly = $(`#${this.gridlyID}`);

        gridly.append($(brickHTML));

        let that = this;
        let cb_new = $(`#${this.gridlyID} .gridly_brick .uploadNewImage`);

        if (!that.pSheet.designMode)
        {
            cb_new.on('click', function () {

                that.uploadNewImage();
            });
        }


    }
    ,

    //
    removeNullButton: function () {
        //注意，是要把它的外围容器一并删除，不然会留一个空白
        let cb = $($(`#${this.gridlyID} .gridly_brick .nullImage`)[0].parentNode);
        cb.remove();
    }
    ,

    /**
     * 插入一个无
     */
    insertNullButton: function () {
        let brickHTML = `
                        <div class="gridly_brick">
                            <div class="brickInner nullImage" >
                                无
                            </div>
                        </div>
            
            `;

        let gridly = $(`#${this.gridlyID}`);

        gridly.append($(brickHTML));

    }
    ,

    /**
     * 自动调整容器单元格的高度
     */
    autoSetRowHeight: function () {

        let that = this;
        let gridly = $(`#${this.gridlyID}`);
        gridly.gridly('layout');

        var thisH = gridly.height();
        if (thisH == 0) thisH = this.visualBlockSize + parseInt(this.config.gutter);

        var h = this.pCell.getBounds().height;

        if (h != thisH)
        {

            if (this.pCell.isMerged())
            {
                if (h < thisH) //合并过，那么仅在区域太小时把它调大 ，只需要把
                {
                    setTimeout(function () {
                        var h0 = that.pSheet.RPM.getRowHeight(that.pCell.rowIndex);
                        that.pSheet.RPM.setRowHeight(that.pCell.rowIndex, h0 + thisH - h);
                    }, 10);
                }
            } else
            {

                setTimeout(function () {
                    that.pSheet.RPM.setRowHeight(that.pCell.rowIndex, thisH);
                }, 10);
            }
        }

        this.showOrHideWithWorkSheet();
        this.invalidate();

    }
    ,

    /**
     * 上传图片文件
     * @param button
     */
    uploadNewImage: function () {
        let that = this;
        let gridly = $(`#${this.gridlyID}`);

        //临时创建一个 file 选择对象
        var selectFile = $(`<input type="file"  
                            style="display:none;"  
                            multiple="multiple"  
                            accept="image/png,image/jpg,image/gif,image/JPEG" />
                        `);
        //必须加入文档中，不然不能触发事件
        selectFile.appendTo($(document.body));

        //模拟点击
        selectFile.click();
        //确认选择文件后，触发上传操作
        selectFile.unbind().change(function (e) {
            that.loadImg(e, selectFile);
        });

    }
    ,

    /**
     *
     * @param e
     * @param selectFile
     */
    loadImg: function (e, selectFile) {
        let that = this;
        let gridly = $(`#${this.gridlyID}`);
        var filePath = selectFile.val();
        var fileFormat = filePath.substring(filePath.lastIndexOf(".")).toLowerCase();
        //检查后缀名
        if (!fileFormat.match(/.png|.gif|.jpg|.jpeg/))
        {
            showError('文件格式必须为：png/jpg/jpeg');
            selectFile.remove(); //删除
            return;
        }
        //获取并记录图片的base64编码


        var files = e.target.files;
        for (let i = 0; i < files.length; i++)
        {

            ImageUtil.photoCompress(files[i], {size: that.config.blockSize}, function (base64) {


                //console.dir(  files[i]);

                // 图片的 base64 格式, 可以直接当成 img 的 src 属性值
                let dataURL = base64;

                that.removeNewButton();

                // 显示图片

                let uploadingCB = $(` 
                       <div class="gridly_brick">
                            <div class="brickInner  brickImage">
                               <img  src='${dataURL}'  onclick="imgDisplay(this)">
                               <div class="imageUploading"><i class="fa fa-circle-o-notch fa-spin fa-2x fa-fw"></i></div>
                               <div class="uploadingProgress">1</div>
                             </div>
         
                       </div>
                         `);

                gridly.append(uploadingCB);

                //如果已经存在的图片数量没有超过允许上传的数量
                let imageCount = gridly.find('.gridly_brick .brickImage').length;
                if (imageCount < that.config.maxCount)
                {

                    that.insertNewButton();
                }

                that.autoSetRowHeight();
                let progressInfo = uploadingCB.find(".uploadingProgress");

                //缩略图显示，已经ok了，下面开始上传

                var url = that.config.homeURL;

                that.config.fileIndex = imageCount ; //图片序号
                let imgMaxSize = that.config.imgMaxSize;
                if (imgMaxSize == undefined) imgMaxSize = 1920;

                if (!url.endsWith("/") && url != '') url = url + "/";
                ImageUtil.uploadFile(url + "UploadFile", files[i],
                    {size: imgMaxSize},  // 压缩选项
                    that.parseConfig(), //直接用这个配置做上传选项，虽然可能属性多了一些，不影响上传
                    {
                        onloadstart: function (evt) {

                            //它是一个属性，不要用 ++;
                            that.pSheet.Book.uploadingCount = that.pSheet.Book.uploadingCount + 1;
                            console.info("=====开始上传");
                        },
                        onprogress: function (evt) {
                            console.dir(evt);
                            let percent = Math.round(evt.loaded / evt.total * 100);
                            //到100%后，还会等一会儿才触发上什完成，所以这里不能到100%
                            progressInfo.html('' + (percent - 1));
                            console.info("=====上传进度 " + Math.round(evt.loaded / evt.total * 100) + "%");
                        },
                        onerror: function (evt) {
                            console.dir(evt);
                            selectFile.remove(); //删除临时的选择文件的input
                            that._uploadSuccess(uploadDemoData, uploadingCB);
                        },

                        onComplete: function (evt) {
                            //  event.total是需要传输的总字节，
                            // event.loaded是已经传输的字节。
                            // 如果event.lengthComputable不为真，则event.total等于0

                            progressInfo.html('100');
                            console.info("=====上传完成");
                            //它是一个属性，不要用 --;
                            that.pSheet.Book.uploadingCount = that.pSheet.Book.uploadingCount - 1;

                            /*
                            var data = evt.target.responseText;
                            data = JSON.parse(data);
*/
                            var data = evt.data;
                            // console.dir(data);

                            selectFile.remove(); //删除临时的选择文件的input
                            //uploadingCB的内容会被真正的图片替换。
                            that._uploadSuccess(data, uploadingCB);
                        }

                    }
                )// end of uploadFile


            });// end of photoCompress


        }//end of for loop
    }
    ,

    _uploadSuccess: function (data, replaceDom) {
        //把显示上传进度的图片替换成上传结果
        this.addImage(data, replaceDom);
    }
    ,


    getIDS: function (bricks) {
        var ids = [];
        for (var i = 0; i < bricks.length; i++)
        {


            var brickImage = $(bricks[i]).find('.brickImage');
            if (brickImage.length > 0) ids.push(brickImage[0].id);
        }
        return ids;
    }
    ,


    /**
     * gridly没有提供获取排序后的对象清单函数，一个办法是在初始化时记录初始状态，在排序后的回调中保存数据
     * 另一个办法就是自已解决：获取所有块，根据坐标计算它们的顺序，下面就是这个思路
     * @returns {Array}
     */
    getCurrentSortedImageList: function () {


        var bricks = [];

        var brickImages = $(`#${this.gridlyID}  .brickImage`);//获取所有划块

        //把它们的坐标获取，然后通过坐标重新对它们进行排序，再取排序后的结果
        for (var i = 0; i < brickImages.length; i++)
        {
            let img = $(brickImages[i]).find('.image')[0];
            bricks.push({
                id: brickImages[i].id,
                url_img: img.getAttribute("largeImage"),
                url_thumbnail: img.getAttribute("src"),
                x: $(brickImages[i]).offset().left,
                y: $(brickImages[i]).offset().top
            });
        }

        bricks = bricks.sort(compare);


        return bricks;
    }
    ,


    //以下是Brick的功能函数
    setVisible: function (v) {
        try
        {
            if (v)
            {
                this.dom.css("display", "");
            } else
            {
                this.dom.css("display", "none");
            }
        } catch (err)
        {
            let that = this;
            setTimeout(function () {
                that.setVisible(v);
            }, 200);
        }
    }
    ,

    showOrHideWithWorkSheet: function () {

        console.info("调整可见性");
        if (this.pSheet.visible && this.visible)
        {
            this.showOrHide(true);
        } else
        {
            this.showOrHide(false);
        }

    }


});


export default UploadBrick;
