/**
 * Created by 三宝爹 on 2017/12/14.
 */


import HTMLBrick from './HTMLBrick.js';
import Tools from '../util/Tools.js';
import Util from '../util/Util.js';

var Tree = HTMLBrick.extend({


    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "tree";

        this.setConfig(config);

    },

    setConfig: function (config) {
        this.config = config;

        if (this.config.x) this.X = this.config.x;
        if (this.config.y) this.Y = this.config.y;
        if (this.config.width) this.Width = this.config.width;
        if (this.config.Height) this.Height = this.config.height;


        if (this.dom != null)
        {
            this.dom.remove();
            this.dom = null;
            this.invalidate();
        }


    },


    setEditStyle: function (es) {
        this.ES = es;
    },

    buildHTML: function () {
        let x = 0;
        let y = 0;


        let guid = Tools.newGUID();
        this.treeGUID = guid;
        this.treeId = 'treePanel_' + this.treeGUID;

        var html = `
            
                            
                <div id=${this.treeId} style="position:absolute;left:0; 
                                            top:0;
                                            width:100%;
                                            height:100%; 
                                            background-color: #efefef;
                                            border:0px solid lightgrey;
                                            -moz-box-shadow:0px 0px 5px gray;
                                            -webkit-box-shadow:0px 0px 5px gray;
                                            box-shadow:0px 0px 3px gray;  ">
                                            
                    <div style=" position:relative; 
                                padding:5px; top:0px; 
                                left:0;height:36px;  
                                width:auto;
                                right:0; 
                                border:0px solid red;
                                overflow: auto; ">
                        <input type="text" id="treeNodeSearch_${guid}"  placeholder="过滤" title="过滤"
                               style="position:absolute; 
                               left:5px; 
                               padding-left:10px;
                               padding-right:10px; 
                               width:auto;
                               right:60px;
                               outline:none; 
                               border-radius: 12px;
                               height:24px;
                               -webkit-appearance:none ;
                               border:1px solid lightgray;"/>
                
                        <button class="btn btn-xs btn-alt themed-color"  
                                style="position:absolute; width:20px;right:40px; top:7px; outline:none; border:0 ;background-color:transparent;"
                                id="cb_refresh_${guid}" title="重新构建树"><i class="fa fa-refresh"></i></button>
                
                
                        <button class="btn btn-xs btn-alt themed-color"  
                                style="position:absolute; width:20px;right:20px; top:7px; outline:none; border:0 ;background-color:transparent;"
                                id="cb_expand_${guid}" title="展开整棵树"><i class="fa fa-folder-open"></i></button>
                
                        <button class="btn btn-xs btn-alt themed-color"  
                                style="position:absolute; width:20px;right:0px; top:7px; outline:none; border:0 ;background-color:transparent;"
                                id="cb_Collapse_${guid}" title="收拢整棵树"><i class="fa fa-folder"></i></button>
                
                      
                        
                
                    </div>
                    <div style=" position:absolute; padding:5px; top:38px; left:0;height:auto; bottom:0px;background-color: white;
                                                        width:auto;right:0; border:0px solid red;overflow: auto;
                                                       ">
                        <div id="tree_${guid}" class="ztree" style="width:100%; "></div>
                    </div>
                </div>
            `;

        return html;


    },

    //当树构建好数据后，会回调通知单元格重绘。以于TreeEdit来说， 是需要的但对TreeBrick就不需要了
    //但是也必须提供这样一个空函数，保持外围代码的一至
    repaint: function () {

    },

    workBookInitOK: function () {
        this.treeRefresh();
    },

    /**
     * 2020.11.12 patch  参看 Cell.notifyChangedToSubscriber函数
     * 如果树中定义了过滤表达式，那么自已将是那个表达式的订阅者，当表达式变化后，
     * 本事件被触发，在此刷新树
     * @param dependCell
     * @param dbRow
     */
    observableChanged:function( dependCell , dbRow)
    {
        console.info("过滤条件变化了，重建树");
        this.treeRefresh();

    },

    createDOM: function () {


        this.$uper.createDOM.call(this);

        var treeName = this.config.treeName;
        var treeSelectMulti = this.config.treeSelectMulti;
        var treeFilterBy = this.config.treeFilterBy;

        let book = this.pSheet.Book;
        let that = this;

        //2020.11.12 patch：下面的 book.setEditStyleTree中需要用到  cell.Sheet
        // this并不是一个真正的Cell，此时必须也给它加上Sheet属性，就样可以以统一的方式进行处理
        this.Sheet= this.pSheet;


        //设置自已编辑格式配置
        //TODO 下面的 setEditStyleTree 会触发事件 getTreeNodes ,它是异步的， 后面的getTreeNodesForEdit
        // 触发的事件是同步的 （参看 formEngine中的 loadTemplate.js中的事件，这导致前面这个异步还没有返回
        // 后面的同步事件又开始执行了，问题倒不大，但是同步会阻塞界面，这个需要优化
        // treeBrick与TreeEdit不一样。 后者的getTreeNodesForEdit 肯定不会在 后面的getTreeNodes前执行。因为初始化时执行后面的getTreeNodes
        //在编辑时才会执行后面的getTreeNodesForEdit

        console.info("初始化树控件");
        book.setEditStyleTree(this, treeName, 0, 0, treeSelectMulti, treeFilterBy);

        if (this.config.treeNodes)
        {
            this.ES.treeNodes = this.config.treeNodes;
            this.ES.treeNodesInited = true;
        }


        if (this.config.visible != undefined)
        {
            this.visible = this.config.visible;
        }
        if (this.config.enable != undefined)
        {
            this.enable = this.config.enable;
        }


        var html = this.buildHTML();

        this.treeDOM = $(html);

        this.treeDOM.appendTo(this.dom);

        var setting = {

            data: {
                key: {
                    title: "t"
                },

                simpleData: {
                    enable: true
                }
            },
            callback: {

                onClick: zTreeOnClick,
                onCheck: zTreeOnCheck
            }
        };

        //如果是多选，那么配置多选属性
        if (this.ES.treeSelectMulti)
        {
            Util.merge(setting,
                {
                    view: {
                        selectedMulti: true
                    },
                    check: {
                        enable: true,
                        chkboxType: {"Y": "ps", "N": "ps"},
                    }
                }, true);

        }


        function zTreeOnClick(event, treeId, treeNode)
        {
            let book = that.pSheet.Book;
            book.EM.fire("treeOnClick", [that.zTreeObj, treeId, treeNode]);
        }


        function zTreeOnCheck(event, treeId, treeNode)
        {
            let book = that.pSheet.Book;
            book.EM.fire("treeOnCheck", [that.zTreeObj, treeId, treeNode]);
        }


        let cell = this.pCell;
        let innerRow = -1;
        let guid = this.treeGUID;

        //得到树的节点数据，
        let zNodes = this.ES.getTreeNodesForEdit(cell, innerRow);


        let zTreeObj = $.fn.zTree.init($(`#tree_${guid}`), setting, zNodes);

        this.zTreeObj = zTreeObj;

        let hiddenNodes = [];	//用于存储被隐藏的结点
        function nodeSearch()
        {
            //显示上次搜索后背隐藏的结点
            zTreeObj.showNodes(hiddenNodes);

            //查找不符合条件的叶子节点
            function filterFunc(node)
            {
                if (node.isParent) return false; //中间节点始终显示
                var _keywords = $(`#treeNodeSearch_${guid}`).val().toLowerCase();
                if (node.name.toLowerCase().indexOf(_keywords) != -1) return false;
                if ('id=' + node.id == _keywords) return false;
                if (node.code) if (node.code.indexOf(_keywords) != -1) return false;

                return true;
            };

            //获取不符合条件的叶子结点
            hiddenNodes = zTreeObj.getNodesByFilter(filterFunc);

            //隐藏不符合条件的叶子结点
            zTreeObj.hideNodes(hiddenNodes);
            zTreeObj.expandAll(true);
        }




        //重建树
        function treeRefresh()
        {
            that.treeRefresh();

        }

        function treeExpand()
        {
            zTreeObj.expandAll(true);
        }

        function treeCollapse()
        {
            zTreeObj.expandAll(false);
        }


        $(`#treeNodeSearch_${guid}`).bind('keyup', nodeSearch);
        $(`#cb_refresh_${guid}`).bind("click", treeRefresh);
        $(`#cb_expand_${guid}`).bind("click", treeExpand);
        $(`#cb_Collapse_${guid}`).bind("click", treeCollapse);

    },

    treeRefresh: function () {
        var that = this;
        this.ES.treeNodesInited = false;


        setTimeout(function () {
            that.dom.remove();
            that.dom = null;
            that.invalidate();

        }, 100);
    },

    treeExpand: function () {
        this.zTreeObj.expandAll(true);
    },

    treeCollapse: function () {
        this.zTreeObj.expandAll(false);
    },


    setEnable: function (v) {
        this.Enable = v;


        if (this.dom)
        {
            $(this.dom).attr("disabled", !v);
        }

    }

});


export default Tree ;
