/**
 * Created by 三宝爹 on 2017/12/14.
 */


import BasicBrick from './BasicBrick.js' ;

var HTMLBrick = BasicBrick.extend({

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "html";

    },

    paint: function (/*boolean */isPrint  /*int*/, /*Graphics2D*/ g, /*Rectangle*/ parentRC) {

        if (this.dom == null) this.createDOM();


        var rc = this.getBounds(parentRC);

        this.dom.css("position", "absolute");

        let x= rc.x;
        let y= rc.y;

        if( this.config.justInTabContainer)
        {
           x=0;
            y=0;
        }

        this.dom.css("left", x + "px");
        this.dom.css("top", y + "px");
        this.dom.css("width", rc.width + "px");
        this.dom.css("height", rc.height + "px");
        this.dom.css("overflow", "hidden");

        this.onSize(rc);

    },

    createDOM: function () {


        var bookView = this.pSheet.Book.View;

        var html = this.config.html;
        if (!html) html = "<div style='width:100%;height:100%;overflow:hidden;'></div>";
        this.dom = bookView.createDOM(this.DOMName, html);

        var container = $(this.pSheet.View.canvas.parentNode);
        this.dom.appendTo(container);

        let that = this;
        this.dom.click(function () {
                if (that.pSheet.designMode)
                {
                    that.pSheet.setSelection(
                        that.pCell.rowIndex, that.pCell.columnIndex,
                        that.pCell.rowIndex, that.pCell.columnIndex);
                }
                this.blur();

            }
        );

        if (this.config.visible != undefined)
        {
            this.visible = this.config.visible;
        }
        if (this.config.enable != undefined)
        {
            this.enable = this.config.enable;
        }

    },

    onSize: function (rc) {

    },

    setVisible: function (v) {

        if (this.dom == null) this.createDOM();

        this.Visible = v;

        this.showOrHide(v);
    },

    showOrHide: function (v) {

        if (this.dom == null) this.createDOM();


        if (v && !this.outofScreen())
        {

            this.dom.css("display", "");
            return;
        } else
        {
            this.dom.css("display", "none");
            return;
        }


    },

    showOrHideWithWorkSheet: function () {

        var v = this.visible;
        this.showOrHide(v);

    }

});


export default HTMLBrick ;
