/**
 * @summary 基类，提供OO支持，
 *
 *
 *  参考 http://www.matrix.org.cn/resource/article/2006-12-26/83dc4e92-94bb-11db-ab77-2bbe780ebfbf.html
 *   上述网页已失效
 *
 * @seealso 参阅 http://cymoft.blog.51cto.com/324099/63422 关于原型的试验
 *
 * 对原型的理解：
 *
 * 可以这么认为：
 * 1  prototype是js中函数(Function)对象的一个属性，它是一个对象，当我们新建一个函数的同时，该函数自动就有了prototype对象，
 * 2  protytype 与C++中类的函数表（function table)概念是类似的。prototype指向一个函数表，当创建一个Function实例时，该实例
 *    也就具有了访问Function的函数表的能力。
 * 3  当修改实例的属性或方法时，并不影响函数定义的函数表，而是为该实例增加了私有的一份属性或方法，如果增加的属性或方法与原型中的属性或
 *    方法同名时，那么优先使用实例自己私有的属性或方法。当实例并不具有指定的属性或方法时，则在原型表中找，如果没有找到，继续在Object的原型
 *    中找，如果还找不到，那么提示未定义的属性或方法
 * 4  js内置对象的(注意是内置对象，自定义的类不存在此限制)prototype属性不能指向另一个对象，但可以修改它，即不能 Array.prototype= new Object()
 *    但可以 Array.prototype.myfunc1=function()...
 * 5  两个类循环引用prototype是允许的，但不建议这么做
 *
 * 我们也可以让这个prototype属性指向其他的对象。它的能力是可以把自己的属性给拥有它的函数的实例使用。

 示例：

 var Man = Class.extend(
 {
     constructor: function (name) {
         this.name = name;
         this.age=5;
         this.code='abc';
     },
     getName: function () {
         return this.name;
     },

     getCode:function()
     {
         return this.code;
     },

     setAge:function(v)
     {
         this.age=v;
     },
     getAge:function()
     {
         return this.age;
     }
 });

 var SuperMan = Man.extend(
 {
     constructor: function (name) {
         this.$uper.constructor(name);  //标记Super1 :不需要用call切换this ,因为 constructor是在 Man的上下文中被自动调用的 this.$uper就是Man.prototype,
         this.type = "super man ";
     }
 });


 var a = new SuperMan("abc");
 a.setAge(20);
 // 标记Super2
 alert(a.getName() + "  " + a.type+"   " + a.$uper.getAge() ); //实际上。它显示的是Man从Class中继承过来的 age=5
 alert(a.getName() + "  " + a.type+"   " + a.$uper.getAge.call(a) ); // 强制切换this指针到a ,所以是20

 //更多的猜想

 1 当在子类中用 this.xxx 增加的新的成员xxx，在父类中，是不能访问的，如果父类函数中要访问，那么需要用 this.$uper.func.call( this, arg....)来
 切换上下文

 2 如果当在子类中用 this.xxx 修改了成员xxx，在父类中，是不能感知修改后的数据的。

 3 记住：数据与函数是分离的。 数据是类自已的， 而函数是类的函数表的，函数执行时，访问的数据是与 this指针相关的，而this指针又是可以切换的

 4 所以子类函数访问的是子类的数据 ， 父类函数访问的是父类的函数。子类初始化时把父类的数据及函数复制了一份。同时又有一个$uper属性指向父类的函数表，
 当通过 this.$uper.func 调用函数时，它的上下文指针（this）是指向父类的，由于第3点的影响，就需要有选择性地使用 this.$uper.func.call(this,arg....)

 5 什么时候需要用 .call (this ..) ，原则是：
 a  如果父类函数中要访问子类中新增加的数据，或修改的数据，就需要切换 this
 b  constructor 函数是在父类上下文中自动执行的，它不应该被其它函数显示地调用，
 在此函数中访问this.$uper.func不需要切换this,因为它们的this实际是同一个，






 */



var Class = function () {
};

//提供缺省的构建函数
Class.prototype.constructor = function () {
};

/**
 * 静态方法
 * @param def
 */
Class.extend = function (def) {
    //首先创建自己的一个实例，这里的this就是当前类本身,但不要狭义地理解为就是Class.
    //当  ClassA.extend (...)时 this就是  ClassA
    var subPrototype = new this(Class); //标记1
    subPrototype.clas$Name = 'Class';


    //把def中的属性全部复制到这个实例中
    for (var n in def)
    {
        var item = def[n];
        subPrototype[n] = item;
    }


    //到这里，subPrototype具有了本类的的有方法，属性，并同时具有了def中定义的方法和属性
    //注意 ，subPrototype具有了我们所需要的子类的特性，但是不能返回它，因为我们要的是一个类的定义，而不是一个类的实例
    //所以新建一个类，把它的原型对象指向subPrototype,下面做的就是这个事情

    // 上面的Class的原型定义中定义了 construct ，这样为每个从Class派生的类都提供了一个名为construct的函数
    // 在新函数的构造函数中调用construct 这样就可以在def 中使用名为construct的函数来提供一个能做初始化的地方
    // 但是注意 ：请在construct中使用  this.$uper.construct()来调用父类的构造函数
    var classDef = function () {  //这里的arguments[0] !== Class与[标记1]处的参数一起作用的结果就是父类的constructor不会被调用，这样
        //就需要在子类的constructor中显示地使用this.$uper.construct()在合适的位置调用父类的初始化函数

        //如果定义了merge属性，那么把它的方法属性全部复制到自己身上，如果已经存在同名的属性或方法，那么忽略它
        //可用于事件接口实现，或函数扩展
        // 用于事件接口：在一个对象中定义事件回调函数，然后merge  此对象，就把事件回调函数全部复制到自已的原型中
        // 用 components 可用于大文件的拆分，比如一个类，函数太多了，那么把一些函数分到一个对象中， 然后通过components
        //把这些函数全部复制过来，实现了具大类在源代码上的拆分。

        if (this['components'] != undefined)
        {

            var imps = this['components'];
            if (imps.constructor != window.Array) imps = [imps]; //如果不是数组，转换成数组
            for (var i = 0, n = imps.length; i < n; i++)
            {
                var extended = imps[i];
                for (var key in extended)
                {
                    if (subPrototype[key]) continue;  //注意是对原型对象操作，而不是this,
                    subPrototype[key] = extended[key];
                }
            }

        }

        //属性读写触发
        if (this['properties'])
        {
            var properties = this['properties'];
            Object.defineProperties(this, properties);
        }


        //把参数代入constructor中模拟构造函数。
        //比如  var Man= Class.extend( {constructor: function(name){this.name=name;} });
        //         var a = new Man("张三");
        //   Man 是Class.extend的返回值，即下面的classDef ,  new Main('张三') 则触发了函数classDef 的执行
        // 即执行到下面， 此时把函数的参数做参数 代入constructor 执行
        // 就实现了 Man('张三') 到  constructor: function(name){this.name=name;}的调用。
        // 所以 上面的constructor 并不是Prototype.constructor，只是名字取成一样，看上去效果也一样，它是在创建new Man
        // 时自动调用执行的，完美地模拟了构造函数
        //
        // 此时的 this.仍是基类，所以在 constructor函数中用this.$uper.constructor调用的就是基类当前的constructor
        // 所以它不需在用 this.$uper.constructor.call( this , aguments) 这样的形式来切换 this指针
        // 但是，类一旦初始化完成后，再调用函数时，被调用的就是子类的函数了，如果在子类中调用$uper.func 就需要用 this.$uper.func.call( this, args);
        // 来切换上下文。
        // 详细请在本类中查找  标记Super1 和 标记Super2来看示例

        if (arguments[0] !== Class)
        {
            this.constructor.apply(this, arguments);
        }

    };

    //支持静态方法
    //当这些静态方法被复制到classDef上时，

    if (def['static'])
    {
        var $tatic = def['static'];
        for (var key in $tatic)
        {
            if (classDef[key]) continue;
            classDef[key] = $tatic[key];
        }
    }


    classDef.prototype = subPrototype; // 原型指向subPrototype
    classDef.prototype.$uper = this.prototype;//增加一个属性$super 用来访问父对象的方法
    //当在constructor中使用$uper时，不需要切换this指针
    //在其它地方调用this.$uper.func时，要用.call(this, arg1, arg.....)来切换this

    classDef.prototype.Clas$ = classDef; //增加一个属性，在类的实例中可以用 Class来访问类的静态成员

    //增加类型的判断
    classDef.prototype.instanceOf = function (klass) {
        if (this.Clas$ == klass) return true;
        if (this.$uper && this.$uper.instanceOf) return this.$uper.instanceOf(klass);
        return false;
    }


    classDef.extend = this.extend;     //赋给这个新的子类同样的静态extend方法
    return classDef;
}


export default Class;
