import Util from "../../util/Util.js";
import Color from "../../gdi/Color.js";
import MouseAdapter from './MouseAdapter.js';

var DateAxis = MouseAdapter.extend(
    {

        constructor: function () {

        },
        //在指定单元格中画出时间轴
        draw: function (cell, /*int*/dbrow, /*Graphics2D*/g, /*Rectangle*/rc, data, /*String*/  s, /*int*/bkMode,
                        /*Color*/bkcolor, /*Color*/textcolor, /*String*/   FontName, /* int*/FontSize,
                        /*boolean*/FontBold, /*boolean*/FontItalic, /*boolean*/FontUnderline,
                        /*int*/hAlign, /*int*/vAlign, /*boolean*/MultiLine, /*boolean*/ noES) {

            var physiology = cell.Book.property.get(data.physiologyName);

            if (physiology == null) return; //当单元格用公式定义时，源可能还没有初始化好，这是允许的

            if (cell.getMouseAdapter('physiology') == undefined)
            {
                cell.addMouseAdapter('physiology', this);
            }

            var view = cell.Sheet.View;
            var lineColor = cell.getSplitLineColor();
            var textRect = rc.clone();
            textRect.width = physiology.dateAxisCellWidth * 3;


            //看看能画多少个小格
            var n = Math.floor(rc.width / physiology.dateAxisCellWidth);
            var tn = Math.floor(n / 3); //每3格画一个时间刻度
            for (let i = 0; i <= tn; i++)
            {
                let x = (physiology.offset + i) * physiology.dateAxisCellWidth * 3;
                let y = rc.y;


                view.addDrawCellBorderLine(view.drawBorderMap, g, 1, 1, lineColor,
                    rc.x + x, y,
                    rc.x + x, y + rc.height, 'dataAxis');

                //画时间点
                let d = physiology.startTime.clone();
                d.add('m', (physiology.offset + i) * physiology.timeStep * 3);
                let t = d.Format('HH:mm');

                textRect.x = rc.x + x + 2;

                g.drawStringSingleRow(textRect, t, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold,
                    FontItalic, FontUnderline, hAlign, vAlign);


            }

        }
    });
export default DateAxis;
