/**
 * Created by zengjun on 2017/5/30.
 */

const Koa = require('koa');
const Router = require('koa-router');
const convert = require('koa-convert');
const cors = require('koa-cors');

const app = new Koa();
const bodyParser = require('koa-bodyparser');


app.use(convert(cors()));//解决跨域访问的安全限制


// 使用ctx.body解析中间件
app.use(bodyParser());

var router = new Router();


router.get('/', function (ctx, next)
{
    ctx.body = "hello  , home";
});


router.get('/select', async (ctx, next) =>
{
    let html = await testQuery("");
    ctx.body = html;
})
;

router.post('/post', function (ctx, next)
{
    ctx.body = JSON.stringify(ctx.request.body);
});

/**
 * 基于sql 复制字段信息
 */
router.post('/DataStore/newDataStore', async (ctx, next) =>
{
    let dsn = ctx.request.body.dsn;
    let select = ctx.request.body.select;
    const dp = require("./dataprovider");
    let ret = await dp.newDataStore(dsn, select);
    ctx.body = JSON.stringify(ret);
});

/**
 * 检索数据
 */
router.post('/DataStore/retrieve', async (ctx, next) =>
{
    let dsn = ctx.request.body.dsn;
    let select = ctx.request.body.select;
    let  onceRetrieveCount=ctx.request.body.onceRetrieveCount;
    let   absolute= ctx.request.body.absolute;

    const dp = require("./dataprovider");
    let ret = await dp.retrieve(dsn, select, onceRetrieveCount, absolute);
    ctx.body = JSON.stringify(ret);
});




app.use(router.routes()).use(router.allowedMethods());


function testQuery(sql)
{

    var mysql = require('mysql');
    var pool = mysql.createPool({
        host: 'localhost',
        user: 'root',
        password: 'root',
        database: 'test'
    });

    return new Promise(function (resolve, reject)
    {

        pool.getConnection(function (err, con)
        {
            if (err)
            {
                reject(err);
                return;
            }


            con.query(
                'SELECT * FROM  news_user where id<180',
                function (err, results, fields)
                {
                    if (err)
                    {
                        reject(err);
                    }
                    else if (results)
                    {
                        var s = [];
                        for (var i = 0; i < results.length; i++)
                        {
                            s.push("id=" + results[i].id + '\tname=' + results[i].name + '\tage=' + results[i].age);
                        }

                        resolve(s.join('<br>'));
                    }
                    con.release();

                });
        });


    });


}


app.listen(3000)
console.log('[demo] request post is starting at port 3000')
