/**
 * Created by 三宝爹 on 2017/10/13.
 */


import Class from '../base/Class.js';
import ActionTool from './ActionTool.js';
import DrawShape from './DrawShape.js';

import Point from '../gdi/Point.js';

import Tools from '../util/Tools.js';

var DrawTool = ActionTool.extend({

    static:
        {
            c_tools: [],

            /*Point*/ c_down: null,
            c_nDownFlags: 0,
            /*Point*/ c_last: null,
            c_drawShape: DrawShape._selection_,

            /*Glyph*/ c_LastObject: null,
            c_LastRow: -1,

            /*Glyph*/ c_MouseDownObject: null,
            c_MouseDownRow: -1,
            /*Glyph*/ c_MouseUpObject: null,
            /*int*/ c_MouseUpRow: -1,
            /*boolean*/  c_IsDraging: false, // 通常在MouseMove中进行工具的切换，此标记是有用的

            FindTool: function (/*int*/ DrawShape) {
                var /*DrawTool*/ tool;
                for (var i = 0; i < DrawTool.c_tools.length; i++)
                {
                    tool = DrawTool.c_tools[i];
                    if (tool.m_drawShape == DrawShape) return tool;
                }
                return null;
            },

            CurrentTool: function () {
                var tool;
                for (var /*int*/ i = 0; i < DrawTool.c_tools.length; i++)
                {
                    tool = DrawTool.c_tools[i];
                    if (tool.m_drawShape == DrawTool.c_drawShape) return tool;
                }
                return null;
            }
        },

    constructor: function (DrawShape) {

        this.m_mousestate = 0;
        this.m_drawShape = DrawShape;
        this.guid = Tools.newGUID();


    },


    // 子类需要是最开始调用
    OnLButtonDown: function (/*WorkSheetView*/  pView, /*MouseEvent*/  e) {
        /*
         * 增加 pView->SetFocus() , 表示点击后将焦点设置到view上， 如果单元格处于编辑状态，该函数将触发单元格编辑窗口的OnKillFocus事件
         * 值得注意的是，如果没有pView->SetFocus()， 单元格编辑窗口的OnKillFocus事件 不会触发
         */

        //这样将导致　endEdit 先触发，然后是新单元格的beginEdit
        //这与用回车进行单元格编辑跳转引发的事件顺序是不一样的
        pView.forceCurrentEditControlGiveUpFocus();

        pView.requestFocusInWindow();
        DrawTool.c_down = new Point(e.offsetX, e.offsetY);
        DrawTool.c_last = new Point(e.offsetX, e.offsetY);
        //可能是开始拖拽
        DrawTool.c_IsDraging = true;

    },

    OnLButtonClick: function (/*WorkSheetView*/ pView, /*MouseEvent*/e) {
        pView.forceCurrentEditControlGiveUpFocus();

    },

    OnLButtonDblClk: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {

    },

    //子类必须显示的调用本方法
    OnLButtonUp: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {
        DrawTool.c_IsDraging = false;

    },

    OnMouseMove: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {
        DrawTool.c_last = new Point(e.offsetX, e.offsetY)

    },

    //子类必须显示的调用本方法 ，且必须是在最后调用,不然过早的设置了 c_last 是不对的
    OnMouseDrag: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {
        DrawTool.c_last = new Point(e.offsetX, e.offsetY);
        DrawTool.c_IsDraging = true;
    },

    OnRButtonDown: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {
    },

    OnMouseEntered: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {

    },

    OnMouseExited: function (/*WorkSheetView*/pView, /*MouseEvent*/e) {

    },

    keyPressed: function (/*WorkSheetView*/pView, /*KeyEvent*/     e) {

    },

    keyReleased: function (/*WorkSheetView*/pView, /*KeyEvent*/    e) {

    }


});

export default DrawTool ;
