/**
 * Created by 三宝爹
 *
 * 对插件进行处理的函数
 *
 */


import FU from './FuncUtil.js';
import AJAX from '../../util/ajax.js';
import DataArea from '../../plugin/physiology/DataArea.js';
import DateAxis from '../../plugin/physiology/DateAxis.js';
import YAxis_C from '../../plugin/physiology/YAxis_C.js';
import YAxis_mmHg from '../../plugin/physiology/YAxis_mmHg.js';
import DataLine from '../../plugin/physiology/DataLine.js';
import SignArea from '../../plugin/physiology/SignArea.js';


var $rpc = AJAX.rpc;

var pluginMap = {
    "DataArea": new DataArea(),
    "DateAxis": new DateAxis(),
    "YAxis_C": new YAxis_C(),
    "YAxis_mmHg": new YAxis_mmHg(),
    "DataLine": new DataLine(),
    "SignArea": new SignArea()
};

var  PluginFunc = {


    plugin: function (pluginAction, param) {
        return {plugin: pluginAction, param: param};
    },

    physiology: function (physiologyName, type, param, zbid) {
        if (zbid == undefined) zbid = '';
        var plugin = pluginMap[type];
        if (plugin == undefined) return null;
        return {physiologyName: physiologyName, plugin: pluginMap[type], param: param, zbid: zbid};
    }


};

export default PluginFunc ;

