/**
 * Created by 三宝爹
 *
 * 运行符对应的函数
 *
 * 2018.11.19 对四则运行+ - * / 用 MATH中的函数来解决js中小数计算精度的问题
 *
 */


import FU from './FuncUtil.js';

import MATH from './MathFunc.js';

var  OperatorFunc = {

    /**
     * 大于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _gt_: function (p1, p2) {
        if (p1==null) return false;
        if (p2==null) return true;
        return p1 > p2;

    },

    /**
     * 小于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */

    _lt_: function (p1, p2) {
        if (p1==null) return true;
        if (p2==null) return false;
        return p1 < p2;

    },

    /**
     * 等于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _eq_: function (p1, p2) {
       // console.info(" equal 判断 " +p1+","+p2);
        if( p1==null && p2==null) return true;
        if (p1==null) return false;
        if (p2==null) return false;
        return p1 == p2;

    },
    /**
     * 大于等于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _ge_: function (p1, p2) {
        if( p1==null && p2==null) return true;
        if (p1==null) return false;
        if (p2==null) return true;
        return p1 >= p2;

    },
    /**
     * 小于等于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _le_: function (p1, p2) {
        if( p1==null && p2==null) return true;
        if (p1==null) return true;
        if (p2==null) return false;
        return p1 <= p2;

    },
    /**
     * 不等于
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */

    _ne_: function (p1, p2) {
        if( p1==null && p2==null) return false;
        if (p1==null) return true;
        if (p2==null) return true;
        return p1 != p2;

    },
    /**
     * 并且运算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _and_: function (p1, p2) {
        if (p1==null) return false;
        if (p2==null) return false;
        return p1 && p2;
    },
    /**
     * 或者运算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _or_: function (p1, p2) {
        if (p1==null && p2==null) return null;
        if (p1) return true;
        if (p2) return true;
        return p1 || p2;

    },


    /**
     * 加法运算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _plus_: function (p1, p2) {
        //不要用if(!p1)  因为 p1=0 时，  if(!p1)成立
        if (p1 == undefined) return p2;
        if (p2 == undefined) return p1;
        return MATH.add(p1, p2);

    },
    /**
     * 减法运行
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _minus_: function (p1, p2) {
        if (arguments.length == 1) return -p1;

        //不要用if(!p1)  因为 p1=0 时，  if(!p1)成立

        if (p1 == undefined) return -p2;
        if (p2 == undefined) return p1;
        return MATH.sub(p1, p2);

    },

    /**
     * 取负
     * @param p1
     * @returns {*}
     * @private
     */
    _minus_unary: function (p1) {

        if (p1 == undefined) return null;

        return -p1;

    },


    /**
     * 乘法运算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _mul_: function (p1, p2) {
        if (p1 == undefined) return 0;
        if (p2 == undefined) return 0;
        return MATH.mul(p1, p2);

    },
    /**
     * 除法运行
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */
    _div_: function (p1, p2) {
        if (p1 == undefined) return null;
        if (p2 == undefined) return null;
        if (p2 == 0) return null;
        return MATH.div(p1, p2);

    },
    /**
     * 取模计算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */

    _mod_: function (p1, p2) {
        if (p1 == undefined) return null;
        if (p2 == undefined) return null;
        if (p2 == 0) return null;
        return p1 % p2;

    },
    /**
     * 取反运行
     * @param p1
     * @returns {*}
     * @private
     */
    _not_: function (p1) {
        if (p1 == undefined) return null;
        return !p1;

    },
    /**
     * 幂运算
     * @param p1
     * @param p2
     * @returns {*}
     * @private
     */

    _power_: function (p1, p2) {
        if (p1 == undefined) return null;
        if (p2 == undefined) return null;

        return Math.pow(p1, p2);

    }

}

export default OperatorFunc;
